/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields;

import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructureDefinition;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields.AbstractSingleByteField;
import java.util.List;

public class FormatStringField
extends AbstractSingleByteField {
    public static final String DEFAULT_NAME = "FormatString";
    public static final String DEFAULT_DESCRIPTION = "formatting options (type, justification and pin position)";
    public static final int DEFAULT_FORMAT_STRING_POSITION = 3;
    public static final PcscStructureDefinition DEFAULT_STRUCTURE = new PcscStructureDefinition(FormatStringField.class, 3);
    public static final int JUSTIFICATION_LEFT = 0;
    public static final int JUSTIFICATION_RIGHT = 1;
    public static final int FORMAT_TYPE_BINARY = 0;
    public static final int FORMAT_TYPE_BCD = 1;
    public static final int FORMAT_TYPE_STRING = 2;
    public static final List<Integer> JUSTIFICATION_VALUES = PcscStructure.Util.createUnmodifiableList(Integer.class, new int[]{0, 1});
    public static final List<Integer> FORMAT_TYPE_VALUES = PcscStructure.Util.createUnmodifiableList(Integer.class, new int[]{0, 1, 2});
    public static final byte BIT_MASK_SYSTEM_UNITS = -128;
    public static final byte BIT_MASK_PIN_POSITION = 120;
    public static final byte BIT_MASK_JUSTIFICATION = 4;
    public static final byte BIT_MASK_FORMAT_TYPE = 3;
    private static final boolean ENABLED_SYSTEM_UNITS_BITS = false;
    private static final boolean ENABLED_SYSTEM_UNITS_BYTES = true;
    private static final boolean ENABLED_JUSTIFICATION_LEFT = false;
    private static final boolean ENABLED_JUSTIFICATION_RIGHT = true;
    public static final int PIN_POSITION_MAXIMUM = 15;
    private static final int SHIFT_PIN_POSITION = 3;

    public FormatStringField(PcscStructure parent, int position) {
        super(parent, DEFAULT_NAME, DEFAULT_DESCRIPTION, position);
    }

    public void setSystemUnits(int systemUnits) {
        PcscStructure.Util.checkArgument(SYSTEM_UNIT_VALUES, systemUnits);
        switch (systemUnits) {
            case 0: {
                this.setBitMask((byte)-128, false);
                break;
            }
            case 1: {
                this.setBitMask((byte)-128, true);
                break;
            }
        }
    }

    public int getSystemUnits() {
        boolean enabled = this.isBitMaskSet((byte)-128);
        int result = -1;
        result = true == enabled ? 1 : 0;
        return result;
    }

    public void setPinPosition(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position of PIN expected greater equals than 0");
        }
        if (position > 15) {
            throw new IllegalArgumentException("position of PIN expected less equals than 15, but " + position);
        }
        this.iValue = (byte)(this.iValue | position << 3);
    }

    public int getPinPosition() {
        int value = this.iValue & 0x78;
        return value >>= 3;
    }

    public void setFormatType(int formatType) throws IllegalArgumentException {
        PcscStructure.Util.checkArgument(FORMAT_TYPE_VALUES, formatType);
        this.iValue = (byte)(this.iValue | formatType);
    }

    public int getFormatType() {
        return this.iValue & 3;
    }

    public void setJustification(int justification) {
        PcscStructure.Util.checkArgument(JUSTIFICATION_VALUES, justification);
        switch (justification) {
            case 0: {
                this.setBitMask((byte)4, false);
                break;
            }
            case 1: {
                this.setBitMask((byte)4, true);
                break;
            }
        }
    }

    public int getJustification() {
        boolean enabled = this.isBitMaskSet((byte)4);
        int result = -1;
        result = true == enabled ? 1 : 0;
        return result;
    }

    @Override
    public boolean intValid() {
        return true;
    }

    @Override
    public List<String> intGetSkippedStructureNameList() {
        return EMPTY_STRING_LIST;
    }

    @Override
    public String toString() {
        return super.toString() + "bits: " + PcscStructure.Util.toBitString(this.iValue) + "\nsystem units: " + (this.getSystemUnits() == 1 ? "bytes" : "bits") + "\nposition of PIN: " + this.getPinPosition() + "\njustification: " + (this.getJustification() == 0 ? "left" : "right") + "\nformat type: " + (this.getFormatType() == 2 ? "STRING" : (this.getFormatType() == 1 ? "BCD" : "BINARY")) + "\n";
    }
}

