/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields;

import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructureDefinition;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields.AbstractSingleByteField;
import java.util.List;

public class EntryValidationConditionField
extends AbstractSingleByteField {
    public static final String DEFAULT_NAME = "EntryValidationCondition";
    public static final String DEFAULT_DESCRIPTION = "conditions under which PIN entry should considered complete";
    public static final int DEFAULT_POSITION = 7;
    public static final PcscStructureDefinition DEFAULT_STRUCTURE = new PcscStructureDefinition(EntryValidationConditionField.class, 7);
    public static final byte BIT_MASK_MAX_SIZE_REACHED = 1;
    public static final byte BIT_MASK_VALIDATION_KEY_PRESSED = 2;
    public static final byte BIT_MASK_TIMEOUT_OCCURRED = 4;
    public static final byte BIT_MASK_ALL = 7;

    public EntryValidationConditionField(PcscStructure parent, int position) throws InstantiationException, IllegalAccessException {
        super(parent, DEFAULT_NAME, DEFAULT_DESCRIPTION, position);
    }

    public void setMaximumSizeReachedEnabled(boolean enabled) {
        this.setBitMask((byte)1, enabled);
    }

    public void setValidationKeyEnabled(boolean enabled) {
        this.setBitMask((byte)2, enabled);
    }

    public void setTimeoutEnabled(boolean enabled) {
        this.setBitMask((byte)4, enabled);
    }

    public void setAllEnabled(boolean enabled) {
        this.setBitMask((byte)7, enabled);
    }

    public boolean isMaximumSizeReachendEnabled() {
        return this.isBitMaskSet((byte)1);
    }

    public boolean isValidationKeyPressedEnabled() {
        return this.isBitMaskSet((byte)2);
    }

    public boolean isTimeoutOccuredEnabled() {
        return this.isBitMaskSet((byte)4);
    }

    public boolean isAllEnabled() {
        return this.isBitMaskSet((byte)7);
    }

    @Override
    public String toString() {
        return super.toString() + "bits: " + PcscStructure.Util.toBitString(this.iValue) + "\nmax size reached: " + this.isMaximumSizeReachendEnabled() + "\nvalidation key pressed: " + this.isValidationKeyPressedEnabled() + "\ntimeout occured: " + this.isTimeoutOccuredEnabled() + "\n";
    }

    @Override
    public boolean intValid() {
        return true;
    }

    @Override
    public List<String> intGetSkippedStructureNameList() {
        return EMPTY_STRING_LIST;
    }
}

