/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields;

import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields.AbstractSingleByteField;
import java.util.List;

public class ConfirmPINField
extends AbstractSingleByteField {
    public static final String DEFAULT_NAME = "ConfirmPIN";
    public static final String DEFAULT_DESCRIPTION = "flags governing need for confirmation of new PIN";
    public static final byte BIT_MASK_CONFIRMATION_REQUESTED = 1;
    public static final byte BIT_MASK_CURRENT_PIN_REQUESTED = 2;
    public static final byte BIT_MASK_ALL = 3;

    public ConfirmPINField(PcscStructure parent, int position) throws InstantiationException, IllegalAccessException {
        super(parent, DEFAULT_NAME, DEFAULT_DESCRIPTION, position);
    }

    public void setConfirmationRequestedEnabled(boolean enabled) {
        this.setBitMask((byte)1, enabled);
    }

    public void setCurrentPINRequestedEnabled(boolean enabled) {
        this.setBitMask((byte)2, enabled);
    }

    public void setAllEnabled(boolean enabled) {
        this.setBitMask((byte)3, enabled);
    }

    public boolean isConfirmationRequested() {
        return this.isBitMaskSet((byte)1);
    }

    public boolean isCurrentPINRequested() {
        return this.isBitMaskSet((byte)2);
    }

    public boolean isAllEnabled() {
        return this.isBitMaskSet((byte)3);
    }

    @Override
    public String toString() {
        return super.toString() + "bits: " + PcscStructure.Util.toBitString(this.iValue) + "\nconfirmation requested: " + this.isConfirmationRequested() + "\ncurrent PIN requested: " + this.isCurrentPINRequested() + "\n";
    }

    @Override
    public boolean intValid() {
        return true;
    }

    @Override
    public List<String> intGetSkippedStructureNameList() {
        return EMPTY_STRING_LIST;
    }
}

