/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields;

import de.bos_bremen.basecard.terminal.pcsc.handler.structures.AbstractPcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructureDefinition;
import de.bos_bremen.common.HexUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class CommandAPDUField
extends AbstractPcscStructure {
    public static final String SYSTEM_PROPERTY_KEY_ARCH = "sun.arch.data.model";
    public static final String KEY_ARCH_VALUE_32BIT = "32";
    public static final String KEY_ARCH_VALUE_64BIT = "64";
    public static final String DEFAULT_NAME = "CommandAPDU";
    public static final String DEFAULT_DESCRIPTION = "data length and data send to the ICC";
    public static final int DEFAULT_POSITION = 10;
    public static final PcscStructureDefinition DEFAULT_STRUCTURE = new PcscStructureDefinition(CommandAPDUField.class, 10);
    public static final int DEFAULT_LENGTH_BYTES_COUNT = 4;
    public static final int LENGTH_BYTES_COUNT_8 = 8;
    public static final byte[] DEFAULT_VALUE = new byte[0];
    protected byte[] value = DEFAULT_VALUE;
    protected int lengthBytesCount = 4;

    public CommandAPDUField(PcscStructure parent, int position) throws InstantiationException, IllegalAccessException {
        super(parent, DEFAULT_NAME, DEFAULT_DESCRIPTION, position, EMPTY_CHILD_STRUCTURE_DEFINITION_LIST);
    }

    @Override
    public void intDestroy() {
        this.value = DEFAULT_VALUE;
    }

    @Override
    public final byte[] intGetEncoded() {
        return this.value;
    }

    public int getLength() {
        byte[] commandBytes = this.getCommandAPDUBytes();
        return commandBytes != null ? commandBytes.length : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCommandAPDUBytes() {
        if (this.value == DEFAULT_VALUE) {
            return null;
        }
        byte[] byArray = this.value;
        synchronized (this.value) {
            byte[] tmp = new byte[this.value.length - this.lengthBytesCount];
            System.arraycopy(this.value, this.lengthBytesCount, tmp, 0, tmp.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommandAPDUBytes(byte[] command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command expected, but null");
        }
        CommandAPDUField commandAPDUField = this;
        synchronized (commandAPDUField) {
            byte[] tmp = new byte[this.lengthBytesCount + command.length];
            ByteBuffer lengthBuffer = ByteBuffer.wrap(tmp, 0, this.lengthBytesCount);
            ByteBuffer commandBuffer = ByteBuffer.wrap(tmp, this.lengthBytesCount, command.length);
            lengthBuffer.order(ByteOrder.LITTLE_ENDIAN);
            lengthBuffer.putInt(command.length);
            commandBuffer.put(command);
            byte[] byArray = this.value;
            synchronized (this.value) {
                this.value = tmp;
                // ** MonitorExit[var6_6] (shouldn't be in output)
            }
        }
    }

    @Override
    public final String toString() {
        byte[] cmd = this.getCommandAPDUBytes();
        return super.toString() + "length: " + this.getLength() + (String)(cmd != null ? "\nCommandAPDU: " + HexUtil.hexify(cmd) : "");
    }

    @Override
    public boolean intValid() {
        return true;
    }

    @Override
    public List<String> intGetSkippedStructureNameList() {
        return EMPTY_STRING_LIST;
    }

    public final synchronized void setLengthBytesCount(int lengthBytesCount) throws IllegalArgumentException {
        if (lengthBytesCount != 4 && lengthBytesCount != 8) {
            throw new IllegalArgumentException("not valid length '" + lengthBytesCount + "', only 4 or 8 are valid");
        }
        byte[] commandAPDUBytes = this.getCommandAPDUBytes();
        this.lengthBytesCount = lengthBytesCount;
        this.setCommandAPDUBytes(commandAPDUBytes);
    }
}

