/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields;

import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields.AbstractSingleByteField;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields.TimeoutField;

public abstract class AbstractTimeoutField
extends AbstractSingleByteField
implements TimeoutField {
    protected AbstractTimeoutField(PcscStructure parent, String name, String description, int position) throws IllegalArgumentException {
        super(parent, name, description, position);
    }

    @Override
    public void setTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("timeout in seconds expected to be greater equals than 0");
        }
        this.iValue = (byte)seconds;
    }

    @Override
    public final int getTimeout() {
        return 0xFFFFFFFF & this.iValue;
    }

    @Override
    public boolean intValid() {
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + "timeout: " + this.getTimeout() + " s\n";
    }

    @Override
    public final void setByte(byte value) {
        throw new IllegalArgumentException("use setTimeout() instead of setValue()");
    }

    @Override
    public void setBitMask(byte mask, boolean setOrClear) {
        throw new IllegalArgumentException("use setTimeout() instead of setBitMask()");
    }
}

