/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields;

import de.bos_bremen.basecard.terminal.pcsc.handler.structures.AbstractPcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields.DoubleByteField;
import java.util.List;

public abstract class AbstractDoubleByteField
extends AbstractPcscStructure
implements DoubleByteField {
    protected static final List<Integer> INDICES = PcscStructure.Util.createUnmodifiableList(Integer.class, new int[]{0, 1});
    private static final byte[] DEFAULT_VALUE = new byte[]{0, 0};
    private byte[] iValue = new byte[DEFAULT_VALUE.length];

    protected AbstractDoubleByteField(PcscStructure parent, String name, String description, int position) {
        super(parent, name, description, position, null);
    }

    @Override
    public void intDestroy() {
        this.iValue = DEFAULT_VALUE;
    }

    @Override
    public final byte[] intGetEncoded() {
        return this.iValue;
    }

    @Override
    public final void setFirstByte(byte value) {
        this.setByte(0, value);
    }

    @Override
    public final void setSecondByte(byte value) {
        this.setByte(1, value);
    }

    @Override
    public final byte getFirstByte() {
        return this.getByte(0);
    }

    @Override
    public final byte getSecondByte() {
        return this.getByte(1);
    }

    @Override
    public final void setByte(int idx, byte value) {
        PcscStructure.Util.checkArgument(INDICES, idx);
        this.iValue[idx] = value;
    }

    @Override
    public final byte getByte(int idx) {
        PcscStructure.Util.checkArgument(INDICES, idx);
        return this.iValue[idx];
    }

    @Override
    public final boolean isByteBitMaskSet(int idx, byte mask) {
        PcscStructure.Util.checkArgument(INDICES, idx);
        return (this.iValue[idx] & mask) == mask;
    }

    @Override
    public final boolean isFirstByteBitMaskSet(byte mask) {
        return this.isByteBitMaskSet(0, mask);
    }

    @Override
    public final boolean isSecondByteBitMaskSet(byte mask) {
        return this.isByteBitMaskSet(1, mask);
    }

    @Override
    public final void setByteBitMask(int idx, byte mask, boolean setOrClear) {
        PcscStructure.Util.checkArgument(INDICES, idx);
        this.iValue[idx] = PcscStructure.Util.setBitMask(this.iValue[idx], mask, setOrClear);
    }

    @Override
    public final void setFirstByteBitMask(byte mask, boolean setOrClear) {
        this.setByteBitMask(0, mask, setOrClear);
    }

    @Override
    public final void setSecondByteBitMask(byte mask, boolean setOrClear) {
        this.setByteBitMask(1, mask, setOrClear);
    }
}

