/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures;

import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructure;
import de.bos_bremen.common.StringRepresentable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PcscStructureDefinition
implements StringRepresentable {
    private static final Logger LOG = Logger.getLogger(PcscStructureDefinition.class);
    public static final PcscStructure EMPTY_ROOT_STRUCTURE = new EmptyPcscStructure();
    public static final List<Class<?>> CONSTRUCTOR_CLASSES_LIST = Collections.unmodifiableList(Arrays.asList(PcscStructure.class, Integer.TYPE));
    private static final Object[] CONSTRUCTOR_ARGUMENTS = new Object[]{EMPTY_ROOT_STRUCTURE, 0};
    private Class<? extends PcscStructure> iStructureClass = null;
    private int iPosition = 0;
    private Constructor<? extends PcscStructure> constructor = null;

    public PcscStructureDefinition(Class<? extends PcscStructure> structureClass, int position) throws IllegalArgumentException {
        if (structureClass == null) {
            throw new IllegalArgumentException("structure class expected, but null");
        }
        if (position < 0) {
            throw new IllegalArgumentException("position greater equals than 0 expected, but 0");
        }
        try {
            this.constructor = structureClass.getConstructor(CONSTRUCTOR_CLASSES_LIST.toArray(new Class[0]));
        }
        catch (SecurityException e) {
            this.constructor = null;
            throw new IllegalArgumentException("constructor of structure class " + structureClass + " not reachable");
        }
        catch (NoSuchMethodException nsme) {
            this.constructor = null;
            throw new IllegalArgumentException("structure class " + structureClass + " expected with constructor with arguments " + CONSTRUCTOR_CLASSES_LIST);
        }
        PcscStructure result = null;
        try {
            result = this.constructor.newInstance(CONSTRUCTOR_ARGUMENTS);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("new instance of structure class " + structureClass + " can not be created, wrong arguments");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("new instance of structure class " + structureClass + " can not be instantiated");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("new instance of structure class " + structureClass + " can not be created, illegal access");
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("new instance of structure class can not be created, invocation target failed");
        }
        if (result.getParent() != EMPTY_ROOT_STRUCTURE) {
            throw new IllegalArgumentException("created instance " + this.iStructureClass + " not possesses expected parent as used during instantation: " + EMPTY_ROOT_STRUCTURE + " (expected) <> (found) " + result.getParent());
        }
        if (result.getPosition() != this.iPosition) {
            throw new IllegalArgumentException("created instance " + this.iStructureClass + " not possesses expected position as used during instantation: " + this.iPosition + " (expected) <> (found) " + result.getPosition());
        }
        this.iStructureClass = structureClass;
        this.iPosition = position;
    }

    public Class<? extends PcscStructure> getStructureClass() {
        return this.iStructureClass;
    }

    public int getPosition() {
        return this.iPosition;
    }

    @Override
    public String toString() {
        return super.toString() + "(StructureClass:" + this.iStructureClass + ", Position: " + this.iPosition + ")";
    }

    public PcscStructure newInstance(PcscStructure parent) throws IllegalArgumentException {
        if (parent == EMPTY_ROOT_STRUCTURE) {
            throw new IllegalArgumentException("EMPTY_ROOT_STRUCTURE is not a valid parent");
        }
        PcscStructure result = null;
        try {
            result = this.constructor.newInstance(parent, this.iPosition);
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Object)"error instantiating PscsStructure", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.debug((Object)"error instantiating PscsStructure", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.debug((Object)"error instantiating PscsStructure", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.debug((Object)"error instantiating PscsStructure", (Throwable)e);
        }
        return result;
    }

    private static class EmptyPcscStructure
    implements PcscStructure {
        EmptyPcscStructure() {
        }

        @Override
        public void destroy() {
        }

        @Override
        public PcscStructure getChildByName(String name) {
            return null;
        }

        @Override
        public <T extends PcscStructure> T getChildByName(String name, Class<T> structureClass) {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public Collection<String> getChildNames() {
            return EMPTY_STRING_LIST;
        }

        @Override
        public Collection<PcscStructure> getChildStructureCollection() {
            return EMPTY_CHILD_STRUCTURE_LIST;
        }

        @Override
        public Map<String, PcscStructure> getChildStructureMap() {
            return EMPTY_CHILD_STRUCTURE_MAP;
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public byte[] getEncoded() {
            return new byte[0];
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public PcscStructure getParent() {
            return ROOT_PARENT;
        }

        @Override
        public int getPosition() {
            return 0;
        }

        @Override
        public List<String> getSkippedStructureNameList() {
            return EMPTY_STRING_LIST;
        }

        @Override
        public int getStructureLength() {
            return 0;
        }

        @Override
        public boolean isChild() {
            return false;
        }

        @Override
        public boolean isComplexStructure() {
            return true;
        }

        @Override
        public boolean isDestroyed() {
            return false;
        }

        @Override
        public boolean isRoot() {
            return true;
        }

        @Override
        public boolean isSimpleStructure() {
            return false;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }
}

