/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures;

import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructureDefinition;
import de.bos_bremen.common.StringRepresentable;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public interface PcscStructure
extends StringRepresentable {
    public static final Class<?> ARRAY_CLASS_SHORT = short[].class;
    public static final Class<?> ARRAY_CLASS_INT = int[].class;
    public static final Class<?> ARRAY_CLASS_LONG = long[].class;
    public static final Class<?> ARRAY_CLASS_DOUBLE = double[].class;
    public static final Class<?> ARRAY_CLASS_FLOAT = float[].class;
    public static final Class<?> ARRAY_CLASS_BOOLEAN = boolean[].class;
    public static final List<Class<?>> PRIMITIVE_ARRAY_CLASSES = Collections.unmodifiableList(Arrays.asList(ARRAY_CLASS_INT, ARRAY_CLASS_SHORT, ARRAY_CLASS_LONG, ARRAY_CLASS_DOUBLE, ARRAY_CLASS_FLOAT, ARRAY_CLASS_BOOLEAN));
    public static final List<String> EMPTY_STRING_LIST = Collections.unmodifiableList(new ArrayList());
    public static final Map<String, PcscStructure> EMPTY_CHILD_STRUCTURE_MAP = Collections.unmodifiableMap(new HashMap());
    public static final Collection<PcscStructure> EMPTY_CHILD_STRUCTURE_LIST = Collections.unmodifiableCollection(new ArrayList());
    public static final List<PcscStructureDefinition> EMPTY_CHILD_STRUCTURE_DEFINITION_LIST = Collections.unmodifiableList(new ArrayList());
    public static final String EMPTY_STRING = "";
    public static final String NO_NAME = "";
    public static final String NO_DESCRIPTION = "";
    public static final int MINIMUM_POSITION = 0;
    public static final int CDEFAULT_POSITION = 0;
    public static final PcscStructure ROOT_PARENT;
    public static final PcscStructure DEFAULT_PARENT;
    public static final byte FULL_BIT_MASK = -1;
    public static final int SYSTEM_UNITS_BYTES = 1;
    public static final int SYSTEM_UNITS_BITS = 0;
    public static final List<Integer> SYSTEM_UNIT_VALUES;

    public String getName();

    public String getDescription();

    public Map<String, PcscStructure> getChildStructureMap();

    public Collection<PcscStructure> getChildStructureCollection();

    public Collection<String> getChildNames();

    public PcscStructure getChildByName(String var1);

    public <T extends PcscStructure> T getChildByName(String var1, Class<T> var2);

    public int getChildCount();

    public int getPosition();

    public int getStructureLength();

    public byte[] getEncoded();

    public void destroy();

    public boolean isDestroyed();

    public List<String> getSkippedStructureNameList();

    public PcscStructure getParent();

    public boolean isRoot();

    public boolean isChild();

    public boolean isSimpleStructure();

    public boolean isComplexStructure();

    public boolean isValid();

    @Override
    public String toString();

    static {
        DEFAULT_PARENT = ROOT_PARENT = null;
        SYSTEM_UNIT_VALUES = Util.createUnmodifiableList(Integer.class, new int[]{0, 1});
    }

    public static final class Util {
        public static final boolean BIT_MASK_SET = true;
        public static final boolean BIT_MASK_CLEAR = false;

        private Util() {
        }

        public static <T, S> List<T> createUnmodifiableList(Class<T> listClass, S values) {
            if (listClass == null) {
                throw new IllegalArgumentException("Class as parameter for list expected, but null");
            }
            if (values != null && !values.getClass().isArray()) {
                throw new IllegalArgumentException("values as array expected");
            }
            if (values != null && PRIMITIVE_ARRAY_CLASSES.indexOf(values.getClass()) < 0) {
                throw new IllegalArgumentException("array represents not a primitive array Class");
            }
            List<Object> result = new ArrayList();
            Object tmp = null;
            if (values != null && Array.getLength(values) > 0 && listClass.isInstance(Array.get(values, 0))) {
                for (int i = 0; i < Array.getLength(values); ++i) {
                    Object o = Array.get(values, i);
                    if (!listClass.isInstance(o)) {
                        throw new IllegalArgumentException("array contains an value of " + o.getClass() + " not castable to " + listClass);
                    }
                    tmp = listClass.cast(o);
                    result.add(tmp);
                }
            }
            result = Collections.unmodifiableList(result);
            return result;
        }

        public static String toBitString(byte value) {
            String result = null;
            BigInteger bi = new BigInteger(new byte[]{1, value});
            String bitString = bi.toString(2);
            result = bitString.substring(bitString.length() - 8);
            return result;
        }

        public static void checkArgument(List<Integer> admittedValues, int argument) {
            Util.checkArgument(Integer.class, admittedValues, argument);
        }

        private static <T, S> void checkArgument(Class<T> listClass, List<T> admittedValues, S argument) {
            if (!listClass.isInstance(argument)) {
                throw new IllegalArgumentException("illegal argument, not castable to Class of admitted values");
            }
            if (admittedValues.indexOf(argument) < 0) {
                throw new IllegalArgumentException("illegal argument, expected one of " + admittedValues + ", but found: " + argument);
            }
        }

        public static Map<String, PcscStructure> createChildStructureMap(PcscStructure parent, List<PcscStructureDefinition> childStructureDefinitionList) {
            Collection<PcscStructure> structureCollection = Util.createChildStructureCollection(parent, childStructureDefinitionList);
            return Util.createChildStructureMap(structureCollection);
        }

        private static Collection<PcscStructure> createChildStructureCollection(PcscStructure parent, List<PcscStructureDefinition> childStructureDefinitionList) {
            if (childStructureDefinitionList == null || childStructureDefinitionList.isEmpty()) {
                return EMPTY_CHILD_STRUCTURE_LIST;
            }
            LinkedList<PcscStructure> result = new LinkedList();
            PcscStructure tmpStructure = null;
            for (PcscStructureDefinition tmpDefinition : childStructureDefinitionList) {
                if (tmpDefinition == null) {
                    throw new IllegalArgumentException("structure definition not admitted as null");
                }
                tmpStructure = tmpDefinition.newInstance(parent);
                result.add(tmpStructure);
            }
            result = Collections.unmodifiableCollection(result);
            return result;
        }

        private static Map<String, PcscStructure> createChildStructureMap(Collection<PcscStructure> childStructureCollection) {
            if (childStructureCollection == null || childStructureCollection.isEmpty()) {
                return EMPTY_CHILD_STRUCTURE_MAP;
            }
            LinkedHashMap<String, PcscStructure> result = new LinkedHashMap();
            PcscStructure parent = null;
            int position = -1;
            for (PcscStructure tmp : childStructureCollection) {
                if (tmp == null) {
                    throw new IllegalArgumentException("structure not admitted as null");
                }
                if (parent == null) {
                    parent = tmp.getParent();
                }
                if (parent != tmp.getParent()) {
                    throw new IllegalArgumentException("more thane one parent found for child structures, at least " + Util.getPcscStructureName(parent) + " and " + Util.getPcscStructureName(tmp.getParent()));
                }
                if (tmp.getPosition() <= position) {
                    PcscStructure previous = result.values().toArray(new PcscStructure[result.size()])[result.size() - 1];
                    throw new IllegalArgumentException("child structures in incorrect order, not ascending order: previous position was " + position + " and next position should be " + tmp.getPosition() + ", structure: " + tmp.getName() + ", last structure/position: " + previous.getName() + "/" + previous.getPosition());
                }
                position = tmp.getPosition();
                if (result.containsKey(tmp.getName())) {
                    throw new IllegalArgumentException("structure with same name already exists at result Map, double entry for structure with name " + tmp.getName());
                }
                result.put(tmp.getName(), tmp);
            }
            result = Collections.unmodifiableMap(result);
            return result;
        }

        public static String getPcscStructureName(PcscStructure structure) {
            return structure != null ? structure.getName() : null;
        }

        public static byte setBitMask(byte value, byte mask, boolean setOrClear) {
            byte lValue = value;
            if (setOrClear) {
                lValue = (byte)(lValue | mask);
            } else {
                byte inverseMask = (byte)(0xFFFFFFFF ^ mask);
                lValue = (byte)(lValue & inverseMask);
            }
            return lValue;
        }
    }
}

