/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures;

import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructureDefinition;
import de.bos_bremen.common.HexUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractPcscStructure
implements PcscStructure {
    private static final Logger LOG = Logger.getLogger(AbstractPcscStructure.class);
    private String iName = "";
    private String iDescription = "";
    private Map<String, PcscStructure> childStructureMap = EMPTY_CHILD_STRUCTURE_MAP;
    private int iPosition = 0;
    private PcscStructure parent = DEFAULT_PARENT;
    private boolean destroyed = false;

    public AbstractPcscStructure(PcscStructure parent, String name, String description, int position, List<PcscStructureDefinition> childStructureDefinitionList) throws IllegalArgumentException {
        this.checkArgs(name, description, position);
        this.parent = parent;
        this.iName = name;
        this.iDescription = description;
        this.iPosition = position;
        this.childStructureMap = PcscStructure.Util.createChildStructureMap(this, childStructureDefinitionList);
    }

    @Override
    public final Collection<PcscStructure> getChildStructureCollection() {
        if (EMPTY_CHILD_STRUCTURE_MAP == this.childStructureMap) {
            return EMPTY_CHILD_STRUCTURE_LIST;
        }
        return Collections.unmodifiableCollection(this.childStructureMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] getEncoded() {
        byte[] result = null;
        if (EMPTY_CHILD_STRUCTURE_MAP != this.childStructureMap && this.childStructureMap != null && this.childStructureMap.size() > 0) {
            Map<String, PcscStructure> map = this.childStructureMap;
            synchronized (map) {
                try {
                    ArrayList<String> skippedList = new ArrayList<String>();
                    for (PcscStructure tmp : this.childStructureMap.values()) {
                        skippedList.addAll(tmp.getSkippedStructureNameList());
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] data = null;
                    for (PcscStructure tmp : this.childStructureMap.values()) {
                        if (skippedList.indexOf(tmp.getName()) >= 0 || (data = tmp.getEncoded()) == null || data.length <= 0) continue;
                        baos.write(data);
                    }
                    baos.flush();
                    baos.close();
                    result = baos.toByteArray();
                }
                catch (IOException ioe) {
                    LOG.debug((Object)"error using ByteArrayOutputStream", (Throwable)ioe);
                }
            }
        }
        result = this.intGetEncoded();
        return result;
    }

    @Override
    public final int getStructureLength() {
        return this.getEncoded().length;
    }

    @Override
    public final String getName() {
        return this.iName;
    }

    @Override
    public final String getDescription() {
        return this.iDescription;
    }

    @Override
    public final Map<String, PcscStructure> getChildStructureMap() {
        return this.childStructureMap;
    }

    @Override
    public final int getPosition() {
        return this.iPosition;
    }

    @Override
    public final int getChildCount() {
        return this.childStructureMap.size();
    }

    @Override
    public final boolean isSimpleStructure() {
        return this.getChildCount() == 0;
    }

    @Override
    public final boolean isComplexStructure() {
        return !this.isSimpleStructure();
    }

    @Override
    public final PcscStructure getParent() {
        return this.parent;
    }

    @Override
    public final boolean isRoot() {
        return this.getParent() == ROOT_PARENT;
    }

    @Override
    public final boolean isChild() {
        return !this.isRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isValid() {
        AbstractPcscStructure abstractPcscStructure = this;
        synchronized (abstractPcscStructure) {
            boolean result = true;
            if ((result &= !this.isDestroyed()) && EMPTY_CHILD_STRUCTURE_MAP != this.childStructureMap && this.childStructureMap != null && this.childStructureMap.size() > 0) {
                ArrayList<String> skippedList = new ArrayList<String>();
                for (PcscStructure tmp : this.childStructureMap.values()) {
                    skippedList.addAll(tmp.getSkippedStructureNameList());
                }
                for (PcscStructure tmp : this.childStructureMap.values()) {
                    if (tmp == null || skippedList.indexOf(tmp.getName()) >= 0) continue;
                    PcscStructure pcscStructure = tmp;
                    synchronized (pcscStructure) {
                        if (!(result &= tmp.isValid())) {
                            break;
                        }
                    }
                }
            }
            if (result) {
                result &= this.intValid();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        AbstractPcscStructure abstractPcscStructure = this;
        synchronized (abstractPcscStructure) {
            this.destroyed = true;
            this.iName = "";
            this.iDescription = "";
            this.childStructureMap = EMPTY_CHILD_STRUCTURE_MAP;
            this.iPosition = 0;
            this.parent = DEFAULT_PARENT;
            if (EMPTY_CHILD_STRUCTURE_MAP != this.childStructureMap && this.childStructureMap != null && this.childStructureMap.size() > 0) {
                for (PcscStructure tmp : this.childStructureMap.values()) {
                    if (tmp == null) continue;
                    PcscStructure pcscStructure = tmp;
                    synchronized (pcscStructure) {
                        tmp.destroy();
                    }
                }
            }
            this.intDestroy();
        }
    }

    @Override
    public final PcscStructure getChildByName(String name) {
        return this.childStructureMap.get(name);
    }

    @Override
    public final <T extends PcscStructure> T getChildByName(String name, Class<T> structureClass) {
        PcscStructure result = null;
        PcscStructure tmp = this.childStructureMap.get(name);
        if (structureClass.isInstance(tmp)) {
            result = (PcscStructure)structureClass.cast(tmp);
        } else if (tmp != null) {
            throw new IllegalArgumentException("Class of found child structure does not match expected Class, found " + tmp.getClass() + ", expected " + structureClass);
        }
        return (T)result;
    }

    @Override
    public final Collection<String> getChildNames() {
        return Collections.unmodifiableSet(this.childStructureMap.keySet());
    }

    @Override
    public final boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<String> getSkippedStructureNameList() {
        ArrayList<String> result = new ArrayList<String>();
        AbstractPcscStructure abstractPcscStructure = this;
        synchronized (abstractPcscStructure) {
            if (EMPTY_CHILD_STRUCTURE_MAP != this.childStructureMap && this.childStructureMap != null && this.childStructureMap.size() > 0) {
                ArrayList<String> skippedList = new ArrayList<String>();
                for (PcscStructure tmp : this.childStructureMap.values()) {
                    skippedList.addAll(tmp.getSkippedStructureNameList());
                }
                List<String> tmpList = null;
                for (PcscStructure tmp : this.childStructureMap.values()) {
                    if (tmp == null || skippedList.indexOf(tmp.getName()) >= 0) continue;
                    PcscStructure pcscStructure = tmp;
                    synchronized (pcscStructure) {
                        tmpList = tmp.getSkippedStructureNameList();
                        if (tmpList != null && tmpList.size() > 0) {
                            result.addAll(tmpList);
                        }
                    }
                }
            }
            result.addAll(this.intGetSkippedStructureNameList());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public String toString() {
        return super.toString() + "\nname: " + this.iName + "\ndescription: " + this.iDescription + "\nposition: " + this.iPosition + "\nparent: " + (!this.isRoot() ? this.parent.getName() : "-") + "\nsimple: " + this.isSimpleStructure() + "\nvalid: " + this.isValid() + "\nbinary:\n" + HexUtil.dump(this.getEncoded());
    }

    public abstract boolean intValid();

    public abstract void intDestroy();

    public abstract byte[] intGetEncoded();

    public abstract List<String> intGetSkippedStructureNameList();

    private void checkArgs(String name, String description, int position) {
        if (name == null) {
            throw new IllegalArgumentException("name expected, but null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name expected, but empty");
        }
        if (description == null) {
            throw new IllegalArgumentException("description expected, but null");
        }
        if (description.length() == 0) {
            throw new IllegalArgumentException("description expected, but empty");
        }
        if (position < 0) {
            throw new IllegalArgumentException("position greater equals than 0 expected, but found: " + position);
        }
    }
}

