/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.impl;

import de.bos_bremen.basecard.common.pin.PinVerifyParameters;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.basecard.terminal.pcsc.handler.impl.AbstractPcsc20PinStructureHandler;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.AbstractPinStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PinModifyStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PinVerifyStructure;
import de.bos_bremen.common.system.LanguageEnum;

public class Pcsc20PinStructureHandlerOmnikeyDeprecated
extends AbstractPcsc20PinStructureHandler {
    public static final String SYSTEM_PROPERTY_KEY_ARCH = "sun.arch.data.model";
    public static final String SYSTEM_PROPERTY_OS_NAME = "os.name";
    public static final String ARCH_VALUE_32BIT = "32";
    public static final String ARCH_VALUE_64BIT = "64";
    public static final String OS_NAME_WINDOWS = "windows";

    Pcsc20PinStructureHandlerOmnikeyDeprecated() {
    }

    @Override
    void checkSpecific(PinVerifyParameters params) throws IllegalArgumentException {
        if (params.getEncoder() == PinEncoder.ENCODER_BCD && params.getPadByte() == null) {
            throw new IllegalArgumentException("unpadded BCD format currently not supported for this card reader");
        }
    }

    @Override
    PinVerifyStructure buildPinVerifyStructureInt(PinEncoder encoder, int firstTimeout, int secondTimeout, int formatStringSystemUnits, int formatStringPinPosition, int formatStringJustification, int formatStringFormatType, int pinBlockBitSizePinLength, int pinBlockByteSizePinBlock, int pinLengthSystemUnits, int pinLengthPosition, int maxDigitMinimum, int maxDigitMaximum, boolean validationTimeout, boolean validationMaximum, boolean validationKey, LanguageEnum language, int[] messageIDs, byte[] commandToPerform) throws IllegalArgumentException {
        PinVerifyStructure pvs = new PinVerifyStructure();
        pvs.getFirstTimeout().setTimeout(firstTimeout);
        pvs.getSecondTimeout().setTimeout(secondTimeout);
        pvs.getFormatString().setSystemUnits(formatStringSystemUnits);
        pvs.getFormatString().setPinPosition(formatStringPinPosition);
        pvs.getFormatString().setJustification(formatStringJustification);
        pvs.getFormatString().setFormatType(formatStringFormatType);
        pvs.getPINBlockString().setBitSizeOfPINLength(pinBlockBitSizePinLength);
        pvs.getPINBlockString().setByteSizeOfPINBlock(pinBlockByteSizePinBlock);
        pvs.getPINLengthFormat().setSystemUnits(pinLengthSystemUnits);
        pvs.getPINLengthFormat().setPinLengthPosition(pinLengthPosition);
        pvs.getPINMaxExtraDigit().setMinimum(encoder, maxDigitMinimum);
        pvs.getPINMaxExtraDigit().setMaximum(encoder, maxDigitMaximum);
        pvs.getEntryValidationCondition().setTimeoutEnabled(validationTimeout);
        pvs.getEntryValidationCondition().setMaximumSizeReachedEnabled(validationMaximum);
        pvs.getEntryValidationCondition().setValidationKeyEnabled(validationKey);
        pvs.getMessages().useCCIDDefaultMessages(language, messageIDs);
        pvs.getCommandAPDU().setCommandAPDUBytes(commandToPerform);
        this.adjustLengthBytesCount(pvs);
        return pvs;
    }

    private void adjustLengthBytesCount(AbstractPinStructure aps) {
        if (!System.getProperty(SYSTEM_PROPERTY_OS_NAME).toLowerCase().contains(OS_NAME_WINDOWS) && System.getProperty(SYSTEM_PROPERTY_KEY_ARCH, ARCH_VALUE_32BIT).equals(ARCH_VALUE_64BIT)) {
            aps.getCommandAPDU().setLengthBytesCount(8);
        }
    }

    @Override
    PinModifyStructure buildPinModifyStructureInt(PinEncoder encoder, int firstTimeout, int secondTimeout, int formatStringSystemUnits, int formatStringPinPosition, int formatStringJustification, int formatStringFormatType, int pinBlockBitSizePinLength, int pinBlockByteSizePinBlock, int pinLengthSystemUnits, int pinLengthPosition, int insertionOffsetOld, int insertionOffsetNew, int maxDigitMinimum, int maxDigitMaximum, boolean confirmPinOld, boolean confirmPinNew, boolean validationTimeout, boolean validationMaximum, boolean validationKey, LanguageEnum language, int[] messageIDs, byte[] commandToPerform) throws IllegalArgumentException {
        PinModifyStructure pms = new PinModifyStructure();
        pms.getFirstTimeout().setTimeout(firstTimeout);
        pms.getSecondTimeout().setTimeout(secondTimeout);
        pms.getFormatString().setSystemUnits(formatStringSystemUnits);
        pms.getFormatString().setPinPosition(formatStringPinPosition);
        pms.getFormatString().setJustification(formatStringJustification);
        pms.getFormatString().setFormatType(formatStringFormatType);
        pms.getPINBlockString().setBitSizeOfPINLength(pinBlockBitSizePinLength);
        pms.getPINBlockString().setByteSizeOfPINBlock(pinBlockByteSizePinBlock);
        pms.getPINLengthFormat().setSystemUnits(pinLengthSystemUnits);
        pms.getPINLengthFormat().setPinLengthPosition(pinLengthPosition);
        pms.getInsertionOffsetOld().setOffset(insertionOffsetOld);
        pms.getInsertionOffsetNew().setOffset(insertionOffsetNew);
        pms.getPINMaxExtraDigit().setMinimum(encoder, maxDigitMinimum);
        pms.getPINMaxExtraDigit().setMaximum(encoder, maxDigitMaximum);
        pms.getConfirmPIN().setCurrentPINRequestedEnabled(confirmPinOld);
        pms.getConfirmPIN().setConfirmationRequestedEnabled(confirmPinNew);
        pms.getEntryValidationCondition().setTimeoutEnabled(validationTimeout);
        pms.getEntryValidationCondition().setMaximumSizeReachedEnabled(validationMaximum);
        pms.getEntryValidationCondition().setValidationKeyEnabled(validationKey);
        pms.getMessages().setMessages(language, messageIDs);
        pms.getCommandAPDU().setCommandAPDUBytes(commandToPerform);
        this.adjustLengthBytesCount(pms);
        return pms;
    }
}

