/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.impl;

import de.bos_bremen.basecard.terminal.pcsc.handler.Pcsc20PinStructureHandler;
import de.bos_bremen.basecard.terminal.pcsc.handler.impl.Pcsc20PinStructureHandlerGeneral;
import de.bos_bremen.basecard.terminal.pcsc.handler.impl.Pcsc20PinStructureHandlerKobil;
import de.bos_bremen.basecard.terminal.pcsc.handler.impl.Pcsc20PinStructureHandlerOmnikey;
import de.bos_bremen.basecard.terminal.pcsc.handler.impl.Pcsc20PinStructureHandlerOmnikeyDeprecated;
import de.bos_bremen.basecard.terminal.pcsc.handler.impl.Pcsc20PinStructureHandlerReiner;
import de.bos_bremen.basecard.terminal.pcsc.handler.impl.Pcsc20PinStructureHandlerReinerPinpad;
import java.util.HashMap;
import java.util.Map;

public final class Pcsc20PinStructureHandlerFactory {
    public static final String CARDTERMINAL_MANUFACTURER_REINER_LINUX_PP_A = "pp_a";
    public static final String CARDTERMINAL_MANUFACTURER_KOBIL = "kobil";
    public static final String CARDTERMINAL_MANUFACTURER_OMNIKEY = "omnikey";
    public static final String CARDTERMINAL_MANUFACTURER_REINER = "reiner";
    private static final Integer ID_GENERAL = 0;
    private static final Integer ID_KOBIL = ID_GENERAL + 1;
    private static final Integer ID_REINER = ID_KOBIL + 1;
    private static final Integer ID_OMNIKEY = ID_REINER + 1;
    private static final Integer ID_OMNIKEY_DEPRECATED = ID_OMNIKEY + 1;
    private static final Integer ID_REINER_PINPAD = ID_OMNIKEY_DEPRECATED + 1;
    private static Map<Integer, Pcsc20PinStructureHandler> handlerMap = new HashMap<Integer, Pcsc20PinStructureHandler>();

    private Pcsc20PinStructureHandlerFactory() {
    }

    public static synchronized Pcsc20PinStructureHandler getHandler(String terminalName) {
        Pcsc20PinStructureHandler result;
        if (terminalName.toLowerCase().indexOf(CARDTERMINAL_MANUFACTURER_KOBIL) != -1) {
            result = handlerMap.get(ID_KOBIL);
            if (result == null) {
                result = new Pcsc20PinStructureHandlerKobil();
                handlerMap.put(ID_KOBIL, result);
            }
        } else if (terminalName.toLowerCase().indexOf(CARDTERMINAL_MANUFACTURER_REINER) != -1) {
            if (terminalName.toLowerCase().indexOf(CARDTERMINAL_MANUFACTURER_REINER_LINUX_PP_A) != -1 && System.getProperty("os.name").toLowerCase().indexOf("linux") != -1) {
                result = handlerMap.get(ID_REINER_PINPAD);
                if (result == null) {
                    result = new Pcsc20PinStructureHandlerReinerPinpad();
                    handlerMap.put(ID_REINER_PINPAD, result);
                }
            } else {
                result = handlerMap.get(ID_REINER);
                if (result == null) {
                    result = new Pcsc20PinStructureHandlerReiner();
                    handlerMap.put(ID_REINER, result);
                }
            }
        } else if (!terminalName.toLowerCase().startsWith("#") && terminalName.toLowerCase().indexOf(CARDTERMINAL_MANUFACTURER_OMNIKEY) != -1) {
            result = handlerMap.get(ID_OMNIKEY);
            if (result == null) {
                result = new Pcsc20PinStructureHandlerOmnikey();
                handlerMap.put(ID_OMNIKEY, result);
            }
        } else if (terminalName.toLowerCase().startsWith("#") && terminalName.toLowerCase().indexOf(CARDTERMINAL_MANUFACTURER_OMNIKEY) != -1) {
            result = handlerMap.get(ID_OMNIKEY_DEPRECATED);
            if (result == null) {
                result = new Pcsc20PinStructureHandlerOmnikeyDeprecated();
                handlerMap.put(ID_OMNIKEY_DEPRECATED, result);
            }
        } else {
            result = handlerMap.get(ID_GENERAL);
            if (result == null) {
                result = new Pcsc20PinStructureHandlerGeneral();
                handlerMap.put(ID_GENERAL, result);
            }
        }
        return result;
    }
}

