/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.impl;

import de.bos_bremen.basecard.common.pin.PinModifyParameters;
import de.bos_bremen.basecard.common.pin.PinVerifyParameters;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.basecard.terminal.pcsc.handler.Pcsc20PinStructureHandler;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.AbstractPinStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PinModifyStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PinVerifyStructure;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.system.LanguageEnum;

public abstract class AbstractPcsc20PinStructureHandler
implements Pcsc20PinStructureHandler {
    AbstractPcsc20PinStructureHandler() {
    }

    abstract void checkSpecific(PinVerifyParameters var1) throws IllegalArgumentException;

    @Override
    public final AbstractPinStructure buildPinOperationStructure(PinVerifyParameters params) throws IllegalArgumentException {
        if (params == null) {
            throw new IllegalArgumentException("null params not permitted");
        }
        if (params instanceof PinModifyParameters) {
            if (this.check(params)) {
                return this.buildPinModifyStructurePaddedInt((PinModifyParameters)params);
            }
            return this.buildPinModifyStructureEmptyInt((PinModifyParameters)params);
        }
        if (this.check(params)) {
            return this.buildPinVerifyStructurePaddedInt(params);
        }
        return this.buildPinVerifyStructureEmptyInt(params);
    }

    @Override
    public final PinModifyStructure buildPinModifyStructureNPA(int firstTimeout, int secondTimeout, LanguageEnum language) throws IllegalArgumentException {
        AssertUtil.notNull(language, "language enum");
        byte[] cmd = HexUtil.parse("002C0203");
        return this.buildPinModifyStructureInt(PinEncoder.ENCODER_T50, firstTimeout, secondTimeout, 1, 0, 0, PinEncoder.ENCODER_T50.getCCIDID(), 0, 0, 0, 0, 0, 0, 6, 6, false, true, false, false, true, language, new int[]{0, 1, 2}, cmd);
    }

    private boolean check(PinVerifyParameters params) throws IllegalArgumentException {
        this.checkSpecific(params);
        if (params instanceof PinModifyParameters) {
            return AbstractPcsc20PinStructureHandler.checkModify(params.getEncoder(), params.getBlockLength(), params.getPadByte(), params.encodePinLength(), params.getMinPinLength(), params.getMaxPinLength(), ((PinModifyParameters)params).getInitPin());
        }
        return AbstractPcsc20PinStructureHandler.checkVerify(params.getEncoder(), params.getBlockLength(), params.getPadByte(), params.encodePinLength(), params.getMaxPinLength());
    }

    private static boolean checkVerify(PinEncoder encoder, Integer blockLength, Byte padByte, boolean encodePinLength, int maxPinLength) throws IllegalArgumentException {
        if (padByte == null || blockLength == -1 || blockLength == 0) {
            return false;
        }
        AbstractPcsc20PinStructureHandler.checkLengthParams(encoder, blockLength, padByte, encodePinLength);
        AbstractPcsc20PinStructureHandler.checkRequestedPinLength(encoder, blockLength, encodePinLength, maxPinLength);
        return true;
    }

    private static boolean checkModify(PinEncoder encoder, Integer blockLength, Byte padByte, boolean encodePinLength, int minPinLength, int maxPinLength, byte[] initPin) throws IllegalArgumentException {
        boolean usePadding;
        if (padByte == null || blockLength == -1 || blockLength == 0) {
            usePadding = false;
        } else {
            usePadding = true;
            AbstractPcsc20PinStructureHandler.checkLengthParams(encoder, blockLength, padByte, encodePinLength);
            AbstractPcsc20PinStructureHandler.checkRequestedPinLength(encoder, blockLength, encodePinLength, maxPinLength);
            if (initPin != null) {
                if (initPin.length > maxPinLength) {
                    throw new IllegalArgumentException("initial pin longer than maximum pin length");
                }
                if (initPin.length < minPinLength) {
                    throw new IllegalArgumentException("initial pin shorter than minimum pin length");
                }
            }
        }
        return usePadding;
    }

    PinVerifyStructure buildPinVerifyStructurePaddedInt(PinVerifyParameters params) throws IllegalArgumentException {
        PinEncoder encoder = params.getEncoder();
        if (encoder == null || params.getLanguage() == null) {
            throw new IllegalArgumentException("null not permitted!");
        }
        boolean encodePinLength = params.encodePinLength();
        byte[] commandToPerform = ArrayUtil.isNullOrEmpty(params.getTemplate()) ? AbstractPcsc20PinStructureHandler.buildPinCommandBytes(encoder, params.getPinID(), params.getBlockLength(), params.getPadByte(), encodePinLength, false, null) : params.getTemplate();
        PinVerifyStructure pvs = this.buildPinVerifyStructureInt(encoder, params.getFirstTimeout(), params.getSecondTimeout(), 1, encodePinLength ? 1 : 0, 0, encoder.getCCIDID(), encodePinLength ? 4 : 0, params.getBlockLength() - (encodePinLength ? 1 : 0), 0, encodePinLength ? 4 : 0, params.getMinPinLength(), params.getMaxPinLength(), false, false, true, params.getLanguage(), new int[]{0}, commandToPerform);
        return pvs;
    }

    PinVerifyStructure buildPinVerifyStructureEmptyInt(PinVerifyParameters params) throws IllegalArgumentException {
        PinEncoder encoder = params.getEncoder();
        if (encoder == null || params.getLanguage() == null) {
            throw new IllegalArgumentException("null not permitted!");
        }
        byte[] commandToPerform = ArrayUtil.isNullOrEmpty(params.getTemplate()) ? AbstractPcsc20PinStructureHandler.buildPinVerifyCommandBytes(params.getPinID(), params.usesCCID()) : params.getTemplate();
        boolean encodePinLength = params.encodePinLength();
        PinVerifyStructure pvs = this.buildPinVerifyStructureInt(encoder, params.getFirstTimeout(), params.getSecondTimeout(), 1, encodePinLength ? 1 : 0, 0, params.getEncoder().getCCIDID(), encodePinLength ? 4 : 0, 0, 0, encodePinLength ? 12 : 0, params.getMinPinLength(), params.getMaxPinLength(), false, false, true, params.getLanguage(), new int[]{0}, commandToPerform);
        return pvs;
    }

    PinModifyStructure buildPinModifyStructurePaddedInt(PinModifyParameters params) throws IllegalArgumentException {
        int[] nArray;
        PinEncoder encoder = params.getEncoder();
        if (encoder == null || params.getLanguage() == null) {
            throw new IllegalArgumentException("null not permitted!");
        }
        byte[] initPin = params.getInitPin();
        int blockLengthInt = params.getBlockLength() > 0 ? params.getBlockLength() : (initPin != null && initPin.length > 0 ? initPin.length : 0);
        boolean encodePinLength = params.encodePinLength();
        byte[] commandToPerform = ArrayUtil.isNullOrEmpty(params.getTemplate()) ? AbstractPcsc20PinStructureHandler.buildPinCommandBytes(encoder, params.getPinID(), blockLengthInt, params.getPadByte(), encodePinLength, true, initPin) : params.getTemplate();
        int n = params.getFirstTimeout();
        int n2 = params.getSecondTimeout();
        int n3 = encodePinLength ? 1 : 0;
        byte by = encoder.getCCIDID();
        int n4 = encodePinLength ? 4 : 0;
        int n5 = blockLengthInt - (encodePinLength ? 1 : 0);
        int n6 = encodePinLength ? 4 : 0;
        int n7 = params.getMinPinLength();
        int n8 = params.getMaxPinLength();
        boolean bl = initPin == null;
        LanguageEnum languageEnum = params.getLanguage();
        if (initPin != null && initPin.length > 0) {
            int[] nArray2 = new int[3];
            nArray2[0] = 1;
            nArray2[1] = 2;
            nArray = nArray2;
            nArray2[2] = 0;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        }
        return this.buildPinModifyStructureInt(encoder, n, n2, 1, n3, 0, by, n4, n5, 0, n6, 0, blockLengthInt, n7, n8, bl, true, false, false, true, languageEnum, nArray, commandToPerform);
    }

    PinModifyStructure buildPinModifyStructureEmptyInt(PinModifyParameters params) throws IllegalArgumentException {
        PinEncoder encoder = params.getEncoder();
        if (encoder == null || params.getLanguage() == null) {
            throw new IllegalArgumentException("null not permitted!");
        }
        byte[] commandToPerform = ArrayUtil.isNullOrEmpty(params.getTemplate()) ? AbstractPcsc20PinStructureHandler.buildPinModifyCommandBytes(params.getPinID(), params.usesCCID()) : params.getTemplate();
        boolean encodePinLength = params.encodePinLength();
        return this.buildPinModifyStructureInt(encoder, params.getFirstTimeout(), params.getSecondTimeout(), 1, encodePinLength ? 1 : 0, 0, params.getEncoder().getCCIDID(), encodePinLength ? 4 : 0, 0, 0, encodePinLength ? 4 : 0, 0, 0, params.getMinPinLength(), params.getMaxPinLength(), params.getInitPin() == null, true, false, false, true, params.getLanguage(), new int[]{0, 1, 2}, commandToPerform);
    }

    static final byte[] buildPinModifyCommandBytes(byte pinID, boolean usesCCID) {
        if (usesCCID) {
            return new byte[]{0, 36, 0, pinID, 0};
        }
        return new byte[]{0, 36, 0, pinID};
    }

    static final byte[] buildPinVerifyCommandBytes(byte pinID, boolean usesCCID) {
        if (usesCCID) {
            return new byte[]{0, 32, 0, pinID, 0};
        }
        return new byte[]{0, 32, 0, pinID};
    }

    static final byte[] buildPinCommandBytes(PinEncoder encoder, byte pinID, int blockLength, byte padByte, boolean encodePinLength, boolean modify, byte[] initPin) throws IllegalArgumentException {
        AbstractPcsc20PinStructureHandler.checkInitPin(encoder, blockLength, encodePinLength, modify, initPin);
        byte[] header = modify ? AbstractPcsc20PinStructureHandler.buildPinModifyCommandBytes(pinID, false) : AbstractPcsc20PinStructureHandler.buildPinVerifyCommandBytes(pinID, false);
        byte[] commandBytes = new byte[header.length + 1 + blockLength * (modify ? 2 : 1)];
        System.arraycopy(header, 0, commandBytes, 0, header.length);
        commandBytes[header.length] = (byte)(commandBytes.length - header.length - 1);
        byte[] firstPin = encoder.encode(initPin, blockLength, padByte, encodePinLength);
        System.arraycopy(firstPin, 0, commandBytes, header.length + 1, firstPin.length);
        if (modify) {
            byte[] secondPin = encoder.encode(null, blockLength, padByte, encodePinLength);
            System.arraycopy(secondPin, 0, commandBytes, header.length + 1 + blockLength, secondPin.length);
        }
        return commandBytes;
    }

    PinVerifyStructure buildPinVerifyStructureInt(PinEncoder encoder, int firstTimeout, int secondTimeout, int formatStringSystemUnits, int formatStringPinPosition, int formatStringJustification, int formatStringFormatType, int pinBlockBitSizePinLength, int pinBlockByteSizePinBlock, int pinLengthSystemUnits, int pinLengthPosition, int maxDigitMinimum, int maxDigitMaximum, boolean validationTimeout, boolean validationMaximum, boolean validationKey, LanguageEnum language, int[] messageIDs, byte[] commandToPerform) throws IllegalArgumentException {
        PinVerifyStructure pvs = new PinVerifyStructure();
        pvs.getFirstTimeout().setTimeout(firstTimeout);
        pvs.getSecondTimeout().setTimeout(secondTimeout);
        pvs.getFormatString().setSystemUnits(formatStringSystemUnits);
        pvs.getFormatString().setPinPosition(formatStringPinPosition);
        pvs.getFormatString().setJustification(formatStringJustification);
        pvs.getFormatString().setFormatType(formatStringFormatType);
        pvs.getPINBlockString().setBitSizeOfPINLength(pinBlockBitSizePinLength);
        pvs.getPINBlockString().setByteSizeOfPINBlock(pinBlockByteSizePinBlock);
        pvs.getPINLengthFormat().setSystemUnits(pinLengthSystemUnits);
        pvs.getPINLengthFormat().setPinLengthPosition(pinLengthPosition);
        pvs.getPINMaxExtraDigit().setMinimum(encoder, maxDigitMinimum);
        pvs.getPINMaxExtraDigit().setMaximum(encoder, maxDigitMaximum);
        pvs.getEntryValidationCondition().setTimeoutEnabled(validationTimeout);
        pvs.getEntryValidationCondition().setMaximumSizeReachedEnabled(validationMaximum);
        pvs.getEntryValidationCondition().setValidationKeyEnabled(validationKey);
        pvs.getMessages().useCCIDDefaultMessages(language, messageIDs);
        pvs.getCommandAPDU().setCommandAPDUBytes(commandToPerform);
        return pvs;
    }

    PinModifyStructure buildPinModifyStructureInt(PinEncoder encoder, int firstTimeout, int secondTimeout, int formatStringSystemUnits, int formatStringPinPosition, int formatStringJustification, int formatStringFormatType, int pinBlockBitSizePinLength, int pinBlockByteSizePinBlock, int pinLengthSystemUnits, int pinLengthPosition, int insertionOffsetOld, int insertionOffsetNew, int maxDigitMinimum, int maxDigitMaximum, boolean confirmPinOld, boolean confirmPinNew, boolean validationTimeout, boolean validationMaximum, boolean validationKey, LanguageEnum language, int[] messageIDs, byte[] commandToPerform) throws IllegalArgumentException {
        PinModifyStructure pms = new PinModifyStructure();
        pms.getFirstTimeout().setTimeout(firstTimeout);
        pms.getSecondTimeout().setTimeout(secondTimeout);
        pms.getFormatString().setSystemUnits(formatStringSystemUnits);
        pms.getFormatString().setPinPosition(formatStringPinPosition);
        pms.getFormatString().setJustification(formatStringJustification);
        pms.getFormatString().setFormatType(formatStringFormatType);
        pms.getPINBlockString().setBitSizeOfPINLength(pinBlockBitSizePinLength);
        pms.getPINBlockString().setByteSizeOfPINBlock(pinBlockByteSizePinBlock);
        pms.getPINLengthFormat().setSystemUnits(pinLengthSystemUnits);
        pms.getPINLengthFormat().setPinLengthPosition(pinLengthPosition);
        pms.getInsertionOffsetOld().setOffset(insertionOffsetOld);
        pms.getInsertionOffsetNew().setOffset(insertionOffsetNew);
        pms.getPINMaxExtraDigit().setMinimum(encoder, maxDigitMinimum);
        pms.getPINMaxExtraDigit().setMaximum(encoder, maxDigitMaximum);
        pms.getConfirmPIN().setCurrentPINRequestedEnabled(confirmPinOld);
        pms.getConfirmPIN().setConfirmationRequestedEnabled(confirmPinNew);
        pms.getEntryValidationCondition().setTimeoutEnabled(validationTimeout);
        pms.getEntryValidationCondition().setMaximumSizeReachedEnabled(validationMaximum);
        pms.getEntryValidationCondition().setValidationKeyEnabled(validationKey);
        pms.getMessages().setMessages(language, messageIDs);
        pms.getCommandAPDU().setCommandAPDUBytes(commandToPerform);
        return pms;
    }

    private static void checkInitPin(PinEncoder encoder, int blockLength, boolean encodePinLength, boolean modify, byte[] initPin) throws IllegalArgumentException {
        if (initPin != null) {
            if (encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK && (initPin.length < 4 || initPin.length > 12)) {
                throw new IllegalArgumentException("initial pin has incorrect length - allowed range [4..12]");
            }
            if (encoder == PinEncoder.ENCODER_T50 && (initPin.length < 4 || initPin.length > 255)) {
                throw new IllegalArgumentException("initial pin has incorrect length - allowed range [4..255]");
            }
            if (!modify) {
                throw new IllegalArgumentException("illegal combination of arguments: initial pin obsolete in verify command");
            }
            AbstractPcsc20PinStructureHandler.checkRequestedPinLength(encoder, blockLength, encodePinLength, initPin.length);
        }
    }

    private static void checkRequestedPinLength(PinEncoder encoder, int blockLength, boolean encodePinLength, int requestedPinLength) throws IllegalArgumentException {
        if (encoder == null) {
            throw new IllegalArgumentException("encoder must not be null");
        }
        int requiredBlockLength = requestedPinLength;
        if (encoder == PinEncoder.ENCODER_BCD || encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK || encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK) {
            ++requiredBlockLength;
            requiredBlockLength /= 2;
        }
        if (encodePinLength) {
            ++requiredBlockLength;
        }
        if (requiredBlockLength > blockLength) {
            throw new IllegalArgumentException("illegal combination of arguments: requested length of pin (with requested state of length encoding) requires more bytes than allocated in blockLength");
        }
    }

    private static void checkLengthParams(PinEncoder encoder, int blockLength, byte padByte, boolean encodePinLength) throws IllegalArgumentException {
        if (encoder == null) {
            throw new IllegalArgumentException("encoder must not be null");
        }
        if ((encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK || encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK) && blockLength != 8) {
            throw new IllegalArgumentException("in format 1 and 2, a single pin block must always be 8 bytes long");
        }
        if (encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK && padByte != -1) {
            throw new IllegalArgumentException("illegal combination of arguments: in format 2, padding byte must always be 0xff");
        }
        if (encoder == PinEncoder.ENCODER_BCD && blockLength < (encodePinLength ? 3 : 2)) {
            throw new IllegalArgumentException("single block too short for BCD encoding");
        }
        if (encoder == PinEncoder.ENCODER_T50 && blockLength < (encodePinLength ? 5 : 4)) {
            throw new IllegalArgumentException("single block too short for string encoding");
        }
    }
}

