/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc;

import de.bos_bremen.basecard.terminal.pcsc.TLVConstants;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.asn1.ASN1;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public enum TLVProperty implements TLVConstants
{
    RFU,
    DISPLAY_LAYOUT,
    ENTRY_VALIDATION_CONDITION,
    SECOND_TIMEOUT,
    DISPLAY_MAX_CHARACTERS_PER_LINE,
    DISPLAY_MAX_LINES,
    PINPAD_MIN_PIN_SIZE,
    PINPAD_MAX_PIN_SIZE,
    FIRMWARE_ID,
    PPDU_SUPPORT;

    private static final Logger LOG;
    private byte tag = 0;
    private int length = 0;
    private String description = null;

    private TLVProperty() {
        try {
            this.tag = (Byte)TLVConstants.class.getField(this.name()).get(null);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        try {
            this.length = (Integer)TLVConstants.class.getField("LENGTH_" + this.name()).get(null);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        try {
            this.description = (String)TLVConstants.class.getField("DESCRIPTION_" + this.name()).get(null);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public byte getTag() {
        return this.tag;
    }

    public int getLength() {
        return this.length;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        return super.toString() + "(tag: " + this.tag + ", length: " + this.length + ", description: " + this.description + ")";
    }

    public static TLVProperty getByTag(byte tag) {
        TLVProperty result = null;
        for (TLVProperty p : TLVProperty.values()) {
            if (p.getTag() != tag) continue;
            result = p;
            break;
        }
        return result;
    }

    public static Map<TLVProperty, ASN1> parse(byte[] bytes) {
        HashMap<TLVProperty, ASN1> result = new HashMap<TLVProperty, ASN1>();
        if (!ArrayUtil.isNullOrEmpty(bytes)) {
            ASN1 asn1 = new ASN1(16, bytes);
            try {
                List<ASN1> childList = asn1.getChildElementList();
                for (ASN1 child : childList) {
                    result.put(TLVProperty.getByTag(child.getDTagBytes()[0]), child);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"getting child element list failed", (Throwable)e);
            }
        }
        return result;
    }

    static {
        LOG = Logger.getLogger(TLVProperty.class);
    }
}

