/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc;

import de.bos_bremen.basecard.terminal.pcsc.PaceCapabilities;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Constants;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.StringRepresentable;
import de.bos_bremen.common.asn1.ASN1;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Pcsc20Features
implements Pcsc20Constants,
StringRepresentable {
    private static final Log LOG = LogFactory.getLog(Pcsc20Features.class);
    private PaceCapabilities paceCapabilities = null;
    public static final int FEATURE_NOT_SUPPORTED = 0;
    public static final Pcsc20Features EMPTY_FEATURES = new Pcsc20Features();
    public static final Pcsc20Features NO_FEATURES_CREATED = new Pcsc20Features();
    public static final Pcsc20Features NO_FEATURES_CREATED_WHEN_CARD_INSERTED = new Pcsc20Features();
    private final List<Integer> featureList = new ArrayList<Integer>();
    private ASN1 verifyPINStart = Pcsc20Features.createASN1(new byte[]{1, 0});
    private ASN1 verifyPINFinish = Pcsc20Features.createASN1(new byte[]{2, 0});
    private ASN1 modifyPINStart = Pcsc20Features.createASN1(new byte[]{3, 0});
    private ASN1 modifyPINFinish = Pcsc20Features.createASN1(new byte[]{4, 0});
    private ASN1 getKeyPressed = Pcsc20Features.createASN1(new byte[]{5, 0});
    private ASN1 verifyPINDirect = Pcsc20Features.createASN1(new byte[]{6, 0});
    private ASN1 modifyPINDirect = Pcsc20Features.createASN1(new byte[]{7, 0});
    private ASN1 mctReaderDirect = Pcsc20Features.createASN1(new byte[]{8, 0});
    private ASN1 mctUniversal = Pcsc20Features.createASN1(new byte[]{9, 0});
    private ASN1 ifdPINProperties = Pcsc20Features.createASN1(new byte[]{10, 0});
    private ASN1 abort = Pcsc20Features.createASN1(new byte[]{11, 0});
    private ASN1 setSPEMessage = Pcsc20Features.createASN1(new byte[]{12, 0});
    private ASN1 verifyPINDirectAppId = Pcsc20Features.createASN1(new byte[]{13, 0});
    private ASN1 modifyPINDirectAppId = Pcsc20Features.createASN1(new byte[]{14, 0});
    private ASN1 writeDisplay = Pcsc20Features.createASN1(new byte[]{15, 0});
    private ASN1 getKey = Pcsc20Features.createASN1(new byte[]{16, 0});
    private ASN1 ifdDisplayProperties = Pcsc20Features.createASN1(new byte[]{17, 0});
    private ASN1 tlvProperties = Pcsc20Features.createASN1(new byte[]{18, 0});
    private ASN1 ccidEscCommand = Pcsc20Features.createASN1(new byte[]{19, 0});
    private ASN1 executePACE = Pcsc20Features.createASN1(new byte[]{32, 0});
    private String featureHexString = null;

    private static ASN1 createASN1(byte[] bytes) {
        ASN1 result = null;
        try {
            result = new ASN1(bytes);
        }
        catch (IOException e) {
            LOG.debug((Object)"failed creating ASN.1", (Throwable)e);
        }
        return result;
    }

    public ASN1 getVerifyPINStart() {
        return this.verifyPINStart;
    }

    public ASN1 getVerifyPINFinish() {
        return this.verifyPINFinish;
    }

    public ASN1 getModifyPINStart() {
        return this.modifyPINStart;
    }

    public ASN1 getModifyPINFinish() {
        return this.modifyPINFinish;
    }

    public ASN1 getGetKeyPressed() {
        return this.getKeyPressed;
    }

    public ASN1 getVerifyPINDirect() {
        return this.verifyPINDirect;
    }

    public ASN1 getModifyPINDirect() {
        return this.modifyPINDirect;
    }

    public ASN1 getMctReaderDirect() {
        return this.mctReaderDirect;
    }

    public ASN1 getMctUniversal() {
        return this.mctUniversal;
    }

    public ASN1 getIFDPINProperties() {
        return this.ifdPINProperties;
    }

    public ASN1 getSetSPEMessage() {
        return this.setSPEMessage;
    }

    public ASN1 getVerifyPINDirectAppId() {
        return this.verifyPINDirectAppId;
    }

    public ASN1 getModifyPINDirectAppId() {
        return this.modifyPINDirectAppId;
    }

    public ASN1 getWriteDisplay() {
        return this.writeDisplay;
    }

    public ASN1 getGetKey() {
        return this.getKey;
    }

    public ASN1 getIfdDisplayProperties() {
        return this.ifdDisplayProperties;
    }

    public ASN1 getExecutePACE() {
        return this.executePACE;
    }

    public ASN1 getAbort() {
        return this.abort;
    }

    protected Pcsc20Features() {
    }

    public Pcsc20Features(byte[] featuresBytes) {
        this.initASN1s(featuresBytes);
    }

    private void initASN1s(byte[] featuresBytes) {
        this.featureHexString = HexUtil.hexify(featuresBytes);
        if (featuresBytes != null && featuresBytes.length > 0 && featuresBytes.length % 6 == 0) {
            int count = featuresBytes.length / 6;
            block24: for (int i = 0; i < count; ++i) {
                byte[] trc = new byte[6];
                System.arraycopy(featuresBytes, i * 6, trc, 0, trc.length);
                ASN1 asn = null;
                try {
                    asn = new ASN1(trc);
                }
                catch (Exception e) {
                    asn = new ASN1(32, ByteUtil.subbytes(trc, 2));
                }
                switch (asn.getTag().intValue()) {
                    case 1: {
                        this.verifyPINStart = asn;
                        this.featureList.add(1);
                        continue block24;
                    }
                    case 2: {
                        this.verifyPINFinish = asn;
                        this.featureList.add(2);
                        continue block24;
                    }
                    case 3: {
                        this.modifyPINStart = asn;
                        this.featureList.add(3);
                        continue block24;
                    }
                    case 4: {
                        this.modifyPINFinish = asn;
                        this.featureList.add(4);
                        continue block24;
                    }
                    case 5: {
                        this.getKeyPressed = asn;
                        this.featureList.add(5);
                        continue block24;
                    }
                    case 6: {
                        this.verifyPINDirect = asn;
                        this.featureList.add(6);
                        continue block24;
                    }
                    case 7: {
                        this.modifyPINDirect = asn;
                        this.featureList.add(7);
                        continue block24;
                    }
                    case 8: {
                        this.mctReaderDirect = asn;
                        this.featureList.add(8);
                        continue block24;
                    }
                    case 9: {
                        this.mctUniversal = asn;
                        this.featureList.add(9);
                        continue block24;
                    }
                    case 10: {
                        this.ifdPINProperties = asn;
                        this.featureList.add(10);
                        continue block24;
                    }
                    case 11: {
                        this.abort = asn;
                        this.featureList.add(11);
                        continue block24;
                    }
                    case 12: {
                        this.setSPEMessage = asn;
                        this.featureList.add(12);
                        continue block24;
                    }
                    case 13: {
                        this.verifyPINDirectAppId = asn;
                        this.featureList.add(13);
                        continue block24;
                    }
                    case 14: {
                        this.modifyPINDirectAppId = asn;
                        this.featureList.add(14);
                        continue block24;
                    }
                    case 15: {
                        this.writeDisplay = asn;
                        this.featureList.add(15);
                        continue block24;
                    }
                    case 16: {
                        this.getKey = asn;
                        this.featureList.add(16);
                        continue block24;
                    }
                    case 17: {
                        this.ifdDisplayProperties = asn;
                        this.featureList.add(17);
                        continue block24;
                    }
                    case 18: {
                        this.tlvProperties = asn;
                        this.featureList.add(18);
                        continue block24;
                    }
                    case 19: {
                        this.ccidEscCommand = asn;
                        this.featureList.add(19);
                        continue block24;
                    }
                    case 32: {
                        this.executePACE = asn;
                        this.featureList.add(32);
                        continue block24;
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\nverifyPINStart        : " + Pcsc20Features.toString(this.verifyPINStart) + "\nverifyPINFinish       : " + Pcsc20Features.toString(this.verifyPINFinish) + "\nmodifyPINStart        : " + Pcsc20Features.toString(this.modifyPINStart) + "\nmodifyPINFinish       : " + Pcsc20Features.toString(this.modifyPINFinish) + "\ngetKeyPressed         : " + Pcsc20Features.toString(this.getKeyPressed) + "\nverifyPINDirect       : " + Pcsc20Features.toString(this.verifyPINDirect) + "\nmodifyPINDirect       : " + Pcsc20Features.toString(this.modifyPINDirect) + "\nmctReaderDirect       : " + Pcsc20Features.toString(this.mctReaderDirect) + "\nmctUniversal          : " + Pcsc20Features.toString(this.mctUniversal) + "\nifdPINProperties      : " + Pcsc20Features.toString(this.ifdPINProperties) + "\nabort                 : " + Pcsc20Features.toString(this.abort) + "\nsetSPEMessage         : " + Pcsc20Features.toString(this.setSPEMessage) + "\nverifyPINDirectAppId  : " + Pcsc20Features.toString(this.verifyPINDirectAppId) + "\nmodifyPINDirectAppId  : " + Pcsc20Features.toString(this.modifyPINDirectAppId) + "\nwriteDisplay          : " + Pcsc20Features.toString(this.writeDisplay) + "\ngetKey                : " + Pcsc20Features.toString(this.getKey) + "\nifdDisplayProperties  : " + Pcsc20Features.toString(this.ifdDisplayProperties) + "\ntlvProperties         : " + Pcsc20Features.toString(this.tlvProperties) + "\nccidEscCommand        : " + Pcsc20Features.toString(this.ccidEscCommand) + "\nexecutePACE           : " + Pcsc20Features.toString(this.executePACE);
    }

    private static String toString(ASN1 asn1) {
        return asn1 != null && asn1.getValue() != null && asn1.getValue().length > 0 ? HexUtil.hexify(asn1.getValue()) : " - ";
    }

    public static Pcsc20Features createEmptyPCSC20Features() {
        return EMPTY_FEATURES;
    }

    public static List<Integer> getCM_IOCTL_GET_FEATURE_REQUEST() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            result.add(3224864);
            result.add(1107299656);
            LOG.debug((Object)"using feature request code for windows and pcsc-lite/linux");
        } else {
            result.add(1107299656);
            LOG.debug((Object)"using only feature request code for pcsc-lite/linux");
        }
        LOG.debug((Object)("used request codes: " + result));
        return result;
    }

    public boolean isFeatureSupported(int featureCode) {
        return this.featureList.contains(featureCode);
    }

    public List<Integer> getFeatureList() {
        return Collections.unmodifiableList(this.featureList);
    }

    public String getFeatureHexString() {
        return this.featureHexString;
    }

    public PaceCapabilities getPaceCapabilities() {
        return this.paceCapabilities;
    }

    public void setPaceCapabilities(PaceCapabilities cap) {
        this.paceCapabilities = cap;
    }

    public ASN1 getGetTLVProperties() {
        return this.tlvProperties;
    }

    public ASN1 getCcidEscCommand() {
        return this.ccidEscCommand;
    }

    public boolean isModifyDirectRecommended(boolean verify) {
        return !verify && (!this.isFeatureSupported(3) || !this.isFeatureSupported(4)) && this.isFeatureSupported(7);
    }

    public boolean isVerifyDirectRecommended(boolean verify) {
        return verify && (!this.isFeatureSupported(1) || !this.isFeatureSupported(2)) && this.isFeatureSupported(6);
    }

    public boolean usePCSCVerifyModifyDirect(String terminalName, boolean verify) {
        String tname;
        boolean useDirect = false;
        if ((this.isVerifyDirectRecommended(verify) || this.isModifyDirectRecommended(verify)) && !this.isFeatureSupported(8)) {
            useDirect = true;
        } else if (System.getProperty("os.name").toLowerCase().contains("windows") && (this.isVerifyDirectRecommended(verify) || this.isModifyDirectRecommended(verify)) && this.isFeatureSupported(8) && (tname = terminalName.toLowerCase()).contains("kobil") && tname.contains("kaan") && tname.contains("advanced")) {
            useDirect = true;
        }
        return useDirect;
    }
}

