/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc;

import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Constants;
import de.bos_bremen.common.ByteUtil;

public interface PaceConstants {
    public static final String EXECUTE_PACE_FUNCTION_HEX_IDX_GET_READER_CAPABALITIES = "01";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_SUCCESS = "00000000";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_WRONG_LENGTH = "D0000001";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_WRONG_DATA = "D0000002";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_WRONG_COMBINATION = "D0000003";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_UNSUPPORTED_PACE = "E0000001";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_UNSUPPORTED_ALGORITHM = "E0000002";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_UNKNOWN_PIN_ID = "E0000003";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_PREFIX_SELECT_CARDACCESS_ERROR = "F000";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_PREFIX_READ_BINARY_ERROR = "F001";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_PREFIX_MSE_SET_AT_ERROR = "F002";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_PREFIX_GA_STEP_1_ERROR = "F003";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_PREFIX_GA_STEP_2_ERROR = "F004";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_PREFIX_GA_STEP_3_ERROR = "F005";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_PREFIX_GA_STEP_4_ERROR = "F006";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_COMMUNICATION_ERROR = "F0100001";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_NO_CARD = "F0100002";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_CANCELLED_BY_USER = "F0200001";
    public static final String EXECUTE_PACE_FUNCTION_RESULT_HEX_TIMEOUT = "F0200002";
    public static final String EXECUTE_PACE_FUNCTION_HEX_IDX_ESTABLISH_PACE_CHANNEL = "02";
    public static final byte PACE_CAPABILITIES_PACE_LIGHT = -128;
    public static final byte PACE_CAPABILITIES_PACE = 64;
    public static final byte PACE_CAPABILITIES_EID = 32;
    public static final byte PACE_CAPABILITIES_ESIGN = 16;

    public String toString();

    public static enum PaceCapabilityEnum implements Pcsc20Constants
    {
        NO_CAPABILITIES(0, "no capabilities"),
        ESIGN(16, "eSign"),
        EID(32, "eID"),
        PACE(64, "PACE (full)"),
        PACE_LIGHT(-128, "PACE (light)");

        private byte capabilityMask = 0;
        private String description = null;

        private PaceCapabilityEnum(byte mask, String description) {
            this.capabilityMask = mask;
            this.description = description;
        }

        public boolean isSupported(byte capabilityByte) {
            return ByteUtil.areBitsSet(capabilityByte, this.capabilityMask);
        }

        public byte getCapabilitiyMask() {
            return this.capabilityMask;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

