/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.impl;

import de.bos_bremen.basecard.Response;
import de.bos_bremen.basecard.codes.ExceptionMapper;
import de.bos_bremen.basecard.codes.impl.ResponseCodeSearcherImpl;
import de.bos_bremen.basecard.codes.xml.ChoiceCommands;
import de.bos_bremen.basecard.codes.xml.Command;
import de.bos_bremen.basecard.codes.xml.CommandHeader;
import de.bos_bremen.basecard.codes.xml.ObjectFactory;
import de.bos_bremen.basecard.codes.xml.RefCommand;
import de.bos_bremen.basecard.codes.xml.ResponseCode;
import de.bos_bremen.basecard.codes.xml.ResponseCodeCode;
import de.bos_bremen.basecard.codes.xml.ResponseCodeRaw;
import de.bos_bremen.basecard.impl.ResponseImpl;
import de.bos_bremen.basecard.terminal.BTerminal;
import de.bos_bremen.basecard.terminal.BTerminalException;
import java.util.Collection;

public abstract class AbstractBTerminalImpl
implements BTerminal {
    protected final ExceptionMapper<BTerminalException> mapper;
    protected static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();

    public AbstractBTerminalImpl(ExceptionMapper<BTerminalException> mapper) {
        this.mapper = mapper;
    }

    public Response convert(byte[] responseBytes) throws IllegalArgumentException {
        if (responseBytes == null || responseBytes.length < 2) {
            throw new IllegalArgumentException("minimum 2 response bytes for code expected");
        }
        ResponseImpl result = null;
        ResponseCode rc = null;
        byte[] data = null;
        if (responseBytes.length > 2) {
            data = new byte[responseBytes.length - 2];
            System.arraycopy(responseBytes, 0, data, 0, data.length);
        }
        byte[] c = new byte[2];
        System.arraycopy(responseBytes, responseBytes.length - 2, c, 0, 2);
        ResponseCodeRaw rr = OBJECT_FACTORY.createResponseCodeRaw();
        ResponseCodeCode r = OBJECT_FACTORY.createResponseCodeCode();
        r.setCode(c);
        rr.setCode(r);
        ResponseCodeSearcherImpl s = new ResponseCodeSearcherImpl(rr);
        Collection<ResponseCode> responseCodeCollection = null;
        if (this.mapper != null) {
            responseCodeCollection = this.mapper.getCommandResponseCodeManager().findEntries(ResponseCode.class, s);
        }
        if (responseCodeCollection != null && responseCodeCollection.size() == 1) {
            rc = responseCodeCollection.iterator().next();
        } else {
            ResponseCode rx = OBJECT_FACTORY.createResponseCode();
            ChoiceCommands ccx = OBJECT_FACTORY.createChoiceCommands();
            RefCommand rcx = OBJECT_FACTORY.createRefCommand();
            Command cx = OBJECT_FACTORY.createCommand();
            CommandHeader hx = OBJECT_FACTORY.createCommandHeader();
            cx.setHeader(hx);
            rcx.getRef().add(cx);
            ccx.setCommand(rcx);
            rx.setCommands(ccx);
            rx.setCode(r);
            rc = rx;
        }
        result = new ResponseImpl(rc, data, responseBytes, c);
        return result;
    }
}

