/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.bcs.impl;

import de.bos_bremen.basecard.Command;
import de.bos_bremen.basecard.Response;
import de.bos_bremen.basecard.terminal.BTerminalException;
import de.bos_bremen.basecard.terminal.bcs.CardTerminalManufacturerDO;
import de.bos_bremen.basecard.terminal.bcs.DataObjectFactory;
import de.bos_bremen.basecard.terminal.bcs.ICCStatusDO;
import de.bos_bremen.basecard.terminal.bcs.JCTAPITerminalInfo;
import de.bos_bremen.basecard.terminal.bcs.impl.AbstractBCSTerminalImpl;
import de.bos_bremen.basecard.terminal.bcs.impl.DataObjectFactoryImpl;
import de.bos_bremen.java.ctapi.JCTAPI;
import de.bos_bremen.jni.ctapi.CTAPIConstants;
import de.bos_bremen.jni.ctapi.CTAPIException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCTAPITerminalImpl
extends AbstractBCSTerminalImpl<JCTAPITerminalInfo> {
    private static final Log LOG = LogFactory.getLog(JCTAPITerminalImpl.class);
    private final DataObjectFactory dataObjectFactory = DataObjectFactoryImpl.getInstance();
    private JCTAPI jctapi = null;
    private List<Integer> functionalUnitList = null;
    private CardTerminalManufacturerDO ctm = null;
    private List<Integer> externalFunctionalUnitList = null;

    public JCTAPITerminalImpl(JCTAPITerminalInfo terminalInfo, JCTAPI jctapi) throws IllegalArgumentException {
        super(terminalInfo);
        if (jctapi == null) {
            throw new IllegalArgumentException("jctapi not permitted as null");
        }
        this.jctapi = jctapi;
        this.functionalUnitList = new ArrayList<Integer>();
        this.externalFunctionalUnitList = Collections.unmodifiableList(this.functionalUnitList);
    }

    @Override
    public boolean isConnected() {
        return this.jctapi.isConnected(((JCTAPITerminalInfo)this.terminalInfo).getLibraryHandle(), ((JCTAPITerminalInfo)this.terminalInfo).getTerminalNo());
    }

    @Override
    public synchronized void connect() throws BTerminalException {
        if (!this.isConnected()) {
            try {
                LOG.debug((Object)("connect with  no=" + ((JCTAPITerminalInfo)this.terminalInfo).getTerminalNo() + " port=" + ((JCTAPITerminalInfo)this.terminalInfo).getPort()));
                this.jctapi.connect(((JCTAPITerminalInfo)this.terminalInfo).getLibraryHandle(), ((JCTAPITerminalInfo)this.terminalInfo).getTerminalNo(), ((JCTAPITerminalInfo)this.terminalInfo).getPort());
            }
            catch (CTAPIException e) {
                LOG.debug((Object)("connect failed with  no=" + ((JCTAPITerminalInfo)this.terminalInfo).getTerminalNo() + " port=" + ((JCTAPITerminalInfo)this.terminalInfo).getPort() + " message: " + e.getMessage()));
                throw new BTerminalException("connect", e);
            }
        }
    }

    @Override
    public void disconnect() throws BTerminalException {
        if (this.isConnected()) {
            try {
                LOG.debug((Object)("disconnect with  no=" + ((JCTAPITerminalInfo)this.terminalInfo).getTerminalNo()));
                this.jctapi.disconnect(((JCTAPITerminalInfo)this.terminalInfo).getLibraryHandle(), ((JCTAPITerminalInfo)this.terminalInfo).getTerminalNo());
            }
            catch (CTAPIException e) {
                LOG.debug((Object)("disconnect failed with  no=" + ((JCTAPITerminalInfo)this.terminalInfo).getTerminalNo() + " message: " + e.getMessage()));
                throw new BTerminalException("disconnect", e);
            }
        }
    }

    @Override
    public Response sendCardCommand(int icc, Command command, Integer responseBufferSize) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        this.checkFunctionUnitCard(icc);
        this.checkFunctionalUnitExists(icc);
        if (command == null || command.getBytes() == null || command.getBytes().length == 0) {
            throw new IllegalArgumentException("command expected");
        }
        try {
            byte[] rawResponse = this.jctapi.send(((JCTAPITerminalInfo)this.terminalInfo).getLibraryHandle(), ((JCTAPITerminalInfo)this.terminalInfo).getTerminalNo(), 2, icc == 1 ? 0 : icc, command.getBytes(), responseBufferSize != null ? (int)Math.min((long)(responseBufferSize + 2), CTAPIConstants.MAXIMUM_OUTPUT_BUFFER - 1L) : 2);
            Response response = super.convert(rawResponse);
            return response;
        }
        catch (CTAPIException e) {
            throw new BTerminalException("sendCardCommand", e);
        }
    }

    @Override
    public Response sendTerminalCommand(Command command, Integer responseBufferSize) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        this.checkFunctionalUnitExists(0);
        if (command == null || command.getBytes() == null || command.getBytes().length == 0) {
            throw new IllegalArgumentException("command expected");
        }
        if (command.getBytes().length < 4) {
            throw new IllegalArgumentException("illegal command, at least 4 bytes expected");
        }
        if (command.getBytes()[0] != 32) {
            throw new IllegalArgumentException("illegal command, CLA byte for CT-BCS fixed as 32");
        }
        try {
            byte[] rawResponse = this.jctapi.send(((JCTAPITerminalInfo)this.terminalInfo).getLibraryHandle(), ((JCTAPITerminalInfo)this.terminalInfo).getTerminalNo(), 2, 1, command.getBytes(), responseBufferSize != null ? (int)Math.min((long)(responseBufferSize + 2), CTAPIConstants.MAXIMUM_OUTPUT_BUFFER - 1L) : 2);
            Response response = super.convert(rawResponse);
            super.checkResponse(command, response);
            return response;
        }
        catch (CTAPIException e) {
            throw new BTerminalException("sendTerminalCommand", e);
        }
    }

    @Override
    public Response getStatus(int fu, int qualifier) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        this.checkFUTerminalOrICC(fu);
        this.checkFunctionalUnitExists(fu);
        block0 : switch (fu) {
            case 0: {
                switch (qualifier) {
                    case -128: 
                    case -127: 
                    case 70: {
                        break block0;
                    }
                }
                throw new IllegalArgumentException("only 70, -127 or -128 as qualifier permitted for CT");
            }
            default: {
                if (qualifier == -128) break;
                throw new IllegalArgumentException("only -128 as qualifier permitted for ICC to request ICC Status DO");
            }
        }
        Command command = this.buildCTBCSCommand((byte)19, (byte)fu, (byte)qualifier, null, 0);
        Response response = this.sendTerminalCommand(command, 255);
        return response;
    }

    @Override
    public synchronized CardTerminalManufacturerDO getManufacturerData() throws IllegalArgumentException, IllegalStateException, BTerminalException {
        if (this.ctm == null) {
            Response response = this.getStatus(0, 70);
            if (response == null || response.getData() == null || response.getData().length == 0) {
                throw new BTerminalException("response to requesting CardTerminal Manufacturer DO contain no data", response);
            }
            this.ctm = this.dataObjectFactory.createCardTerminalManufacturerDO(response.getData());
        }
        return this.ctm;
    }

    @Override
    public synchronized List<Integer> getFunctionalUnitList() throws IllegalStateException, IllegalArgumentException, BTerminalException {
        if (this.functionalUnitList.isEmpty()) {
            Response response = this.getStatus(0, -127);
            if (response.getData() == null || response.getRaw() == null || response.getData().length <= 3 || response.getRaw().length <= 5) {
                throw new BTerminalException("requesting functional data failed or only response received contains not enough data", response);
            }
            if (response.getData()[0] != -127) {
                throw new BTerminalException("requesting functional data failed or response contains inconsistent data, leading tag not correct", response);
            }
            if (Math.abs(response.getData()[1]) + 2 != response.getData().length) {
                throw new BTerminalException("requesting functional data failed or response contains inconsistent data, length not correct", response);
            }
            this.functionalUnitList.add(0);
            for (int i = 2; i < response.getData().length; ++i) {
                this.functionalUnitList.add(Integer.valueOf(response.getData()[i]));
            }
        }
        return this.externalFunctionalUnitList;
    }

    @Override
    public List<ICCStatusDO> getICCStatusList() throws IllegalStateException, IllegalArgumentException, BTerminalException {
        Response statusResponse = this.getStatus(0, -128);
        ArrayList<ICCStatusDO> result = new ArrayList<ICCStatusDO>();
        for (int i = 0; i < statusResponse.getData().length - 1 - 1; ++i) {
            result.add(this.dataObjectFactory.createICCStatusDO((byte)(i + 1), statusResponse.getData()));
        }
        return result;
    }

    @Override
    public ICCStatusDO getICCStatus(int icc) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        this.checkFunctionUnitCard(icc);
        this.checkFunctionalUnitExists(icc);
        Response status = this.getStatus(icc, -128);
        return this.dataObjectFactory.createICCStatusDO(icc, status.getData());
    }

    @Override
    public Response resetCT(int fu, int qualifier) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        this.checkFUTerminalOrICC(fu);
        this.checkFunctionalUnitExists(fu);
        Integer responseBufferSize = null;
        switch (fu) {
            case 0: {
                if (qualifier == 0) break;
                throw new IllegalArgumentException("command qualifier to reset terminal must be 0");
            }
            default: {
                this.checkFunctionUnitCard(fu);
                responseBufferSize = this.checkResponseQualifier(qualifier);
            }
        }
        Command command = super.buildCTBCSCommand((byte)17, (byte)fu, (byte)qualifier, null, 0);
        Response response = this.sendTerminalCommand(command, responseBufferSize != null ? responseBufferSize + 2 : 2);
        return response;
    }

    @Override
    public Response resetCT() throws IllegalStateException, IllegalArgumentException, BTerminalException {
        return this.resetCT(0, 0);
    }

    @Override
    public Response resetICC(int icc, int qualifier) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        this.checkFunctionUnitCard(icc);
        this.checkResponseQualifier(qualifier);
        return this.resetCT(icc, qualifier);
    }

    @Override
    public Response requestICC(int icc, int messageQualifier, int qualifier, String message, Integer timeout) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        this.checkRequestEjectICC(icc, messageQualifier);
        Integer responseBufferSize = this.checkResponseQualifier(qualifier);
        byte[] labelBytes = message != null ? this.dataObjectFactory.createApplicationLabel(message) : null;
        byte[] timeBytes = timeout != null ? this.dataObjectFactory.createWaitingTime(timeout) : null;
        Command command = super.buildCTBCSCommand((byte)18, (byte)icc, (byte)(messageQualifier + qualifier), this.dataObjectFactory.combine(labelBytes, timeBytes), 0);
        Response response = this.sendTerminalCommand(command, responseBufferSize != null ? responseBufferSize + 2 : 2);
        return response;
    }

    @Override
    public Response ejectICC(int icc, int messageQualifier, int qualifier, String message, Integer timeout) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        this.checkRequestEjectICC(icc, messageQualifier);
        if (qualifier < 0 || qualifier > 7) {
            throw new IllegalArgumentException("illegal qualifier: 4, 2, 1or logical or combination of these values permitted");
        }
        byte[] labelBytes = message != null ? this.dataObjectFactory.createApplicationLabel(message) : null;
        byte[] timeBytes = timeout != null ? this.dataObjectFactory.createWaitingTime(timeout) : null;
        Command command = super.buildCTBCSCommand((byte)21, (byte)icc, (byte)(messageQualifier + qualifier), this.dataObjectFactory.combine(labelBytes, timeBytes), null);
        Response response = this.sendTerminalCommand(command, 2);
        return response;
    }

    @Override
    public Response output(int fu, byte[] data, Integer timeout) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        byte[] commandData = null;
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("data for output not valid, data required for display, printer or biometrical unit");
        }
        switch (fu) {
            case 64: {
                byte[] labelBytes = data != null ? this.dataObjectFactory.createApplicationLabel(data) : null;
                byte[] timeBytes = timeout != null ? this.dataObjectFactory.createWaitingTime(timeout) : null;
                commandData = this.dataObjectFactory.combine(labelBytes, timeBytes);
                break;
            }
            case 96: {
                if (timeout == null) break;
                throw new IllegalArgumentException("timeout not valid for using printer");
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                if (timeout != null) {
                    throw new IllegalArgumentException("timeout not valid for using biometrical unit");
                }
                commandData = data;
                break;
            }
            default: {
                throw new IllegalArgumentException("functional unit not valid, valid only (functional unit must exist): 64, 96, 114, 115, 112, 116, 113");
            }
        }
        this.checkFunctionalUnitExists(fu);
        Command command = super.buildCTBCSCommand((byte)23, (byte)fu, (byte)0, commandData, null);
        Response response = this.sendTerminalCommand(command, 2);
        return response;
    }

    @Override
    public Response output(String message, Integer timeout) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        return this.output(64, message != null ? message.getBytes() : null, timeout);
    }

    @Override
    public Response input(int fu, int qualifier, String message, Integer timeout, Integer inputLength) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        Integer lInputLength = inputLength;
        block0 : switch (fu) {
            case 80: {
                switch (qualifier) {
                    case 0: 
                    case 1: 
                    case 2: {
                        break block0;
                    }
                }
                throw new IllegalArgumentException("qualifier " + qualifier + "for biometrical functional unit not permitted, 0, 1 or 2 only permitted");
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                if (qualifier == 0) break;
                throw new IllegalArgumentException("qualifier " + qualifier + "for biometrical functional unit not permitted, 0 only permitted");
            }
            default: {
                throw new IllegalArgumentException("functional unit not valid, valid only (functional unit must exist): 80, 114, 115, 112, 116, 113");
            }
        }
        this.checkFunctionalUnitExists(fu);
        if (lInputLength != null) {
            if (lInputLength < 1) {
                throw new IllegalArgumentException("input length only permitted as value greater equals 1");
            }
            if (lInputLength > 16) {
                throw new IllegalArgumentException("input length only permitted as value less 16");
            }
        } else {
            lInputLength = 16;
        }
        byte[] labelBytes = message != null ? this.dataObjectFactory.createApplicationLabel(message) : null;
        byte[] timeBytes = timeout != null ? this.dataObjectFactory.createWaitingTime(timeout) : null;
        byte[] commandData = this.dataObjectFactory.combine(labelBytes, timeBytes);
        Command command = super.buildCTBCSCommand((byte)22, (byte)fu, (byte)qualifier, commandData, lInputLength != null ? lInputLength : Integer.valueOf(253));
        Response response = this.sendTerminalCommand(command, lInputLength != null ? Integer.valueOf(lInputLength + 2) : Integer.valueOf(255));
        return response;
    }

    @Override
    public Response performVerification(int icc, int qualifier, int pinLength, int pinCoding, int insertPosition, Command cardCommand, String promptMsg, String successMsg, String failedMsg, Integer timeout, Integer responseBufferSize) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        this.checkFunctionUnitCard(icc);
        this.checkFunctionalUnitExists(icc);
        this.checkQualifierAuthentication(qualifier);
        byte[] datafield = this.dataObjectFactory.createDataPerformVerfication((byte)pinLength, (byte)pinCoding, insertPosition, cardCommand, promptMsg, successMsg, failedMsg, timeout);
        Command command = this.buildCTBCSCommand((byte)24, (byte)icc, (byte)qualifier, datafield, null);
        Response response = this.sendTerminalCommand(command, responseBufferSize != null ? responseBufferSize + 4 : 17);
        return response;
    }

    @Override
    public Response modifyVerificationData(int icc, int qualifier, int pinLength, int pinCoding, int pinInsertPosition, int newPinInsertPosition, Command cardCommand, String promptMsg, String successMsg, String failedMsg, String promptNewMsg, String repeatNewMsg, String repeatFailedMsg, Integer timeout, Integer responseBufferSize) throws IllegalArgumentException, IllegalStateException, BTerminalException {
        this.checkFunctionUnitCard(icc);
        this.checkFunctionalUnitExists(icc);
        this.checkQualifierAuthentication(qualifier);
        byte[] datafield = this.dataObjectFactory.createDataModifyVerficationData((byte)pinLength, (byte)pinCoding, pinInsertPosition, newPinInsertPosition, cardCommand, promptMsg, successMsg, failedMsg, promptNewMsg, repeatNewMsg, repeatFailedMsg, timeout);
        Command command = this.buildCTBCSCommand((byte)25, (byte)icc, (byte)qualifier, datafield, null);
        Response response = this.sendTerminalCommand(command, responseBufferSize != null ? responseBufferSize + 4 : 32);
        return response;
    }

    private void checkQualifierAuthentication(int qualifier) {
        switch (qualifier) {
            case 0: {
                this.checkFunctionalUnitExists(80);
                break;
            }
            case 1: {
                if (this.functionalUnitList == null || this.functionalUnitList.contains(112) || this.functionalUnitList.contains(113) || this.functionalUnitList.contains(114) || this.functionalUnitList.contains(115) || this.functionalUnitList.contains(116)) break;
                throw new IllegalArgumentException("no biometrical unit present at terminal, biometrical authentication not possible");
            }
            default: {
                throw new IllegalArgumentException("illegal qualifier for authentication unit");
            }
        }
    }

    @Override
    public synchronized List<Integer> getBiometricalUnitList() throws IllegalStateException, IllegalArgumentException, BTerminalException {
        this.prepareSubUnitList();
        ArrayList<Integer> result = new ArrayList<Integer>(this.functionalUnitList);
        result.retainAll(FU_BIOMETRICAL_UNIT_LIST);
        return result;
    }

    @Override
    public synchronized List<Integer> getICCUnitList() throws IllegalStateException, IllegalArgumentException, BTerminalException {
        this.prepareSubUnitList();
        ArrayList<Integer> result = new ArrayList<Integer>(this.functionalUnitList);
        result.retainAll(FU_ICC_UNIT_LIST);
        return result;
    }

    @Override
    public boolean isBiometricalUnitPresent() throws IllegalStateException, IllegalArgumentException, BTerminalException {
        return !this.getBiometricalUnitList().isEmpty();
    }

    @Override
    public boolean isDisplayPresent() throws IllegalStateException, IllegalArgumentException, BTerminalException {
        return this.getFunctionalUnitList().contains(64);
    }

    @Override
    public boolean isKeyboardPresent() throws IllegalStateException, IllegalArgumentException, BTerminalException {
        return this.getFunctionalUnitList().contains(80);
    }

    @Override
    public boolean isPrinterPresent() throws IllegalStateException, IllegalArgumentException, BTerminalException {
        return this.getFunctionalUnitList().contains(96);
    }

    private void checkFunctionUnitCard(int fuICC) {
        if (fuICC < 1) {
            throw new IllegalArgumentException("functional unit ICC " + fuICC + " must be greater equals 1");
        }
        if (fuICC > 14) {
            throw new IllegalArgumentException("functional unit ICC " + fuICC + " must be less equals 14");
        }
    }

    private void checkFUTerminalOrICC(int fu) {
        if (fu < 0) {
            throw new IllegalArgumentException("functional unit must be greater equals 0");
        }
        if (fu > 14) {
            throw new IllegalArgumentException("functional unit must be less equals 14");
        }
    }

    private void checkRequestEjectICC(int icc, int messageQualifier) {
        this.checkFunctionUnitCard(icc);
        this.checkFunctionalUnitExists(icc);
        this.checkMessageQualifier(messageQualifier);
    }

    private void checkFunctionalUnitExists(int fu) {
        if (this.functionalUnitList != null && !this.functionalUnitList.isEmpty() && !this.functionalUnitList.contains(fu)) {
            throw new IllegalArgumentException("functional unit " + fu + " does not exist, existing functional units are: " + this.functionalUnitList);
        }
    }

    private Integer checkResponseQualifier(int qualifier) {
        Integer responseBufferSize = null;
        switch (qualifier) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                responseBufferSize = 40;
                break;
            }
            default: {
                throw new IllegalArgumentException("command qualifier to reset ICC must be 0, 1 or 2");
            }
        }
        return responseBufferSize;
    }

    private void checkMessageQualifier(int messageQualifier) {
        switch (messageQualifier) {
            case 0: 
            case 240: {
                break;
            }
            default: {
                throw new IllegalArgumentException("display must be 0 or 240");
            }
        }
    }

    private void prepareSubUnitList() throws IllegalStateException, IllegalArgumentException, BTerminalException {
        if (this.functionalUnitList == null || this.functionalUnitList.isEmpty()) {
            this.getFunctionalUnitList();
        }
    }
}

