/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.bcs.impl;

import de.bos_bremen.basecard.terminal.bcs.ICCStatusDO;

public class ICCStatusDOImpl
implements ICCStatusDO {
    private int icc = 0;
    private byte[] encoded = null;
    private int status = 0;
    private boolean present = false;
    private boolean connected = false;

    public ICCStatusDOImpl(int icc, byte[] encoded) throws IllegalArgumentException {
        boolean lConnected;
        if (icc < 1 || icc > 14) {
            throw new IllegalArgumentException("not valid icc, valid values between 1 and 14, value: " + icc);
        }
        if (encoded.length < 2) {
            throw new IllegalArgumentException("encoded status not valid, at least one status byte expected");
        }
        if (encoded[0] != -128) {
            throw new IllegalArgumentException("encoded status not valid, tag byte not correct");
        }
        if (encoded.length < 1 + icc) {
            throw new IllegalArgumentException("encoded status not valid, no status byte for " + icc + " found");
        }
        int lStatus = encoded[1 + icc];
        if ((lStatus & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException("status byte contains invalid set RFU bits");
        }
        if ((lStatus & 6) == 6) {
            throw new IllegalArgumentException("status byte contains invalid set bits for connected state, can not be connected and disconnected at the same time");
        }
        boolean lPresent = (lStatus & 1) == 1;
        boolean bl = lConnected = (lStatus & 6) == 4;
        if (!this.present && this.connected) {
            throw new IllegalArgumentException("status byte contains invalid content, ICC can not be absent and electrically connected at the same time");
        }
        this.icc = icc;
        this.encoded = encoded;
        this.status = lStatus;
        this.present = lPresent;
        this.connected = lConnected;
    }

    @Override
    public int getICC() {
        return this.icc;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        return super.toString() + "(icc: " + this.icc + ", status: " + this.status + ", present: " + this.present + ", connected: " + this.connected + ") ";
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded;
    }
}

