/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.bcs.impl;

import de.bos_bremen.basecard.Command;
import de.bos_bremen.basecard.terminal.bcs.CardTerminalManufacturerDO;
import de.bos_bremen.basecard.terminal.bcs.DataObjectFactory;
import de.bos_bremen.basecard.terminal.bcs.ICCStatusDO;
import de.bos_bremen.basecard.terminal.bcs.MessageConstants;
import de.bos_bremen.basecard.terminal.bcs.impl.CardTerminalManufacturerDOImpl;
import de.bos_bremen.basecard.terminal.bcs.impl.ICCStatusDOImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class DataObjectFactoryImpl
implements DataObjectFactory {
    private static final Logger LOG = Logger.getLogger(DataObjectFactoryImpl.class);
    private static DataObjectFactory singleton = null;

    private DataObjectFactoryImpl() {
    }

    public static synchronized DataObjectFactory getInstance() {
        if (singleton == null) {
            singleton = new DataObjectFactoryImpl();
        }
        return singleton;
    }

    @Override
    public byte[] createDO(byte tag, byte[] data) throws IllegalArgumentException {
        if (data != null && data.length > 255) {
            throw new IllegalArgumentException("data up to 255 bytes supported only");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(tag);
            baos.write(data != null ? data.length : 0);
            if (data != null) {
                baos.write(data);
            }
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            LOG.debug((Object)"exception using ByteArrayOutputStream", (Throwable)e);
        }
        return baos.toByteArray();
    }

    @Override
    public byte[] createApplicationLabel(String label) throws IllegalArgumentException {
        String lLabel = label;
        if (lLabel != null && lLabel.length() > 255) {
            throw new IllegalArgumentException("only labels up to 255 bytes supported");
        }
        if (lLabel != null && this.checkSpecialCharacter(lLabel)) {
            lLabel = lLabel.replaceAll("\u00e4", "ae").replaceAll("\u00c4", "Ae").replaceAll("\u00f6", "oe").replaceAll("\u00d6", "Oe").replaceAll("\u00fc", "ue").replaceAll("\u00dc", "Ue").replaceAll("\u00df", "sz").replaceAll("/", "+");
        }
        if (lLabel != null && !Pattern.matches(MessageConstants.CHARACTER_PATTERN, lLabel)) {
            throw new IllegalArgumentException("not supported character in String");
        }
        return this.createDO((byte)80, lLabel != null ? lLabel.getBytes() : new byte[]{});
    }

    private boolean checkSpecialCharacter(String lLabel) {
        boolean result = lLabel.contains("\u00e4") || lLabel.contains("\u00c4");
        result |= lLabel.contains("\u00f6") || lLabel.contains("\u00d6");
        result |= lLabel.contains("\u00fc") || lLabel.contains("\u00dc");
        return result |= lLabel.contains("\u00df") || lLabel.contains("/");
    }

    @Override
    public byte[] createApplicationLabel(byte[] label) throws IllegalArgumentException {
        return this.createApplicationLabel(label != null ? new String(label) : null);
    }

    @Override
    public byte[] createWaitingTime(Integer timeout) throws IllegalArgumentException {
        Integer lTimeout = timeout;
        if (lTimeout != null) {
            if (lTimeout < 0) {
                throw new IllegalArgumentException("waiting time must be positive");
            }
            if (lTimeout > 255) {
                throw new IllegalArgumentException("waiting time must less equals 255");
            }
        } else {
            return this.createDO((byte)-128, null);
        }
        byte[] timeBytes = BigInteger.valueOf(lTimeout.intValue()).toByteArray();
        return this.createDO((byte)-128, new byte[]{timeBytes.length == 1 ? timeBytes[0] : timeBytes[1]});
    }

    @Override
    public byte[] combine(byte[] do1bytes, byte[] do2bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (do1bytes != null) {
                baos.write(do1bytes);
            }
            if (do2bytes != null) {
                baos.write(do2bytes);
            }
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            LOG.debug((Object)"error using ByteArrayOutputStream", (Throwable)e);
        }
        return baos.toByteArray();
    }

    @Override
    public byte[] createDataPerformVerfication(byte pinLength, byte pinCoding, int pinInsertPosition, Command cardCommand, String promptMsg, String successMsg, String failedMsg, Integer timeout) throws IllegalArgumentException {
        byte[] commandToPerform;
        byte[] result = commandToPerform = this.createCommandToPerformStructure(pinLength, pinCoding, pinInsertPosition, null, cardCommand, 13);
        String[] messages = new String[]{promptMsg, successMsg, failedMsg};
        result = this.addMessages(result, messages);
        if (timeout != null) {
            result = this.combine(result, this.createWaitingTime(timeout));
        }
        return result;
    }

    @Override
    public byte[] createCommandToPerformStructure(byte pinLength, byte pinCoding, int pinInsertPosition, Integer newPinInsertPosition, Command cardCommand, int minimumF2BCardCommandLength) throws IllegalArgumentException {
        this.checkCommandToPerformArguments(pinLength, pinCoding, pinInsertPosition, newPinInsertPosition, cardCommand, minimumF2BCardCommandLength);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(82);
            baos.write(2 + cardCommand.getBytes().length + (newPinInsertPosition == null ? 0 : 1));
            baos.write((pinLength << 4) + pinCoding);
            baos.write(pinInsertPosition);
            if (newPinInsertPosition != null) {
                baos.write(newPinInsertPosition);
            }
            baos.write(cardCommand.getBytes());
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            LOG.debug((Object)"error using ByteArrayOutputStream", (Throwable)e);
        }
        return baos.toByteArray();
    }

    @Override
    public byte[] createDataModifyVerficationData(byte pinLength, byte pinCoding, int pinInsertPosition, Integer newPinInsertPosition, Command cardCommand, String promptMsg, String successMsg, String failedMsg, String promptNewMsg, String repeatNewMsg, String repeatFailedMsg, Integer timeout) throws IllegalArgumentException {
        byte[] commandToPerform;
        byte[] result = commandToPerform = this.createCommandToPerformStructure(pinLength, pinCoding, pinInsertPosition, newPinInsertPosition, cardCommand, 21);
        String[] messages = new String[]{promptMsg, successMsg, failedMsg, promptNewMsg, repeatNewMsg, repeatFailedMsg};
        result = this.addMessages(result, messages);
        if (timeout != null) {
            result = this.combine(result, this.createWaitingTime(timeout));
        }
        return result;
    }

    private byte[] addMessages(byte[] data, String[] messages) {
        byte[] lData = data;
        int messageCount = 0;
        for (int i = 0; i < messages.length; ++i) {
            if (messages[i] == null || messages[i].length() <= 0) continue;
            while (messageCount != i) {
                lData = this.combine(lData, this.createApplicationLabel(""));
                ++messageCount;
            }
            lData = this.combine(lData, this.createApplicationLabel(messages[i]));
            ++messageCount;
        }
        return lData;
    }

    private void checkCommandToPerformArguments(byte pinLength, byte pinCoding, int insertPosition, Integer newPinInsertPosition, Command cardCommand, int minimumF2BCardCommandLength) throws IllegalArgumentException {
        this.checkPinLength(pinLength);
        this.checkPinCoding(pinCoding);
        this.checkInsertionPosition(pinCoding, insertPosition, newPinInsertPosition);
        this.checkCardCommand(pinCoding, cardCommand, minimumF2BCardCommandLength);
    }

    private void checkCardCommand(byte pinCoding, Command cardCommand, int minimumF2BCardCommandLength) throws IllegalArgumentException {
        if (cardCommand == null) {
            throw new IllegalArgumentException("card command not permitted as null");
        }
        if (cardCommand.getBytes() == null) {
            throw new IllegalArgumentException("card command not permitted to contain empty byte array");
        }
        if (cardCommand.getBytes().length == 0) {
            throw new IllegalArgumentException("empty card command not permitted");
        }
        switch (pinCoding) {
            case 0: 
            case 1: {
                if (cardCommand.getBytes().length >= 4) break;
                throw new IllegalArgumentException(" for pin coding at least 4 bytes for command expected");
            }
            case 2: {
                if (cardCommand.getBytes().length >= minimumF2BCardCommandLength) break;
                throw new IllegalArgumentException(" for F2B pin coding at least " + minimumF2BCardCommandLength + " bytes for command expected");
            }
            default: {
                throw new IllegalArgumentException("unknown pin encoding: " + pinCoding);
            }
        }
    }

    private void checkInsertionPosition(byte pinCoding, int pinInsertPosition, Integer newPinInsertPosition) throws IllegalArgumentException {
        Integer lNewPinInsertPosition = newPinInsertPosition;
        if (pinInsertPosition < 0) {
            throw new IllegalArgumentException("pin insertion position must be greater equals 0");
        }
        if (lNewPinInsertPosition != null && lNewPinInsertPosition < 0) {
            throw new IllegalArgumentException("new pin insertion position must be greater equals 0");
        }
        if (lNewPinInsertPosition != null && pinInsertPosition >= lNewPinInsertPosition) {
            throw new IllegalArgumentException("pin insertion position must be less than new pin insertion position");
        }
        switch (pinCoding) {
            case 2: {
                if (pinInsertPosition != 6) {
                    throw new IllegalArgumentException(" illegal insertion position for Format 2 Pin block, 6 only permitted");
                }
                if (lNewPinInsertPosition == null || lNewPinInsertPosition == 14) break;
                throw new IllegalArgumentException("new PIN insertion position must be 14, other values not permitted");
            }
        }
    }

    private void checkPinCoding(byte pinCoding) throws IllegalArgumentException {
        switch (pinCoding) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal pin coding, pin coding must be 0 for BCD, 1 for T.50/ASCII or 2 for Format 2 Pin Block coding");
            }
        }
    }

    private void checkPinLength(byte pinLength) throws IllegalArgumentException {
        if (pinLength < 0) {
            throw new IllegalArgumentException("illegal pin length, value must be greater equals 0");
        }
        if (pinLength > 16) {
            throw new IllegalArgumentException("illegal pin length, value must be less equals 16");
        }
    }

    @Override
    public ICCStatusDO createICCStatusDO(int icc, byte[] encoded) throws IllegalArgumentException {
        return new ICCStatusDOImpl(icc, encoded);
    }

    @Override
    public CardTerminalManufacturerDO createCardTerminalManufacturerDO(byte[] data) throws IllegalArgumentException {
        return new CardTerminalManufacturerDOImpl(data);
    }
}

