/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.bcs.impl;

import de.bos_bremen.basecard.terminal.bcs.CardTerminalManufacturerDO;

public class CardTerminalManufacturerDOImpl
implements CardTerminalManufacturerDO {
    private String ctm = null;
    private String cc = null;
    private String ma = null;
    private String ctt = null;
    private String ctsv = null;
    private String dd = null;

    public CardTerminalManufacturerDOImpl(byte[] data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("data not permitted as null");
        }
        if (data.length == 0) {
            throw new IllegalArgumentException("data not permitted as empty array");
        }
        if (data[0] != 70) {
            throw new IllegalArgumentException("data for cardterminal manufacturer data object must start with 70");
        }
        if (Math.abs(data[1]) + 2 != data.length) {
            throw new IllegalArgumentException("inconsistent data, length of array does not match to length of data object, expected: " + Math.abs(data[1]) + "2");
        }
        this.ctm = new String(data, 2, 5);
        this.cc = this.ctm.substring(0, 2);
        this.ma = this.ctm.substring(2);
        this.ctt = new String(data, 7, 5);
        this.ctsv = new String(data, 12, 5);
        this.dd = new String(data, 17, data.length - 2 - 5 - 5 - 5);
    }

    @Override
    public final String getCardterminalManufacturer() {
        return this.ctm;
    }

    @Override
    public final String getCountryCode() {
        return this.cc;
    }

    @Override
    public final String getManufacturerAcronym() {
        return this.ma;
    }

    @Override
    public final String getCardTerminalType() {
        return this.ctt;
    }

    @Override
    public final String getSoftwareVersion() {
        return this.ctsv;
    }

    @Override
    public final String getDiscretionaryData() {
        return this.dd;
    }

    @Override
    public String toString() {
        return super.toString() + "\n  Manufacturer:      " + this.ctm + "\n    Country code:    " + this.cc + "\n    Acronym:         " + this.ma + "\n  Type:              " + this.ctt + "\n  Software revision: " + this.ctsv + "\n  Disretionary data: " + this.dd;
    }
}

