/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.bcs.impl;

import de.bos_bremen.basecard.Command;
import de.bos_bremen.basecard.Response;
import de.bos_bremen.basecard.impl.CommandImpl;
import de.bos_bremen.basecard.terminal.BTerminalException;
import de.bos_bremen.basecard.terminal.bcs.BCSExceptionMapper;
import de.bos_bremen.basecard.terminal.bcs.BCSTerminal;
import de.bos_bremen.basecard.terminal.bcs.BCSTerminalInfo;
import de.bos_bremen.basecard.terminal.impl.AbstractBTerminalImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.log4j.Logger;

public abstract class AbstractBCSTerminalImpl<T extends BCSTerminalInfo>
extends AbstractBTerminalImpl
implements BCSTerminal {
    private static final Logger LOG = Logger.getLogger(AbstractBCSTerminalImpl.class);
    protected T terminalInfo = null;

    public AbstractBCSTerminalImpl(T terminalInfo) throws IllegalArgumentException {
        super(BCSExceptionMapper.getMapper());
        this.terminalInfo = terminalInfo;
        if (this.mapper == null) {
            throw new IllegalArgumentException("mapper not successfully initialized");
        }
    }

    @Override
    public final BCSTerminalInfo getTerminalInfo() {
        return this.terminalInfo;
    }

    protected final T getInfo() {
        return this.terminalInfo;
    }

    protected Command buildCTBCSCommand(byte ins, byte p1, byte p2, byte[] datafield, Integer le) {
        return new CommandImpl(this.buildISO7816Command((byte)32, ins, p1, p2, datafield, le));
    }

    protected byte[] buildByteArrayCTBCSCommand(byte ins, byte p1, byte p2, byte[] datafield, Integer le) {
        return this.buildISO7816Command((byte)32, ins, p1, p2, datafield, le);
    }

    protected byte[] buildISO7816Command(byte cla, byte ins, byte p1, byte p2, byte[] datafield, Integer le) throws IllegalArgumentException {
        if (datafield != null && datafield.length >= 65536) {
            throw new IllegalArgumentException("data field too long");
        }
        if (le != null && le >= 65536) {
            throw new IllegalArgumentException("data field too long");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(new byte[]{32, ins, p1, p2});
            byte[] lcBytes = null;
            byte[] leBytes = null;
            if ((datafield == null || datafield.length == 0) && le == null) {
                LOG.debug((Object)"");
            } else if (datafield != null && datafield.length > 0 && le != null) {
                if (datafield.length >= 256 || le >= 256) {
                    byte[] tmp = BigInteger.valueOf(datafield.length).toByteArray();
                    lcBytes = new byte[3];
                    System.arraycopy(tmp, 0, lcBytes, 3 - tmp.length, tmp.length);
                    tmp = BigInteger.valueOf(le.intValue()).toByteArray();
                    leBytes = new byte[2];
                    System.arraycopy(tmp, 0, leBytes, 2 - Math.min(2, tmp.length), Math.min(2, tmp.length));
                } else {
                    lcBytes = new byte[]{(byte)datafield.length};
                    leBytes = new byte[]{(byte)le.intValue()};
                }
            } else if (le != null) {
                if (le >= 256) {
                    byte[] tmp = BigInteger.valueOf(le.intValue()).toByteArray();
                    leBytes = new byte[3];
                    System.arraycopy(tmp, 0, leBytes, 3 - tmp.length, tmp.length);
                } else {
                    leBytes = new byte[]{(byte)le.intValue()};
                }
            } else if (datafield != null) {
                if (datafield.length >= 256) {
                    byte[] tmp = BigInteger.valueOf(datafield.length).toByteArray();
                    lcBytes = new byte[3];
                    System.arraycopy(tmp, 0, lcBytes, 3 - tmp.length, tmp.length);
                } else {
                    lcBytes = new byte[]{(byte)datafield.length};
                }
            }
            if (lcBytes != null) {
                baos.write(lcBytes);
                baos.write(datafield);
            }
            if (leBytes != null) {
                baos.write(leBytes);
            }
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            LOG.debug((Object)"IOException occured using ByteArrayOutputStream");
        }
        return baos.toByteArray();
    }

    protected void checkResponse(Command command, Response response) throws BTerminalException {
        this.mapper.checkExecution(command, response);
    }
}

