/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.pin.coding.impl;

import de.bos_bremen.basecard.common.pin.coding.impl.AbstractPinEncoding;
import de.bos_bremen.common.ByteUtil;
import java.util.Arrays;

public class T50PinEncoding
extends AbstractPinEncoding {
    public T50PinEncoding() {
        super("T.50 Encoding");
    }

    @Override
    public byte[] encode(byte[] pin, Integer padLength, Byte padByte) throws IllegalArgumentException {
        this.checkArguments(pin, padLength, padByte);
        int l = Math.max(padLength != null ? padLength.intValue() : VARIABLE_PAD_LENGTH.intValue(), pin != null ? pin.length : VARIABLE_PAD_LENGTH);
        if (l == 0) {
            return EMPTY_ARRAY;
        }
        if (padLength != null && padLength.intValue() != VARIABLE_PAD_LENGTH.intValue() && l < super.getMinimumLength()) {
            throw new IllegalArgumentException("result expected by padding length or given pin to be greater than minimum length of pin: " + super.getMinimumLength());
        }
        byte[] result = new byte[l];
        if (padByte != null) {
            Arrays.fill(result, padByte);
        } else {
            Arrays.fill(result, (byte)0);
        }
        if (pin != null && pin.length > 0) {
            System.arraycopy(pin, 0, result, 0, pin.length);
        }
        return result;
    }

    @Override
    public byte[] encode(byte[] pin, Integer padLength, Byte padByte, boolean includingLength) throws IllegalArgumentException {
        byte[] encodingWithoutLength = this.encode(pin, padLength, padByte);
        if (includingLength && pin != null) {
            byte[] result = ByteUtil.combine(new byte[]{(byte)pin.length}, encodingWithoutLength);
            return ByteUtil.subbytes(result, 0, result.length - 1);
        }
        if (includingLength) {
            byte[] result = ByteUtil.combine(new byte[]{0}, encodingWithoutLength);
            return ByteUtil.subbytes(result, 0, result.length - 1);
        }
        return encodingWithoutLength;
    }

    private void checkArguments(byte[] pin, Integer padLength, Byte padByte) {
        if (padLength != null && padLength > VARIABLE_PAD_LENGTH && padByte == null) {
            throw new IllegalArgumentException("padding byte expected when padding length greater than " + VARIABLE_PAD_LENGTH + " specified");
        }
        if (padByte != null && (padLength == null || padLength.intValue() == VARIABLE_PAD_LENGTH.intValue())) {
            throw new IllegalArgumentException("padding length expected to be greater than " + VARIABLE_PAD_LENGTH + " when padding byte is specified");
        }
        if (padLength != null && padLength < VARIABLE_PAD_LENGTH) {
            throw new IllegalArgumentException("positive pad length expected");
        }
        if (padLength != null && padLength > super.getMaximumLength()) {
            throw new IllegalArgumentException("padding length exceeds maximum length of pin: " + super.getMaximumLength());
        }
        if (pin != null && pin.length > super.getMaximumLength()) {
            throw new IllegalArgumentException("length of given pin exceeds maximum length of pin: " + super.getMaximumLength());
        }
        if (pin != null && pin.length != VARIABLE_PAD_LENGTH && pin.length < super.getMinimumLength()) {
            throw new IllegalArgumentException("length of given pin expected to greather than minimum length of pin: " + super.getMinimumLength());
        }
    }
}

