/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.pin.coding.impl;

import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.basecard.common.pin.coding.PinEncoding;
import de.bos_bremen.basecard.common.pin.coding.impl.AbstractPinEncoder;
import de.bos_bremen.basecard.common.pin.coding.impl.BCDPinEncoder;
import de.bos_bremen.basecard.common.pin.coding.impl.Format1PinBlockEncoder;
import de.bos_bremen.basecard.common.pin.coding.impl.Format2PinBlockEncoder;
import de.bos_bremen.basecard.common.pin.coding.impl.T50PinEncoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PinEncoderFactory {
    private static PinEncoderFactory singleton = null;
    private Map<String, PinEncoder> encoderMap = null;
    private Map<String, PinEncoder> externalEncoderMap = null;

    private PinEncoderFactory() {
        this.initEncoderMap();
    }

    private void initEncoderMap() {
        this.encoderMap = Collections.synchronizedMap(new LinkedHashMap());
        this.addEncoder(new T50PinEncoder());
        this.addEncoder(new Format2PinBlockEncoder());
        this.addEncoder(new Format1PinBlockEncoder());
        this.addEncoder(new BCDPinEncoder());
        this.externalEncoderMap = Collections.unmodifiableMap(this.encoderMap);
    }

    public Map<String, PinEncoder> getEncoderMap() {
        return this.externalEncoderMap;
    }

    public PinEncoder getEncoder(String name) {
        return this.encoderMap.get(name);
    }

    public boolean registerEncoder(PinEncoder encoder) throws IllegalArgumentException {
        boolean result = false;
        if (encoder != null && !this.encoderMap.containsKey(encoder.getName())) {
            result = this.addEncoder(encoder);
        }
        return result;
    }

    public boolean unregisterEncoder(PinEncoder encoder) {
        boolean result = false;
        if (encoder != null && this.encoderMap.containsKey(encoder.getName())) {
            result = this.removeEncoder(encoder);
        }
        return result;
    }

    private boolean addEncoder(PinEncoder encoder) throws IllegalArgumentException {
        boolean result = false;
        String name = encoder.getName();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name of encoder have to specified (null or empty name not admitted)");
        }
        this.encoderMap.put(encoder.getName(), encoder);
        result = true;
        return result;
    }

    private boolean removeEncoder(PinEncoder encoder) {
        boolean result = false;
        String name = encoder.getName();
        if (name != null && name.length() > 0) {
            this.encoderMap.remove(encoder.getName());
            result = true;
        }
        return result;
    }

    public PinEncoder createCustomEncoder(PinEncoding encoding, byte id, byte ccidid, Integer padLength, Byte padByte, boolean unitByte, boolean padLengthByte) {
        return new DefaultCustomPinEncoder(encoding, id, ccidid, padLength, padByte, unitByte, padLengthByte);
    }

    public static synchronized PinEncoderFactory getInstance() {
        if (singleton == null) {
            singleton = new PinEncoderFactory();
        }
        return singleton;
    }

    public byte[] encode(String encodingName, byte[] pin, Integer padLength, Byte padByte) throws IllegalArgumentException {
        PinEncoder encoder = this.getEncoder(encodingName);
        if (encoder == null) {
            throw new IllegalArgumentException("no encoder registered for '" + encodingName + "'");
        }
        return encoder.encode(pin, padLength, padByte);
    }

    private class DefaultCustomPinEncoder
    extends AbstractPinEncoder {
        DefaultCustomPinEncoder(PinEncoding encoding, byte id, byte ccidid, Integer padLength, Byte padByte, boolean unitByte, boolean padLengthByte) {
            super(encoding, id, ccidid, padLength, padByte, unitByte, padLengthByte);
        }
    }
}

