/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.pin.coding.impl;

import de.bos_bremen.basecard.common.pin.coding.impl.AbstractPinEncoding;
import de.bos_bremen.common.HexUtil;
import java.util.Arrays;

public class Format2PinBlockEncoding
extends AbstractPinEncoding {
    public Format2PinBlockEncoding() {
        super("Format 2 Pin Block Encoding");
    }

    @Override
    public byte[] encode(byte[] pin, Integer padLength, Byte padByte) throws IllegalArgumentException {
        this.checkArguments(pin, padLength, padByte);
        byte[] result = new byte[FORMAT_PIN_BLOCK_PADDING_LENGTH.intValue()];
        Arrays.fill(result, PADDING_BYTE);
        result[0] = 47;
        if (pin != null && pin.length != 0) {
            result[0] = (byte)(result[0] & 0xFFFFFFF0);
            result[0] = (byte)(result[0] | pin.length);
            Format2PinBlockEncoding.insertPin(pin, result, 1);
        }
        return result;
    }

    @Override
    public byte[] encode(byte[] pin, Integer padLength, Byte padByte, boolean lengthIncluded) throws IllegalArgumentException {
        return this.encode(pin, padLength, padByte);
    }

    private void checkArguments(byte[] pin, Integer padLength, Byte padByte) {
        if (padLength != null && padLength.intValue() != FORMAT_PIN_BLOCK_PADDING_LENGTH.intValue()) {
            throw new IllegalArgumentException("given padding length does not match specified length of encoding: " + FORMAT_PIN_BLOCK_PADDING_LENGTH);
        }
        if (pin != null && pin.length != 0 && pin.length > super.getMaximumLength()) {
            throw new IllegalArgumentException("length of pin exceeds maximum length: " + super.getMaximumLength());
        }
        if (pin != null && pin.length != 0 && pin.length < super.getMinimumLength()) {
            throw new IllegalArgumentException("length of pin expected to be greater than minimum length: " + super.getMinimumLength());
        }
        if (padByte != null && padByte.byteValue() != PADDING_BYTE.byteValue()) {
            throw new IllegalArgumentException("padding byte expected to specified as " + HexUtil.hexify((byte)PADDING_BYTE) + ", other values not admitted through specification of encoding");
        }
    }
}

