/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.pin.coding.impl;

import de.bos_bremen.basecard.common.pin.coding.PinEncoding;

public abstract class AbstractPinEncoding
implements PinEncoding {
    private final String name;
    private final int minimumLength;
    private final int maximumLength;

    public AbstractPinEncoding(String name) {
        this(name, 4, 12);
    }

    public AbstractPinEncoding(String name, int minimumLength, int maximumLength) {
        this.name = name;
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getMinimumLength() {
        return this.minimumLength;
    }

    @Override
    public final int getMaximumLength() {
        return this.maximumLength;
    }

    @Override
    public abstract byte[] encode(byte[] var1, Integer var2, Byte var3) throws IllegalArgumentException;

    protected static void insertPin(byte[] pin, byte[] result) {
        AbstractPinEncoding.insertPin(pin, result, 0);
    }

    protected static void insertPin(byte[] pin, byte[] encodedPin, int offset) {
        if (pin != null && pin.length > 0) {
            for (int i = 0; i < pin.length; ++i) {
                byte b = (byte)(pin[i] & 0xF);
                int pos = i / 2 + offset;
                if (i % 2 == 0) {
                    int n = pos;
                    encodedPin[n] = (byte)(encodedPin[n] & 0xF);
                    b = (byte)(b << 4);
                } else {
                    int n = pos;
                    encodedPin[n] = (byte)(encodedPin[n] & 0xFFFFFFF0);
                }
                int n = pos;
                encodedPin[n] = (byte)(encodedPin[n] | b);
            }
        }
    }
}

