/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.pin.coding.impl;

import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.basecard.common.pin.coding.PinEncoding;
import java.nio.charset.Charset;

public abstract class AbstractPinEncoder
implements PinEncoder {
    private final PinEncoding encoding;
    private final byte id;
    private final byte ccidid;
    private final Integer iPadLength;
    private final Byte iPadByte;
    private final boolean unitByte;
    private final boolean padLengthByte;

    public AbstractPinEncoder(PinEncoding encoding, byte id, byte ccidid, Integer padLength, Byte padByte, boolean unitByte, boolean padLengthByte) {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding implementation required");
        }
        this.id = id;
        this.ccidid = ccidid;
        this.iPadLength = padLength;
        this.iPadByte = padByte;
        this.unitByte = unitByte;
        this.padLengthByte = padLengthByte;
        this.encoding = encoding;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public byte[] encode(byte[] pin) throws IllegalArgumentException {
        return this.encode(pin, null, null);
    }

    @Override
    public final byte[] encode(byte[] pin, Integer padLength, Byte padByte) throws IllegalArgumentException {
        return this.encoding.encode(pin, padLength, padByte);
    }

    @Override
    public final byte[] encode(byte[] pin, Integer padLength, Byte padByte, boolean includingLength) throws IllegalArgumentException {
        return this.encoding.encode(pin, padLength, padByte, includingLength);
    }

    @Override
    public final byte[] encode(char[] pin) throws IllegalArgumentException {
        return this.encode(pin, null, null);
    }

    @Override
    public final byte[] encode(char[] pin, Integer padLength, Byte padByte) throws IllegalArgumentException {
        byte[] pinBytes = null;
        if (pin != null) {
            pinBytes = new byte[pin.length];
            for (int i = 0; i < pinBytes.length; ++i) {
                pinBytes[i] = (byte)pin[i];
            }
        }
        return this.encode(pinBytes, padLength, padByte);
    }

    @Override
    public final byte[] encode(String pin, Integer padLength, Byte padByte) throws IllegalArgumentException {
        return this.encode(pin != null ? pin.getBytes(Charset.defaultCharset()) : (byte[])null, padLength, padByte);
    }

    @Override
    public final byte[] encode(String pin) throws IllegalArgumentException {
        return this.encode(pin, null, null);
    }

    @Override
    public final byte getID() {
        return this.id;
    }

    @Override
    public final byte getCCIDID() {
        return this.ccidid;
    }

    @Override
    public final String getName() {
        return this.encoding.getName();
    }

    @Override
    public final int getMinimumLength() {
        return this.encoding.getMinimumLength();
    }

    @Override
    public final int getMaximumLength() {
        return this.encoding.getMaximumLength();
    }

    @Override
    public final Integer getPadLength() {
        return this.iPadLength;
    }

    @Override
    public final Byte getPadByte() {
        return this.iPadByte;
    }

    @Override
    public final boolean isPadLengthByte() {
        return this.padLengthByte;
    }

    @Override
    public final boolean isUnitByte() {
        return this.unitByte;
    }
}

