/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.pin;

import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.system.LanguageEnum;

public class PinVerifyParameters {
    private byte[] template = null;
    private byte pinID = 0;
    private PinEncoder encoder = null;
    private Integer blockLength = null;
    private Byte padByte = null;
    private boolean encodePinLength = false;
    private int minPinLength = 0;
    private int maxPinLength = 0;
    private int firstTimeout = 0;
    private int secondTimeout = 0;
    private LanguageEnum language = null;
    private boolean usesCCID = false;

    public PinVerifyParameters(byte pinID, PinEncoder encoder, Integer blockLength, Byte padByte, boolean encodePinLength, int minPinLength, int maxPinLength, int firstTimeout, int secondTimeout, LanguageEnum language, boolean usesCCID) throws IllegalArgumentException {
        PinVerifyParameters.internalCheck(encoder, blockLength, padByte, encodePinLength, minPinLength, maxPinLength, language);
        this.pinID = pinID;
        this.encoder = encoder;
        this.blockLength = blockLength;
        this.padByte = padByte;
        this.encodePinLength = encodePinLength;
        this.minPinLength = minPinLength;
        this.maxPinLength = maxPinLength;
        this.firstTimeout = firstTimeout;
        this.secondTimeout = secondTimeout;
        this.language = language;
        this.usesCCID = usesCCID;
    }

    public PinVerifyParameters(byte[] template, PinEncoder encoder, Integer blockLength, Byte padByte, boolean encodePinLength, int minPinLength, int maxPinLength, int firstTimeout, int secondTimeout, LanguageEnum language, boolean usesCCID) throws IllegalArgumentException {
        PinVerifyParameters.internalCheck(encoder, blockLength, padByte, encodePinLength, minPinLength, maxPinLength, language);
        this.template = template;
        this.encoder = encoder;
        this.blockLength = blockLength;
        this.padByte = padByte;
        this.encodePinLength = encodePinLength;
        this.minPinLength = minPinLength;
        this.maxPinLength = maxPinLength;
        this.firstTimeout = firstTimeout;
        this.secondTimeout = secondTimeout;
        this.language = language;
        this.usesCCID = usesCCID;
    }

    public void setTemplate(byte[] template) {
        this.template = template;
    }

    public byte[] getTemplate() {
        return this.template;
    }

    public byte getPinID() {
        return this.pinID;
    }

    public PinEncoder getEncoder() {
        return this.encoder;
    }

    public Integer getBlockLength() {
        return this.blockLength;
    }

    public Byte getPadByte() {
        return this.padByte;
    }

    public boolean encodePinLength() {
        return this.encodePinLength;
    }

    public int getMinPinLength() {
        return this.minPinLength;
    }

    public int getMaxPinLength() {
        return this.maxPinLength;
    }

    public int getFirstTimeout() {
        return this.firstTimeout;
    }

    public int getSecondTimeout() {
        return this.secondTimeout;
    }

    public LanguageEnum getLanguage() {
        return this.language;
    }

    public boolean usesCCID() {
        return this.usesCCID;
    }

    private static void internalCheck(PinEncoder encoder, Integer blockLength, Byte padByte, boolean encodePinLength, int minPinLength, int maxPinLength, LanguageEnum language) throws IllegalArgumentException {
        if (encoder == null) {
            throw new IllegalArgumentException("encoder must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("language must not be null");
        }
        if (blockLength == null != (padByte == null)) {
            throw new IllegalArgumentException("blockLength and padByte must be either both null or both not null");
        }
        if (!(encoder != PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK && encoder != PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK || encodePinLength)) {
            throw new IllegalArgumentException("illegal combination of arguments: in format 1 and 2, pin length must always be encoded");
        }
        if (maxPinLength < minPinLength) {
            throw new IllegalArgumentException("maxPinLength must not be less than minPinLength");
        }
        if (encoder == PinEncoder.ENCODER_T50) {
            if (minPinLength < 4) {
                throw new IllegalArgumentException("minPinLength must be at least 4");
            }
            if (maxPinLength > 255) {
                throw new IllegalArgumentException("maxPinLength must be no more than 255");
            }
        } else if (encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK || encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK || encoder == PinEncoder.ENCODER_BCD) {
            if (minPinLength < 4) {
                throw new IllegalArgumentException("minPinLength must be at least 4");
            }
            if (maxPinLength > 12) {
                throw new IllegalArgumentException("maxPinLength must be no more than 12");
            }
        }
    }
}

