/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.crypto;

import de.bos_bremen.basecard.common.crypto.XMGF1ParameterSpec;
import de.bos_bremen.basecard.common.crypto.XParameterSpec;
import de.bos_bremen.common.crypto.AlgorithmType;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class XPSSParameterSpec
extends PSSParameterSpec
implements XParameterSpec<RSASSAPSSparams> {
    public static final String ALGORITHM_PARAMETERS_PSS_ROVIDER_NAME = "BC";
    public static final String ALGORITHM_PARAMETERS_PSS = "PSS";
    public static final String DEFAULT_DIGEST_ALGORITHM = "SHA-1";
    public static final String DEFAULT_MGF = "MGF-1";
    public static final MGF1ParameterSpec DEFAULT_SPEC = MGF1ParameterSpec.SHA1;
    private final AlgorithmType digestAlgorithmType;
    private final AlgorithmType mgfType;
    private static final AlgorithmType TYPE = AlgorithmType.RSASSA_PSS;
    private final RSASSAPSSparams bouncyParameters;

    public XPSSParameterSpec(AlgorithmIdentifier algorithmIdentifier) throws NoSuchAlgorithmException, InvalidParameterSpecException, NoSuchProviderException, IOException {
        this(XPSSParameterSpec.createSpec(algorithmIdentifier.getParameters().toASN1Primitive().getEncoded()));
    }

    public XPSSParameterSpec(AlgorithmParameters parameters) throws NoSuchAlgorithmException, InvalidParameterSpecException, NoSuchProviderException, IOException {
        this(XPSSParameterSpec.createSpec(parameters.getEncoded()));
    }

    public static XPSSParameterSpec createSpec(byte[] pssParamsEncoded) throws NoSuchAlgorithmException, IOException, InvalidParameterSpecException, NoSuchProviderException {
        AlgorithmParameters ap = AlgorithmParameters.getInstance(ALGORITHM_PARAMETERS_PSS, ALGORITHM_PARAMETERS_PSS_ROVIDER_NAME);
        ap.init(pssParamsEncoded);
        return new XPSSParameterSpec(ap.getParameterSpec(PSSParameterSpec.class));
    }

    public XPSSParameterSpec(RSASSAPSSparams params) throws NoSuchAlgorithmException, IOException, InvalidParameterSpecException, NoSuchProviderException {
        this(XPSSParameterSpec.createSpec(params.getEncoded()));
    }

    public XPSSParameterSpec(PSSParameterSpec pssSpec) throws NullPointerException, NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IOException {
        this(pssSpec.getDigestAlgorithm(), pssSpec.getMGFAlgorithm(), pssSpec.getMGFParameters(), pssSpec.getSaltLength(), pssSpec.getTrailerField());
    }

    public XPSSParameterSpec(int saltLen) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IOException {
        super(DEFAULT_DIGEST_ALGORITHM, DEFAULT_MGF, new XMGF1ParameterSpec(DEFAULT_SPEC), saltLen, 1);
        this.digestAlgorithmType = AlgorithmType.getType(DEFAULT_DIGEST_ALGORITHM);
        this.mgfType = AlgorithmType.getType(DEFAULT_MGF, AlgorithmType.Context.SIGNING);
        this.bouncyParameters = this.createParams();
    }

    public XPSSParameterSpec(String mdName, String mgfName, AlgorithmParameterSpec mgfSpec, int saltLen, int trailerField) throws NullPointerException, NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IOException {
        super(AlgorithmType.getType(mdName).getName(), AlgorithmType.getType(mgfName).getName(), new XMGF1ParameterSpec(mgfSpec), saltLen, trailerField);
        this.digestAlgorithmType = AlgorithmType.getType(mdName);
        this.mgfType = AlgorithmType.getType(mgfName, AlgorithmType.Context.SIGNING);
        this.bouncyParameters = this.createParams();
    }

    public XPSSParameterSpec(String mdName, MGF1ParameterSpec mgfSpec, int saltLen, int trailerField) throws NullPointerException, NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IOException {
        super(mdName, DEFAULT_MGF, new XMGF1ParameterSpec(mgfSpec), saltLen, trailerField);
        this.digestAlgorithmType = AlgorithmType.getType(mdName);
        this.mgfType = AlgorithmType.MGF1PSS;
        this.bouncyParameters = this.createParams();
    }

    private RSASSAPSSparams createParams() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IOException {
        AlgorithmParameters ap = AlgorithmParameters.getInstance(ALGORITHM_PARAMETERS_PSS, ALGORITHM_PARAMETERS_PSS_ROVIDER_NAME);
        ap.init(this);
        return RSASSAPSSparams.getInstance((Object)ASN1Sequence.getInstance((Object)ap.getEncoded()));
    }

    @Override
    public AlgorithmType getType() {
        return TYPE;
    }

    @Override
    public String getName() {
        return TYPE.getName();
    }

    @Override
    public String getURI() {
        return TYPE.getURI();
    }

    @Override
    public String getOID() {
        return TYPE.getOID();
    }

    @Override
    public String getDigestAlgorithm() {
        return this.digestAlgorithmType.getName();
    }

    @Override
    public AlgorithmType getDigestAlgorithmType() {
        return this.digestAlgorithmType;
    }

    @Override
    public String getDigestAlgorithmURI() {
        return this.digestAlgorithmType.getURI();
    }

    @Override
    public String getDigestAlgorithmOID() {
        return this.digestAlgorithmType.getOID();
    }

    @Override
    public String getMGFAlgorithm() {
        return this.mgfType.getName();
    }

    @Override
    public String getMGFAlgorithmURI() {
        return this.mgfType.getURI();
    }

    @Override
    public String getMGFAlgorithmOID() {
        return this.mgfType.getOID();
    }

    @Override
    public AlgorithmType getMGFType() {
        return this.mgfType;
    }

    @Override
    public RSASSAPSSparams getBouncyCastleParams() {
        return this.bouncyParameters;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.bouncyParameters.toASN1Primitive().getEncoded("DER");
    }
}

