/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.crypto;

import de.bos_bremen.basecard.common.crypto.XMGF1ParameterSpec;
import de.bos_bremen.basecard.common.crypto.XParameterSpec;
import de.bos_bremen.common.crypto.AlgorithmType;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class XOAEPParameterSpec
extends OAEPParameterSpec
implements XParameterSpec<RSAESOAEPparams> {
    public static final String ALGORITHM_PARAMETERS_OAEP_ROVIDER_NAME = "BC";
    public static final String ALGORITHM_PARAMETERS_OAEP = "OAEP";
    private final RSAESOAEPparams bouncyParameters;
    private final AlgorithmType digestAlgorithmType;
    private final AlgorithmType mgfType;
    private static final AlgorithmType TYPE = AlgorithmType.RSAES_OAEP;

    public XOAEPParameterSpec(AlgorithmIdentifier algorithmIdentifier) throws NoSuchAlgorithmException, InvalidParameterSpecException, NoSuchProviderException, IOException {
        this(XOAEPParameterSpec.createSpec(algorithmIdentifier.getParameters().toASN1Primitive().getEncoded("DER")));
    }

    public XOAEPParameterSpec(AlgorithmParameters parameters) throws NoSuchAlgorithmException, InvalidParameterSpecException, NoSuchProviderException, IOException {
        this(XOAEPParameterSpec.createSpec(parameters.getEncoded()));
    }

    public XOAEPParameterSpec(RSAESOAEPparams params) throws NoSuchAlgorithmException, IOException, InvalidParameterSpecException, NoSuchProviderException {
        this(XOAEPParameterSpec.createSpec(params.getEncoded()));
    }

    public static XOAEPParameterSpec createSpec(byte[] oaepParamsEncoded) throws NoSuchAlgorithmException, IOException, InvalidParameterSpecException, NoSuchProviderException {
        AlgorithmParameters ap = AlgorithmParameters.getInstance(ALGORITHM_PARAMETERS_OAEP, ALGORITHM_PARAMETERS_OAEP_ROVIDER_NAME);
        ap.init(oaepParamsEncoded);
        return new XOAEPParameterSpec(ap.getParameterSpec(OAEPParameterSpec.class));
    }

    public XOAEPParameterSpec(OAEPParameterSpec oaepSpec) throws NullPointerException, NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IOException {
        this(oaepSpec.getDigestAlgorithm(), oaepSpec.getMGFAlgorithm(), oaepSpec.getMGFParameters(), oaepSpec.getPSource());
    }

    public XOAEPParameterSpec(String mdName, String mgfName, AlgorithmParameterSpec mgfSpec, PSource pSrc) throws NullPointerException, NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IOException {
        super(AlgorithmType.getType(mdName).getName(), AlgorithmType.getType(mgfName, AlgorithmType.Context.CIPHERING).getName(), new XMGF1ParameterSpec(mgfSpec), pSrc);
        this.digestAlgorithmType = AlgorithmType.getType(mdName);
        this.mgfType = AlgorithmType.getType(mgfName, AlgorithmType.Context.CIPHERING);
        AlgorithmParameters ap = AlgorithmParameters.getInstance(ALGORITHM_PARAMETERS_OAEP, ALGORITHM_PARAMETERS_OAEP_ROVIDER_NAME);
        ap.init(this);
        this.bouncyParameters = RSAESOAEPparams.getInstance((Object)ap.getEncoded());
    }

    @Override
    public AlgorithmType getType() {
        return TYPE;
    }

    @Override
    public String getName() {
        return TYPE.getName();
    }

    @Override
    public String getURI() {
        return TYPE.getURI();
    }

    @Override
    public String getOID() {
        return TYPE.getOID();
    }

    @Override
    public String getDigestAlgorithm() {
        return this.digestAlgorithmType.getName();
    }

    @Override
    public AlgorithmType getDigestAlgorithmType() {
        return this.digestAlgorithmType;
    }

    @Override
    public String getDigestAlgorithmURI() {
        return this.digestAlgorithmType.getURI();
    }

    @Override
    public String getDigestAlgorithmOID() {
        return this.digestAlgorithmType.getOID();
    }

    @Override
    public String getMGFAlgorithm() {
        return super.getMGFAlgorithm();
    }

    @Override
    public String getMGFAlgorithmURI() {
        return this.mgfType.getURI();
    }

    @Override
    public String getMGFAlgorithmOID() {
        return this.mgfType.getOID();
    }

    @Override
    public AlgorithmType getMGFType() {
        return this.mgfType;
    }

    @Override
    public RSAESOAEPparams getBouncyCastleParams() {
        return this.bouncyParameters;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.bouncyParameters.toASN1Primitive().getEncoded("DER");
    }
}

