/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.crypto;

import de.bos_bremen.basecard.common.crypto.XDigestParameterSpec;
import de.bos_bremen.common.crypto.AlgorithmType;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class XMGF1ParameterSpec
extends MGF1ParameterSpec
implements XDigestParameterSpec<ASN1Encodable> {
    public static final XMGF1ParameterSpec SHA1 = new XMGF1ParameterSpec(MGF1ParameterSpec.SHA1);
    public static final XMGF1ParameterSpec SHA224 = new XMGF1ParameterSpec("SHA-224");
    public static final XMGF1ParameterSpec SHA256 = new XMGF1ParameterSpec(MGF1ParameterSpec.SHA256);
    public static final XMGF1ParameterSpec SHA384 = new XMGF1ParameterSpec(MGF1ParameterSpec.SHA384);
    public static final XMGF1ParameterSpec SHA512 = new XMGF1ParameterSpec(MGF1ParameterSpec.SHA512);
    private final AlgorithmType digestAlgorithmType;
    private final ASN1Encodable bouncyParameters;

    public XMGF1ParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this(XMGF1ParameterSpec.castSpec(algorithmParameterSpec) == null ? null : XMGF1ParameterSpec.castSpec(algorithmParameterSpec).getDigestAlgorithm());
    }

    public static MGF1ParameterSpec castSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        if (MGF1ParameterSpec.class.isInstance(algorithmParameterSpec)) {
            return (MGF1ParameterSpec)MGF1ParameterSpec.class.cast(algorithmParameterSpec);
        }
        return null;
    }

    public XMGF1ParameterSpec(MGF1ParameterSpec mgf1ParameterSpec) {
        this(mgf1ParameterSpec.getDigestAlgorithm());
    }

    public XMGF1ParameterSpec(XMGF1ParameterSpec mgf1ParameterSpec) {
        this(mgf1ParameterSpec.getDigestAlgorithm());
    }

    public XMGF1ParameterSpec(String mdName) {
        super(AlgorithmType.getType(mdName).getName());
        this.digestAlgorithmType = AlgorithmType.getType(mdName);
        this.bouncyParameters = new AlgorithmIdentifier(new ASN1ObjectIdentifier(this.digestAlgorithmType.getOID()), (ASN1Encodable)DERNull.INSTANCE);
    }

    @Override
    public String getDigestAlgorithm() {
        return this.digestAlgorithmType.getName();
    }

    @Override
    public AlgorithmType getDigestAlgorithmType() {
        return this.digestAlgorithmType;
    }

    @Override
    public String getDigestAlgorithmURI() {
        return this.digestAlgorithmType.getURI();
    }

    @Override
    public String getDigestAlgorithmOID() {
        return this.digestAlgorithmType.getOID();
    }

    @Override
    public ASN1Encodable getBouncyCastleParams() {
        return this.bouncyParameters;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.bouncyParameters.toASN1Primitive().getEncoded("DER");
    }
}

