/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.crypto;

import de.bos_bremen.common.AssertUtil;
import java.util.List;

public interface UsageRelated {
    public static final String ACRONYM_USAGE_SIGNATURE = "S";
    public static final String ACRONYM_USAGE_AUTHENTICATION = "A";
    public static final String ACRONYM_USAGE_CIPHER = "C";
    public static final String ACRONYM_USAGE_KEYAGREEMENT = "K";

    public boolean isSignatureRelated();

    public boolean isAuthenticationRelated();

    public boolean isDecryptionRelated();

    public boolean isKeyAgreementRelated();

    public List<Usage> getUsageList();

    public static enum Usage {
        SIGNATURE("S"),
        AUTHENTICATION("A"),
        CIPHER("C"),
        KEYAGREEMENT("K");

        private final String acronym;

        private Usage(String acronym) throws IllegalArgumentException {
            AssertUtil.notNullOrEmpty(acronym, "acronym");
            this.acronym = acronym;
        }

        public String getAcronym() {
            return this.acronym;
        }
    }
}

