/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.crypto;

import de.bos_bremen.basecard.common.crypto.StatefulParameterSpec;
import java.security.spec.AlgorithmParameterSpec;

public class CardUserParameterSpec
implements AlgorithmParameterSpec,
StatefulParameterSpec {
    public static final PinMode DEFAULT_EXECUTION_MODE = PinMode.ONCE;
    private Integer firstTimeout;
    private Integer secondTimeout;
    private PinMode mode = DEFAULT_EXECUTION_MODE;
    private boolean initialized = false;

    CardUserParameterSpec() {
    }

    @Override
    public final boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void init(Integer initFirstTimeout, Integer initSecondTimeout, PinMode initMode) throws IllegalStateException, UnsupportedOperationException {
        if (this.initialized) {
            throw new IllegalStateException("CardParameterSpec already initialized");
        }
        this.firstTimeout = initFirstTimeout;
        this.secondTimeout = initSecondTimeout;
        this.mode = initMode == null ? DEFAULT_EXECUTION_MODE : initMode;
        this.initialized = true;
    }

    public final Integer getFirstTimeout() {
        return this.firstTimeout;
    }

    public final Integer getSecondTimeout() {
        return this.secondTimeout;
    }

    public final PinMode getExecutionMode() {
        return this.mode;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    public static enum PinMode {
        ONCE,
        CANCEL_BLOCKED;

    }
}

