/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.crypto;

import de.bos_bremen.basecard.common.crypto.CardExecutionParameterSpec;
import de.bos_bremen.basecard.common.crypto.XPSSParameterSpec;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.crypto.AlgorithmIdentifierHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class CardExecutionSignAuthenticateParameterSpec
extends CardExecutionParameterSpec {
    private static final Log LOG = LogFactory.getLog(CardExecutionSignAuthenticateParameterSpec.class);
    private final Boolean digestInfoUsed;
    private final byte[] algorithmID;

    public CardExecutionSignAuthenticateParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier, Boolean digestInfoUsed, byte[] algorithmID) throws IllegalArgumentException {
        this(algorithmName, algorithmIdentifier, "-", digestInfoUsed, algorithmID);
    }

    public CardExecutionSignAuthenticateParameterSpec(String algorithmName, String algorithmURI, Boolean digestInfoUsed, byte[] algorithmID) throws IllegalArgumentException {
        this(algorithmName, NOT_SPECIFIED_IDENTIFIER, algorithmURI, digestInfoUsed, algorithmID);
    }

    public CardExecutionSignAuthenticateParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier, String algorithmURI, Boolean digestInfoUsed, byte[] algorithmID) throws IllegalArgumentException {
        super(algorithmName, algorithmIdentifier, algorithmURI);
        this.digestInfoUsed = digestInfoUsed;
        this.algorithmID = ByteUtil.copy(algorithmID);
    }

    public Boolean isDigestInfoUsed() {
        return this.digestInfoUsed;
    }

    public byte[] getAlgorithmID() {
        return ByteUtil.copy(this.algorithmID);
    }

    public boolean isPSS() {
        return AlgorithmIdentifierHelper.isPSSAlgorithmIdentifier(this.algorithmIdentifier);
    }

    public XPSSParameterSpec getPSSParameterSpec() {
        if (this.isPSS()) {
            try {
                return new XPSSParameterSpec(this.algorithmIdentifier);
            }
            catch (Exception e) {
                LOG.debug((Object)("failed to deliver PSSParameterSpec: " + e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }
}

