/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.crypto;

import de.bos_bremen.basecard.common.crypto.StatefulParameterSpec;
import de.bos_bremen.common.AssertUtil;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class CardExecutionParameterSpec
implements AlgorithmParameterSpec,
StatefulParameterSpec {
    public static final AlgorithmIdentifier NOT_SPECIFIED_IDENTIFIER = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.3.4"));
    public static final String NOT_SPECIFIED_URI = "-";
    protected final AlgorithmIdentifier algorithmIdentifier;
    protected final String algorithmName;
    protected final String algorithmURI;

    public final String getAlgorithmName() {
        return this.algorithmName;
    }

    public String getAlgorithmURI() {
        return this.algorithmURI;
    }

    public final AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    CardExecutionParameterSpec(String algorithmName, String algorithmURI) throws IllegalArgumentException {
        this(algorithmName, NOT_SPECIFIED_IDENTIFIER, algorithmURI);
    }

    CardExecutionParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier) throws IllegalArgumentException {
        this(algorithmName, algorithmIdentifier, NOT_SPECIFIED_URI);
    }

    CardExecutionParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier, String algorithmURI) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(algorithmName, "name of algorithm");
        AssertUtil.notNull(algorithmIdentifier, "AlgorithmIdentifier");
        AssertUtil.notNull(algorithmURI, "AlgorithmURI");
        this.algorithmName = algorithmName;
        this.algorithmIdentifier = algorithmIdentifier;
        this.algorithmURI = algorithmURI;
    }

    @Override
    public final boolean isInitialized() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }
}

