/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.crypto;

import de.bos_bremen.basecard.common.crypto.CardExecutionParameterSpec;
import de.bos_bremen.basecard.common.crypto.XOAEPParameterSpec;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.crypto.AlgorithmIdentifierHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class CardExecutionDecryptRSAParameterSpec
extends CardExecutionParameterSpec {
    private static final Log LOG = LogFactory.getLog(CardExecutionDecryptRSAParameterSpec.class);
    private final byte[] paddingIndicator;
    private final byte[] algorithmID;

    public CardExecutionDecryptRSAParameterSpec(String algorithmName, String algorithmURI) throws IllegalArgumentException {
        this(algorithmName, NOT_SPECIFIED_IDENTIFIER, algorithmURI, null, null);
    }

    public CardExecutionDecryptRSAParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier) throws IllegalArgumentException {
        this(algorithmName, algorithmIdentifier, "-", null, null);
    }

    public CardExecutionDecryptRSAParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier, String algorithmURI) throws IllegalArgumentException {
        this(algorithmName, algorithmIdentifier, algorithmURI, null, null);
    }

    public CardExecutionDecryptRSAParameterSpec(String algorithmName, String algorithmURI, byte[] paddingIndicator) throws IllegalArgumentException {
        this(algorithmName, NOT_SPECIFIED_IDENTIFIER, algorithmURI, paddingIndicator, null);
    }

    public CardExecutionDecryptRSAParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier, byte[] paddingIndicator) throws IllegalArgumentException {
        this(algorithmName, algorithmIdentifier, "-", paddingIndicator, null);
    }

    public CardExecutionDecryptRSAParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier, String algorithmURI, byte[] paddingIndicator) throws IllegalArgumentException {
        this(algorithmName, algorithmIdentifier, algorithmURI, paddingIndicator, null);
    }

    public CardExecutionDecryptRSAParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier, byte[] paddingIndicator, byte[] algorithmID) throws IllegalArgumentException {
        this(algorithmName, algorithmIdentifier, "-", paddingIndicator, algorithmID);
    }

    public CardExecutionDecryptRSAParameterSpec(String algorithmName, String algorithmURI, byte[] paddingIndicator, byte[] algorithmID) throws IllegalArgumentException {
        this(algorithmName, NOT_SPECIFIED_IDENTIFIER, algorithmURI, paddingIndicator, algorithmID);
    }

    public CardExecutionDecryptRSAParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier, String algorithmURI, byte[] paddingIndicator, byte[] algorithmID) throws IllegalArgumentException {
        super(algorithmName, algorithmIdentifier, algorithmURI);
        this.paddingIndicator = ByteUtil.copy(paddingIndicator);
        this.algorithmID = algorithmID == null || algorithmID.length == 0 ? null : ByteUtil.copy(algorithmID);
    }

    public byte[] getPaddingIndicator() {
        return ByteUtil.copy(this.paddingIndicator);
    }

    public byte[] getAlgorithmID() {
        return ByteUtil.copy(this.algorithmID);
    }

    public boolean isOAEP() {
        return AlgorithmIdentifierHelper.isOAEPAlgorithmIdentifier(this.algorithmIdentifier);
    }

    public XOAEPParameterSpec getOAEPParameterSpec() {
        if (this.isOAEP()) {
            try {
                return new XOAEPParameterSpec(this.algorithmIdentifier);
            }
            catch (Exception e) {
                LOG.debug((Object)("failed to deliver OAEPParameterSpec: " + e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }
}

