/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.crypto;

import de.bos_bremen.basecard.common.crypto.CardExecutionParameterSpec;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class CardExecutionDecryptECParameterSpec
extends CardExecutionParameterSpec {
    private final String kdfName;
    private final byte[] algorithmID;

    public CardExecutionDecryptECParameterSpec(String algorithmName, String algorithmURI, String kdfName) throws IllegalArgumentException {
        this(algorithmName, NOT_SPECIFIED_IDENTIFIER, algorithmURI, kdfName);
    }

    public CardExecutionDecryptECParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier, String kdfName) throws IllegalArgumentException {
        this(algorithmName, algorithmIdentifier, "-", kdfName);
    }

    public CardExecutionDecryptECParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier, String algorithmURI, String kdfName) throws IllegalArgumentException {
        this(algorithmName, algorithmIdentifier, algorithmURI, kdfName, null);
    }

    public CardExecutionDecryptECParameterSpec(String algorithmName, AlgorithmIdentifier algorithmIdentifier, String algorithmURI, String kdfName, byte[] algorithmID) throws IllegalArgumentException {
        super(algorithmName, algorithmIdentifier, algorithmURI);
        AssertUtil.notNullOrEmpty(kdfName, "key derivation function name");
        this.kdfName = kdfName;
        this.algorithmID = algorithmID == null || algorithmID.length == 0 ? null : ByteUtil.copy(algorithmID);
    }

    public String getKDFName() {
        return this.kdfName;
    }

    public byte[] getAlgorithmID() {
        return ByteUtil.copy(this.algorithmID);
    }
}

