/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.crypto;

import de.bos_bremen.basecard.common.crypto.AbstractProviderUsageRelated;
import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionParameterSpec;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.common.AssertUtil;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public final class BaseAlgorithmProvider<T extends PrivateKey>
extends AbstractProviderUsageRelated
implements AlgorithmProvider<T> {
    public static final int INDEX_RECOMMENDED_ALGORITHM = 0;
    private final List<Algorithm<T, ?>> listAlgorithms;

    public BaseAlgorithmProvider(List<UsageRelated.Usage> listUsages, String providerName) throws IllegalArgumentException, NoSuchProviderException {
        super(providerName, listUsages);
        this.listAlgorithms = Collections.unmodifiableList(new ArrayList());
    }

    public BaseAlgorithmProvider(String providerName, List<Algorithm<T, ?>> listAlgorithms) throws IllegalArgumentException, NoSuchProviderException {
        super(providerName, BaseAlgorithmProvider.collectUsages(listAlgorithms));
        AssertUtil.notNullOrEmptyOrContainsNull(listAlgorithms, "list of algorithms");
        for (Algorithm algorithm : listAlgorithms) {
            if (providerName.equals(algorithm.getRelatedProviderName())) continue;
            throw new IllegalArgumentException("inconsistent provider name defined for algorithm provider " + providerName + " and at last one algorithm " + algorithm.getRelatedProviderName() + " (" + algorithm.getAlgorithmName() + ")");
        }
        this.listAlgorithms = Collections.unmodifiableList(new ArrayList(listAlgorithms));
    }

    private static <S extends PrivateKey> List<UsageRelated.Usage> collectUsages(List<Algorithm<S, ?>> listAlgorithms) {
        ArrayList<UsageRelated.Usage> result = new ArrayList<UsageRelated.Usage>();
        if (listAlgorithms != null) {
            for (Algorithm<S, ?> algorithm : listAlgorithms) {
                if (algorithm == null) continue;
                for (UsageRelated.Usage usage : algorithm.getUsageList()) {
                    if (result.contains((Object)usage)) continue;
                    result.add(usage);
                }
            }
        }
        return result;
    }

    @Override
    public List<Algorithm<T, ?>> getAlgorithms() {
        return this.listAlgorithms;
    }

    @Override
    public List<Algorithm<T, ?>> getAlgorithms(UsageRelated.Usage usage) throws IllegalArgumentException {
        AssertUtil.notNull((Object)usage, "usage");
        ArrayList result = new ArrayList();
        for (Algorithm<T, ?> algorithm : this.listAlgorithms) {
            if (!algorithm.getUsageList().contains((Object)usage)) continue;
            result.add(algorithm);
        }
        return result;
    }

    @Override
    public <S extends CardExecutionParameterSpec> Algorithm<T, S> getRecommendedAlgorithm(UsageRelated.Usage usage, Class<S> specClass) throws IllegalArgumentException {
        Algorithm<T, ?> result = this.getRecommendedAlgorithm(usage);
        AssertUtil.notNull(specClass, "CardExecutionParameterSpec class");
        if (result == null) {
            return null;
        }
        if (specClass.isInstance(result.getAlgorithmParameterSpec())) {
            return result;
        }
        return null;
    }

    @Override
    public Algorithm<T, ?> getRecommendedAlgorithm(UsageRelated.Usage usage) throws IllegalArgumentException {
        List<Algorithm<T, ?>> listUsageAlgorithms = this.getAlgorithms(usage);
        return listUsageAlgorithms.isEmpty() ? null : listUsageAlgorithms.get(0);
    }

    @Override
    public Algorithm<T, ?> getAlgorithm(UsageRelated.Usage usage, String algorithmName) throws IllegalArgumentException {
        List<Algorithm<T, ?>> listUsageAlgorithms = this.getAlgorithms(usage);
        for (Algorithm<T, ?> algorithm : listUsageAlgorithms) {
            if (!algorithm.getAlgorithmName().equals(algorithmName)) continue;
            return algorithm;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ":" + this.listAlgorithms.toString().replaceAll(Pattern.quote("["), "\n    ").replaceAll(Pattern.quote("]"), "").replaceAll(", ", "\n    ") + ")";
    }
}

