/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.crypto;

import de.bos_bremen.basecard.common.crypto.AbstractProviderUsageRelated;
import de.bos_bremen.basecard.common.crypto.CardExecutionParameterSpec;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.common.AssertUtil;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.util.List;

public class Algorithm<T extends PrivateKey, S extends CardExecutionParameterSpec>
extends AbstractProviderUsageRelated {
    private final S cardExecutionParameterSpec;
    private final String algorithmName;
    private final String alternativeAlgorithmName;

    public Algorithm(String providerName, List<UsageRelated.Usage> listUsages, String algorithmName, S cardExecutionParameterSpec) throws IllegalArgumentException, NoSuchProviderException {
        this(providerName, listUsages, algorithmName, algorithmName, cardExecutionParameterSpec);
    }

    public Algorithm(String providerName, List<UsageRelated.Usage> listUsages, String algorithmName, String alternativeAlgorithmName, S cardExecutionParameterSpec) throws IllegalArgumentException, NoSuchProviderException {
        super(providerName, listUsages);
        AssertUtil.notNullOrEmpty(algorithmName, "algorithm name");
        AssertUtil.notNullOrEmptyOrContainsNull(listUsages, "list of usages");
        AssertUtil.notNull(cardExecutionParameterSpec, "CardExecutionParameterSpec");
        AssertUtil.equals(algorithmName, ((CardExecutionParameterSpec)cardExecutionParameterSpec).getAlgorithmName(), "algorithm name of algorithm and spec");
        this.algorithmName = algorithmName;
        this.alternativeAlgorithmName = alternativeAlgorithmName;
        this.cardExecutionParameterSpec = cardExecutionParameterSpec;
    }

    public String getAlternativeAlgorithmName() {
        return this.alternativeAlgorithmName;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public S getAlgorithmParameterSpec() {
        return this.cardExecutionParameterSpec;
    }

    public String getName() {
        if (this.alternativeAlgorithmName != null && !this.alternativeAlgorithmName.isEmpty()) {
            return this.alternativeAlgorithmName;
        }
        return this.algorithmName;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.algorithmName + "/" + this.alternativeAlgorithmName + " - @" + Integer.toHexString(this.hashCode()) + ")";
    }
}

