/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.common.crypto;

import de.bos_bremen.basecard.common.crypto.ProviderRelated;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.common.AssertUtil;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractProviderUsageRelated
implements ProviderRelated,
UsageRelated {
    protected final List<UsageRelated.Usage> listUsages;
    protected final String providerName;

    protected AbstractProviderUsageRelated(String providerName, List<UsageRelated.Usage> listUsages) throws IllegalArgumentException, NoSuchProviderException {
        AssertUtil.notNullOrEmpty(providerName, "name of provider");
        if (Security.getProvider(providerName) == null) {
            throw new NoSuchProviderException("provider not registered: " + providerName);
        }
        AssertUtil.notNullOrEmptyOrContainsNull(listUsages, "usages");
        this.providerName = providerName;
        this.listUsages = Collections.unmodifiableList(new ArrayList<UsageRelated.Usage>(listUsages));
    }

    @Override
    public final String getRelatedProviderName() {
        return this.providerName;
    }

    @Override
    public final List<UsageRelated.Usage> getUsageList() {
        return this.listUsages;
    }

    @Override
    public final boolean isDecryptionRelated() {
        return this.listUsages.contains((Object)UsageRelated.Usage.CIPHER);
    }

    @Override
    public final boolean isSignatureRelated() {
        return this.listUsages.contains((Object)UsageRelated.Usage.SIGNATURE);
    }

    @Override
    public final boolean isAuthenticationRelated() {
        return this.listUsages.contains((Object)UsageRelated.Usage.AUTHENTICATION);
    }

    @Override
    public final boolean isKeyAgreementRelated() {
        return this.listUsages.contains((Object)UsageRelated.Usage.KEYAGREEMENT);
    }
}

