/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.codes.impl;

import de.bos_bremen.basecard.codes.ResponseCodeSearcher;
import de.bos_bremen.basecard.codes.xml.ChoiceResponseCodes;
import de.bos_bremen.basecard.codes.xml.GroupResponseCodes;
import de.bos_bremen.basecard.codes.xml.GroupsResponseCodes;
import de.bos_bremen.basecard.codes.xml.ObjectFactory;
import de.bos_bremen.basecard.codes.xml.ResponseCode;
import de.bos_bremen.basecard.codes.xml.ResponseCodeCode;
import de.bos_bremen.basecard.codes.xml.ResponseCodeRaw;
import de.bos_bremen.basecard.codes.xml.ResponseCodeTypes;
import de.bos_bremen.basecard.codes.xml.ResponseCodes;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;

public class ResponseCodeSearcherImpl
implements ResponseCodeSearcher {
    private ResponseCodeTypes responseCodeTypes = null;
    private static final boolean DEFAULT_MATCH = false;

    public ResponseCodeSearcherImpl() {
        this((ResponseCodeTypes)null);
    }

    public ResponseCodeSearcherImpl(ResponseCodeTypes responseCodeTypes) throws IllegalArgumentException {
        ResponseCodeSearcherImpl.checkTypes(responseCodeTypes);
        this.responseCodeTypes = responseCodeTypes;
    }

    public ResponseCodeSearcherImpl(ResponseCodeRaw responseCode) throws IllegalArgumentException {
        this(ResponseCodeSearcherImpl.createTypes(responseCode));
    }

    public static ResponseCodeTypes createTypes(ResponseCodeRaw responseCode) {
        ObjectFactory of = new ObjectFactory();
        ResponseCodeTypes types = of.createResponseCodeTypes();
        types.getType().add(responseCode);
        return types;
    }

    private static void checkTypes(ResponseCodeTypes responseCodeTypes) throws IllegalArgumentException {
        if (responseCodeTypes != null) {
            if (responseCodeTypes.getType() == null || responseCodeTypes.getType().isEmpty()) {
                throw new IllegalArgumentException("types with at least one type expected");
            }
            if (responseCodeTypes.getType().contains(null)) {
                throw new IllegalArgumentException("types must not contain null entries");
            }
            Iterator<ResponseCodeRaw> iterator = responseCodeTypes.getType().iterator();
            if (iterator.hasNext()) {
                ResponseCodeRaw cr = iterator.next();
                if (cr.getQuality() == null && cr.getCode() == null) {
                    throw new IllegalArgumentException("code must be not null");
                }
                if (cr.getQuality() != null && cr.getCode() == null) {
                    return;
                }
                ResponseCodeCode c = cr.getCode();
                byte[] code = c.getCode();
                byte[] mask = c.getMask();
                byte[] min = c.getMin();
                byte[] max = c.getMax();
                if (code != null && code.length != 2) {
                    throw new IllegalArgumentException("illegal code: must be 2 bytes");
                }
                if (mask != null && mask.length != 2) {
                    throw new IllegalArgumentException("illegal mask: must be 2 bytes");
                }
                if (min != null && min.length != 2) {
                    throw new IllegalArgumentException("illegal minimum code: must be 2 bytes");
                }
                if (max != null && max.length != 2) {
                    throw new IllegalArgumentException("illegal maximum code: must be 2 bytes");
                }
                if (code != null && min == null && max == null) {
                    return;
                }
                if (min != null && max != null && code == null) {
                    return;
                }
                throw new IllegalArgumentException("illegal code used, use 'code' or 'min and max', using mask is optional");
            }
        }
    }

    @Override
    public ResponseCodeTypes getResponseCodeTypes() {
        return this.responseCodeTypes;
    }

    @Override
    public boolean matches(GroupsResponseCodes groupsResponseCodes) {
        if (this.responseCodeTypes == null) {
            return true;
        }
        boolean result = false;
        if (groupsResponseCodes != null) {
            GroupResponseCodes groupResponseCodes;
            Iterator<GroupResponseCodes> iterator = groupsResponseCodes.getGroup().iterator();
            while (iterator.hasNext() && !(result = this.matches(groupResponseCodes = iterator.next()))) {
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(GroupResponseCodes groupResponseCodes) {
        if (this.responseCodeTypes == null) {
            return true;
        }
        boolean result = false;
        if (groupResponseCodes != null) {
            if (groupResponseCodes.getType() == null && groupResponseCodes.getTypes() == null) {
                result = this.matches(groupResponseCodes.getResponseCodes());
            } else if (groupResponseCodes.getType() != null) {
                result = this.matches(groupResponseCodes.getType());
            } else if (groupResponseCodes.getTypes() != null) {
                result = this.matches(groupResponseCodes.getTypes());
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(ResponseCodes responseCodes) {
        if (this.responseCodeTypes == null) {
            return true;
        }
        boolean result = false;
        if (responseCodes != null && responseCodes.getResponseCode() != null && !responseCodes.getResponseCode().isEmpty()) {
            for (ResponseCode rc : responseCodes.getResponseCode()) {
                if (rc != null && (result = this.matches(rc))) break;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(ResponseCode responseCode) {
        if (this.responseCodeTypes == null) {
            return true;
        }
        boolean result = false;
        result = responseCode != null ? this.matches((ResponseCodeRaw)responseCode) : false;
        return result;
    }

    @Override
    public boolean matches(ChoiceResponseCodes responseCodes) {
        if (this.responseCodeTypes == null) {
            return true;
        }
        boolean result = false;
        if (responseCodes != null) {
            Object obj;
            if (responseCodes.getBase() != null && responseCodes.getBase().getRef() != null && responseCodes.getBase().getRef().size() == 1) {
                obj = responseCodes.getBase().getRef().get(0);
                boolean bl = result = GroupResponseCodes.class.isInstance(obj) && this.matches((GroupResponseCodes)obj);
            }
            if (!result) {
                Iterator<Object> iterator;
                if (responseCodes.getResponseCode() != null && responseCodes.getResponseCode().getRef() != null && responseCodes.getResponseCode().getRef().size() == 1) {
                    obj = responseCodes.getResponseCode().getRef().get(0);
                    result = ResponseCode.class.isInstance(obj) && this.matches((ResponseCode)obj);
                } else if (responseCodes.getGroupRef() != null && responseCodes.getGroupRef().getRef() != null && responseCodes.getGroupRef().getRef().size() == 1) {
                    obj = responseCodes.getGroupRef().getRef().get(0);
                    result = GroupResponseCodes.class.isInstance(obj) && this.matches((GroupResponseCodes)obj);
                } else if (responseCodes.getGroupRefs() != null && responseCodes.getGroupRefs().getRefs() != null && !responseCodes.getGroupRefs().getRefs().isEmpty()) {
                    Object obj2;
                    iterator = responseCodes.getGroupRefs().getRefs().iterator();
                    while (iterator.hasNext() && !(result = GroupResponseCodes.class.isInstance(obj2 = iterator.next()) && this.matches((GroupResponseCodes)obj2))) {
                    }
                } else if (responseCodes.getRefs() != null && responseCodes.getRefs().getRefs() != null && !responseCodes.getRefs().getRefs().isEmpty()) {
                    Object obj3;
                    iterator = responseCodes.getRefs().getRefs().iterator();
                    while (iterator.hasNext() && !(result = ResponseCode.class.isInstance(obj3 = iterator.next()) && this.matches((ResponseCode)obj3))) {
                    }
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(ResponseCodeTypes types) {
        if (this.responseCodeTypes == null) {
            return true;
        }
        boolean result = false;
        if (types != null && types.getType() != null && !types.getType().isEmpty()) {
            ResponseCodeRaw rcr;
            Iterator<ResponseCodeRaw> iterator = types.getType().iterator();
            while (iterator.hasNext() && !(result = this.matches(rcr = iterator.next()))) {
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(ResponseCodeRaw type) {
        if (this.responseCodeTypes == null) {
            return true;
        }
        boolean result = false;
        if (type != null) {
            for (ResponseCodeRaw rcr : this.responseCodeTypes.getType()) {
                ResponseCodeCode t = type.getCode();
                if (t != null && (t.getCode() != null || t.getMin() != null)) {
                    boolean bl = result = !(rcr.getQuality() != null && rcr.getQuality() != type.getQuality() || rcr.getCode() != null && !this.match(type.getCode(), rcr.getCode()));
                }
                if (!result) continue;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(ResponseCodeCode type) {
        if (this.responseCodeTypes == null) {
            return true;
        }
        boolean result = false;
        if (type != null && (type.getCode() != null || type.getMin() != null)) {
            ResponseCodeRaw rcr;
            Iterator<ResponseCodeRaw> iterator = this.responseCodeTypes.getType().iterator();
            while (iterator.hasNext() && !(result = this.match(type, (rcr = iterator.next()).getCode()))) {
            }
        } else {
            result = false;
        }
        return result;
    }

    private boolean match(ResponseCodeCode xmlCode, ResponseCodeCode searchCode) {
        boolean result = false;
        if (xmlCode.getCode() != null && xmlCode.getMask() == null) {
            int xCodeValue = new BigInteger(1, xmlCode.getCode()).intValue();
            if (searchCode.getCode() != null) {
                result = Arrays.equals(xmlCode.getCode(), searchCode.getCode());
            } else if (searchCode.getMin() != null && searchCode.getMax() != null) {
                int sMin = new BigInteger(1, searchCode.getMin()).intValue();
                int sMax = new BigInteger(1, searchCode.getMax()).intValue();
                result = sMin <= xCodeValue && xCodeValue <= sMax;
            }
        } else if (xmlCode.getCode() != null && xmlCode.getMask() != null) {
            int xCodeValue = new BigInteger(1, xmlCode.getCode()).intValue();
            int xMask = new BigInteger(1, xmlCode.getMask()).intValue();
            if (searchCode.getCode() != null) {
                int sCodeValue = new BigInteger(1, searchCode.getCode()).intValue();
                result = (sCodeValue & xMask) == xCodeValue;
            } else if (searchCode.getMin() != null && searchCode.getMax() != null) {
                int sMin = new BigInteger(1, searchCode.getMin()).intValue();
                int sMax = new BigInteger(1, searchCode.getMax()).intValue();
                result = sMin <= xCodeValue && xCodeValue <= sMax;
            }
        } else if (xmlCode.getMin() != null && xmlCode.getMax() != null && xmlCode.getMask() == null) {
            int xMin = new BigInteger(1, xmlCode.getMin()).intValue();
            int xMax = new BigInteger(1, xmlCode.getMax()).intValue();
            if (searchCode.getCode() != null) {
                int sCodeValue = new BigInteger(1, searchCode.getCode()).intValue();
                result = xMin <= sCodeValue && sCodeValue <= xMax;
            } else if (searchCode.getMin() != null && searchCode.getMax() != null) {
                int sMin = new BigInteger(1, searchCode.getMin()).intValue();
                int sMax = new BigInteger(1, searchCode.getMax()).intValue();
                result = sMin <= xMin && xMin <= sMax || sMin <= xMax && xMax <= sMax;
            }
        } else if (xmlCode.getMin() != null && xmlCode.getMax() != null && xmlCode.getMask() != null) {
            int xMin = new BigInteger(1, xmlCode.getMin()).intValue();
            int xMax = new BigInteger(1, xmlCode.getMax()).intValue();
            int xMask = new BigInteger(1, xmlCode.getMask()).intValue();
            if (searchCode.getCode() != null) {
                int sCodeValue = new BigInteger(1, searchCode.getCode()).intValue();
                result = xMin <= (sCodeValue &= xMask) && sCodeValue <= xMax;
            } else if (searchCode.getMin() != null && searchCode.getMax() != null) {
                int sMin = new BigInteger(1, searchCode.getMin()).intValue();
                int sMax = new BigInteger(1, searchCode.getMax()).intValue();
                result = (sMin &= xMask) <= xMin && xMin <= (sMax &= xMask) || sMin <= xMax && xMax <= sMax;
            }
        }
        return result;
    }
}

