/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.codes.impl;

import de.bos_bremen.basecard.Command;
import de.bos_bremen.basecard.Response;
import de.bos_bremen.basecard.ResponseException;
import de.bos_bremen.basecard.codes.CommandResponseCodeManager;
import de.bos_bremen.basecard.codes.DiscreteSearcher;
import de.bos_bremen.basecard.codes.ExceptionMapper;
import de.bos_bremen.basecard.codes.impl.CommandSearcherImpl;
import de.bos_bremen.basecard.codes.impl.ContextSearcherImpl;
import de.bos_bremen.basecard.codes.impl.DiscreteSearcherImpl;
import de.bos_bremen.basecard.codes.impl.ResponseCodeSearcherImpl;
import de.bos_bremen.basecard.codes.mapping.MappingException;
import de.bos_bremen.basecard.codes.mapping.MappingsExceptions;
import de.bos_bremen.basecard.codes.xml.CommandHeader;
import de.bos_bremen.basecard.codes.xml.CommandRaw;
import de.bos_bremen.basecard.codes.xml.Message;
import de.bos_bremen.basecard.codes.xml.ObjectFactory;
import de.bos_bremen.basecard.codes.xml.ResponseCode;
import de.bos_bremen.basecard.codes.xml.ResponseCodeCode;
import de.bos_bremen.basecard.codes.xml.ResponseCodeQuality;
import de.bos_bremen.basecard.codes.xml.ResponseCodeRaw;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExceptionMapperImpl<X extends ResponseException>
implements ExceptionMapper<X> {
    private static final Logger LOG = Logger.getLogger(ExceptionMapperImpl.class);
    private String context = null;
    private String baseExceptionClassname = null;
    protected Class<X> baseExceptionClass = null;
    protected Constructor<X> baseExceptionConstructor = null;
    protected MappingsExceptions mappingExceptions = null;
    protected CommandResponseCodeManager manager = null;
    protected static final List<Class> CONSTRUCTOR_ARGUMENTS_CLASSES_LIST = Collections.unmodifiableList(Arrays.asList(String.class, Response.class));

    public ExceptionMapperImpl(URL mappingExceptionsCommandResponseCodesURL, Class<X> baseExceptionClass, CommandResponseCodeManager manager) throws IllegalArgumentException, IOException {
        if (mappingExceptionsCommandResponseCodesURL == null) {
            throw new IllegalArgumentException("URL not permitted as null");
        }
        if (baseExceptionClass == null) {
            throw new IllegalArgumentException("base exception class not permitted as null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("manager not permitted as null");
        }
        Constructor<X> c = null;
        try {
            c = baseExceptionClass.getConstructor(CONSTRUCTOR_ARGUMENTS_CLASSES_LIST.toArray(new Class[0]));
            if (c == null) {
                throw new IllegalArgumentException("base exception class not permitted: constructor with message and response not found");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("base exception class not permitted: constructor with message and response not accessible or found");
        }
        try {
            c.newInstance(null, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("base exception class not instantiable: ", e);
        }
        this.baseExceptionConstructor = c;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{MappingsExceptions.class});
            Unmarshaller u = jc.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(XSD_URL);
            u.setSchema(schema);
            InputSource xmlSource = new InputSource(mappingExceptionsCommandResponseCodesURL.openStream());
            this.mappingExceptions = (MappingsExceptions)u.unmarshal(xmlSource);
            if (!this.mappingExceptions.getBaseExceptionClassname().equals(baseExceptionClass.getName())) {
                throw new IOException("base exception class and name of class at configuration file does not match: " + baseExceptionClass.getName() + " <> " + this.mappingExceptions.getBaseExceptionClassname() + " (XML)");
            }
            this.context = this.mappingExceptions.getContext();
            this.baseExceptionClassname = this.mappingExceptions.getBaseExceptionClassname();
            this.baseExceptionClass = baseExceptionClass;
            this.manager = manager;
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw e;
        }
    }

    @Override
    public final String getContext() {
        return this.context;
    }

    @Override
    public final String getBaseExceptionClassname() {
        return this.baseExceptionClassname;
    }

    @Override
    public final Class<X> getExceptionClass() {
        return this.baseExceptionClass;
    }

    @Override
    public final void checkExecution(Command command, Response response) throws X, IllegalArgumentException {
        DiscreteSearcher d = this.createSearcher(command, response);
        ResponseCode r = null;
        try {
            r = this.manager.getResponseCode(d);
            if (r == null) {
                d = this.createSearcher(null, response);
                r = this.manager.getResponseCode(d);
                if (r == null) {
                    return;
                }
                byte[] h = new byte[4];
                System.arraycopy(command.getBytes(), 0, h, 0, h.length);
                ((de.bos_bremen.basecard.codes.xml.Command)de.bos_bremen.basecard.codes.xml.Command.class.cast(r.getCommands().getCommand().getRef().get(0))).getHeader().setHeader(h);
            }
            response.setResponseCode(r);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.checkExecution(response);
    }

    @Override
    public final DiscreteSearcher createSearcher(Command command, Response response) {
        ContextSearcherImpl ctx = new ContextSearcherImpl(this.context);
        CommandSearcherImpl c = null;
        if (command == null) {
            c = new CommandSearcherImpl();
        } else {
            byte[] cb = command.getBytes();
            byte[] header = new byte[4];
            Arrays.fill(header, (byte)0);
            System.arraycopy(cb, 0, header, 0, Math.min(4, cb.length));
            ObjectFactory of = new ObjectFactory();
            CommandRaw cr = of.createCommandRaw();
            CommandHeader h = of.createCommandHeader();
            h.setHeader(header);
            cr.setHeader(h);
            c = new CommandSearcherImpl(cr);
        }
        ResponseCodeSearcherImpl r = null;
        if (response == null) {
            r = new ResponseCodeSearcherImpl();
        } else {
            ObjectFactory of = new ObjectFactory();
            ResponseCodeRaw rr = of.createResponseCodeRaw();
            ResponseCodeCode rc = of.createResponseCodeCode();
            rc.setCode(response.getCode());
            rr.setCode(rc);
            r = new ResponseCodeSearcherImpl(rr);
        }
        DiscreteSearcherImpl result = new DiscreteSearcherImpl(ctx, c, r);
        return result;
    }

    @Override
    public final CommandResponseCodeManager getCommandResponseCodeManager() {
        return this.manager;
    }

    @Override
    public void checkExecution(Response response) throws X, IllegalArgumentException {
        ResponseCode responseCode = response.getResponseCode();
        if (responseCode != null && responseCode.getQuality() != null && responseCode.getQuality() != ResponseCodeQuality.SUCCESS) {
            Object oc = responseCode.getCommands().getCommand().getRef().get(0);
            de.bos_bremen.basecard.codes.xml.Command c = null;
            if (oc != null) {
                c = (de.bos_bremen.basecard.codes.xml.Command)de.bos_bremen.basecard.codes.xml.Command.class.cast(oc);
            }
            Message m = (Message)Message.class.cast(responseCode.getMessage().getRef().get(0));
            String message = m.getValue();
            if (c == null || c.getId() == null) {
                throw this.createDefaultException(message, response);
            }
            String rid = responseCode.getId();
            String mid = m.getId();
            String cid = c.getId();
            for (MappingException me : this.mappingExceptions.getMappingException()) {
                if (!me.getResponseCode().equals(rid) || !me.getCommand().equals(cid) || !me.getMessage().equals(mid)) continue;
                try {
                    Class<?> clazz = Class.forName(me.getExceptionClassname());
                    if (clazz == null || !this.baseExceptionClass.isAssignableFrom(clazz)) continue;
                    Class<?> xc = clazz;
                    Constructor<?> cx = xc.getConstructor(CONSTRUCTOR_ARGUMENTS_CLASSES_LIST.toArray(new Class[0]));
                    ResponseException x = (ResponseException)cx.newInstance(message, response);
                    throw x;
                }
                catch (ClassNotFoundException e) {
                    LOG.debug((Object)"exception class not found", (Throwable)e);
                }
                catch (SecurityException e) {
                    LOG.debug((Object)"use of exception class denied by SecurityManager", (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    LOG.debug((Object)"constructor exception class not found", (Throwable)e);
                }
                catch (InstantiationException e) {
                    LOG.debug((Object)"instantiation of exception failed", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOG.debug((Object)"instantiation of exception failed caused by not visible constructor", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LOG.debug((Object)"instantiation of exception failed using reflection", (Throwable)e);
                }
            }
            throw this.createDefaultException(message, response);
        }
    }

    private X createDefaultException(String message, Response response) {
        ResponseException result = null;
        try {
            result = (ResponseException)this.baseExceptionConstructor.newInstance(message, response);
        }
        catch (Exception e) {
            LOG.debug((Object)"instantiation failed", (Throwable)e);
        }
        return (X)result;
    }
}

