/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.codes.impl;

import de.bos_bremen.basecard.codes.CommandSearcher;
import de.bos_bremen.basecard.codes.xml.ChoiceCommands;
import de.bos_bremen.basecard.codes.xml.Command;
import de.bos_bremen.basecard.codes.xml.CommandHeader;
import de.bos_bremen.basecard.codes.xml.CommandQuality;
import de.bos_bremen.basecard.codes.xml.CommandRaw;
import de.bos_bremen.basecard.codes.xml.CommandTypes;
import de.bos_bremen.basecard.codes.xml.Commands;
import de.bos_bremen.basecard.codes.xml.GroupCommands;
import de.bos_bremen.basecard.codes.xml.GroupsCommands;
import de.bos_bremen.basecard.codes.xml.ObjectFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class CommandSearcherImpl
implements CommandSearcher {
    private CommandTypes commandTypes = null;
    private static final boolean DEFAULT_MATCH = false;

    public CommandSearcherImpl() {
        this((CommandTypes)null);
    }

    public CommandSearcherImpl(CommandTypes commandTypes) throws IllegalArgumentException {
        CommandSearcherImpl.checkTypes(commandTypes);
        this.commandTypes = commandTypes;
    }

    public CommandSearcherImpl(CommandRaw command) throws IllegalArgumentException {
        this(CommandSearcherImpl.createTypes(command));
    }

    public static CommandTypes createTypes(CommandRaw command) {
        ObjectFactory of = new ObjectFactory();
        CommandTypes types = of.createCommandTypes();
        types.getType().add(command);
        return types;
    }

    private static void checkTypes(CommandTypes commandTypes) throws IllegalArgumentException {
        if (commandTypes != null) {
            if (commandTypes.getType() == null || commandTypes.getType().isEmpty()) {
                throw new IllegalArgumentException("types with at least one type expected");
            }
            if (commandTypes.getType().contains(null)) {
                throw new IllegalArgumentException("types must not contain null entries");
            }
            Iterator<CommandRaw> iterator = commandTypes.getType().iterator();
            if (iterator.hasNext()) {
                CommandRaw cr = iterator.next();
                if ((cr.getQuality() == null || cr.getQuality().isEmpty()) && cr.getHeader() == null) {
                    throw new IllegalArgumentException("header must be not null");
                }
                if (cr.getQuality() != null && !cr.getQuality().isEmpty() && cr.getHeader() == null) {
                    return;
                }
                CommandHeader ch = cr.getHeader();
                byte[] header = ch.getHeader();
                byte[] mask = ch.getMask();
                byte[] min = ch.getMin();
                byte[] max = ch.getMax();
                if (header != null && header.length != 4) {
                    throw new IllegalArgumentException("illegal header: must be 4 bytes");
                }
                if (mask != null && mask.length != 4) {
                    throw new IllegalArgumentException("illegal mask: must be 4 bytes");
                }
                if (min != null && min.length != 4) {
                    throw new IllegalArgumentException("illegal minimum header: must be 4 bytes");
                }
                if (max != null && max.length != 4) {
                    throw new IllegalArgumentException("illegal maximum header: must be 4 bytes");
                }
                if (header != null && min == null && max == null) {
                    return;
                }
                if (min != null && max != null && header == null) {
                    return;
                }
                throw new IllegalArgumentException("illegal header used, use 'header' or 'minHeader and maxHeader', using mask is optional");
            }
        }
    }

    @Override
    public CommandTypes getCommandTypes() {
        return this.commandTypes;
    }

    @Override
    public boolean matches(GroupsCommands groupsCommands) {
        if (this.commandTypes == null) {
            return true;
        }
        boolean result = false;
        if (groupsCommands != null) {
            GroupCommands groupCommands;
            Iterator<GroupCommands> iterator = groupsCommands.getGroup().iterator();
            while (iterator.hasNext() && !(result = this.matches(groupCommands = iterator.next()))) {
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(GroupCommands groupCommand) {
        if (this.commandTypes == null) {
            return true;
        }
        boolean result = false;
        if (groupCommand != null && this.commandTypes != null) {
            if (groupCommand.getType() == null && groupCommand.getTypes() == null) {
                result = this.matches(groupCommand.getCommands());
            } else if (groupCommand.getType() != null) {
                result = this.matches(groupCommand.getType());
            } else if (groupCommand.getTypes() != null) {
                result = this.matches(groupCommand.getTypes());
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(Commands commands) {
        if (this.commandTypes == null) {
            return true;
        }
        boolean result = false;
        if (commands != null && commands.getCommand() != null && !commands.getCommand().isEmpty()) {
            for (Command c : commands.getCommand()) {
                if (c != null && (result = this.matches(c))) break;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(Command command) {
        if (this.commandTypes == null) {
            return true;
        }
        boolean result = false;
        result = command != null ? this.matches((CommandRaw)command) : false;
        return result;
    }

    @Override
    public boolean matches(ChoiceCommands commands) {
        if (this.commandTypes == null) {
            return true;
        }
        boolean result = false;
        if (commands != null) {
            Object obj;
            if (commands.getBase() != null && commands.getBase().getRef() != null && commands.getBase().getRef().size() == 1) {
                obj = commands.getBase().getRef().get(0);
                boolean bl = result = GroupCommands.class.isInstance(obj) && this.matches((GroupCommands)obj);
            }
            if (!result) {
                Iterator<Object> iterator;
                if (commands.getCommand() != null && commands.getCommand().getRef() != null && commands.getCommand().getRef().size() == 1) {
                    obj = commands.getCommand().getRef().get(0);
                    result = Command.class.isInstance(obj) && this.matches((Command)obj);
                } else if (commands.getGroupRef() != null && commands.getGroupRef().getRef() != null && commands.getGroupRef().getRef().size() == 1) {
                    obj = commands.getGroupRef().getRef().get(0);
                    result = GroupCommands.class.isInstance(obj) && this.matches((GroupCommands)obj);
                } else if (commands.getGroupRefs() != null && commands.getGroupRefs().getRefs() != null && !commands.getGroupRefs().getRefs().isEmpty()) {
                    Object obj2;
                    iterator = commands.getGroupRefs().getRefs().iterator();
                    while (iterator.hasNext() && !(result = GroupCommands.class.isInstance(obj2 = iterator.next()) && this.matches((GroupCommands)obj2))) {
                    }
                } else if (commands.getRefs() != null && commands.getRefs().getRefs() != null && !commands.getRefs().getRefs().isEmpty()) {
                    Object obj3;
                    iterator = commands.getRefs().getRefs().iterator();
                    while (iterator.hasNext() && !(result = Command.class.isInstance(obj3 = iterator.next()) && this.matches((Command)obj3))) {
                    }
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(CommandTypes types) {
        if (this.commandTypes == null) {
            return true;
        }
        boolean result = false;
        if (types != null && types.getType() != null && !types.getType().isEmpty()) {
            CommandRaw cr;
            Iterator<CommandRaw> iterator = types.getType().iterator();
            while (iterator.hasNext() && !(result = this.matches(cr = iterator.next()))) {
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(CommandRaw type) {
        if (this.commandTypes == null) {
            return true;
        }
        boolean result = false;
        if (type != null && type.getHeader() != null) {
            CommandHeader h = type.getHeader();
            result = this.matches(h);
            for (CommandRaw cr : this.commandTypes.getType()) {
                if (h != null && (h.getHeader() != null || h.getMin() != null)) {
                    boolean quality;
                    ArrayList<CommandQuality> qualityList = new ArrayList<CommandQuality>(cr.getQuality());
                    boolean bl = quality = cr.getQuality() == null || cr.getQuality().isEmpty();
                    if (!quality && type.getQuality() != null && !type.getQuality().isEmpty()) {
                        int s = qualityList.size();
                        qualityList.removeAll(type.getQuality());
                        quality = s != qualityList.size();
                    }
                    boolean bl2 = result = quality && (cr.getHeader() == null || this.match(h, cr.getHeader()));
                }
                if (!result) continue;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(CommandHeader header) {
        if (this.commandTypes == null) {
            return true;
        }
        boolean result = false;
        if (header != null && (header.getHeader() != null || header.getMin() != null)) {
            CommandRaw cr;
            Iterator<CommandRaw> iterator = this.commandTypes.getType().iterator();
            while (iterator.hasNext() && !(result = this.match(header, (cr = iterator.next()).getHeader()))) {
            }
        } else {
            result = false;
        }
        return result;
    }

    private boolean match(CommandHeader xmlHeader, CommandHeader searchHeader) {
        boolean result = false;
        if (xmlHeader.getHeader() != null && xmlHeader.getMask() == null) {
            int xHeaderValue = new BigInteger(1, xmlHeader.getHeader()).intValue();
            if (searchHeader.getHeader() != null) {
                result = Arrays.equals(xmlHeader.getHeader(), searchHeader.getHeader());
            } else if (searchHeader.getMin() != null && searchHeader.getMax() != null) {
                int sMin = new BigInteger(1, searchHeader.getMin()).intValue();
                int sMax = new BigInteger(1, searchHeader.getMax()).intValue();
                result = sMin <= xHeaderValue && xHeaderValue <= sMax;
            }
        } else if (xmlHeader.getHeader() != null && xmlHeader.getMask() != null) {
            int xHeaderValue = new BigInteger(1, xmlHeader.getHeader()).intValue();
            int xMask = new BigInteger(1, xmlHeader.getMask()).intValue();
            if (searchHeader.getHeader() != null) {
                int sHeaderValue = new BigInteger(1, searchHeader.getHeader()).intValue();
                result = (sHeaderValue & xMask) == xHeaderValue;
            } else if (searchHeader.getMin() != null && searchHeader.getMax() != null) {
                int sMin = new BigInteger(1, searchHeader.getMin()).intValue();
                int sMax = new BigInteger(1, searchHeader.getMax()).intValue();
                result = sMin <= xHeaderValue && xHeaderValue <= sMax;
            }
        } else if (xmlHeader.getMin() != null && xmlHeader.getMax() != null && xmlHeader.getMask() == null) {
            int xMin = new BigInteger(1, xmlHeader.getMin()).intValue();
            int xMax = new BigInteger(1, xmlHeader.getMax()).intValue();
            if (searchHeader.getHeader() != null) {
                int sHeaderValue = new BigInteger(1, searchHeader.getHeader()).intValue();
                result = xMin <= sHeaderValue && sHeaderValue <= xMax;
            } else if (searchHeader.getMin() != null && searchHeader.getMax() != null) {
                int sMin = new BigInteger(1, searchHeader.getMin()).intValue();
                int sMax = new BigInteger(1, searchHeader.getMax()).intValue();
                result = sMin <= xMin && xMin <= sMax || sMin <= xMax && xMax <= sMax;
            }
        } else if (xmlHeader.getMin() != null && xmlHeader.getMax() != null && xmlHeader.getMask() != null) {
            int xMin = new BigInteger(1, xmlHeader.getMin()).intValue();
            int xMax = new BigInteger(1, xmlHeader.getMax()).intValue();
            int xMask = new BigInteger(1, xmlHeader.getMask()).intValue();
            if (searchHeader.getHeader() != null) {
                int sHeaderValue = new BigInteger(1, searchHeader.getHeader()).intValue();
                result = xMin <= (sHeaderValue &= xMask) && sHeaderValue <= xMax;
            } else if (searchHeader.getMin() != null && searchHeader.getMax() != null) {
                int sMin = new BigInteger(1, searchHeader.getMin()).intValue();
                int sMax = new BigInteger(1, searchHeader.getMax()).intValue();
                result = (sMin &= xMask) <= xMin && xMin <= (sMax &= xMask) || sMin <= xMax && xMax <= sMax;
            }
        }
        return result;
    }
}

