/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.codes.impl;

import de.bos_bremen.basecard.codes.CommandResponseCodeManager;
import de.bos_bremen.basecard.codes.CommandSearcher;
import de.bos_bremen.basecard.codes.ContextSearcher;
import de.bos_bremen.basecard.codes.DiscreteSearcher;
import de.bos_bremen.basecard.codes.ResponseCodeSearcher;
import de.bos_bremen.basecard.codes.Searcher;
import de.bos_bremen.basecard.codes.impl.ContextSearcherImpl;
import de.bos_bremen.basecard.codes.impl.DiscreteSearcherImpl;
import de.bos_bremen.basecard.codes.xml.ChangedCommandMessage;
import de.bos_bremen.basecard.codes.xml.ChangedResponseCodeMessage;
import de.bos_bremen.basecard.codes.xml.ChoiceCommands;
import de.bos_bremen.basecard.codes.xml.ChoiceResponseCodes;
import de.bos_bremen.basecard.codes.xml.Command;
import de.bos_bremen.basecard.codes.xml.CommandHeader;
import de.bos_bremen.basecard.codes.xml.CommandRaw;
import de.bos_bremen.basecard.codes.xml.CommandResponseCodes;
import de.bos_bremen.basecard.codes.xml.Commands;
import de.bos_bremen.basecard.codes.xml.GroupCommands;
import de.bos_bremen.basecard.codes.xml.GroupResponseCodes;
import de.bos_bremen.basecard.codes.xml.GroupsCommands;
import de.bos_bremen.basecard.codes.xml.GroupsResponseCodes;
import de.bos_bremen.basecard.codes.xml.Message;
import de.bos_bremen.basecard.codes.xml.ObjectFactory;
import de.bos_bremen.basecard.codes.xml.RefCommand;
import de.bos_bremen.basecard.codes.xml.RefGroupCommands;
import de.bos_bremen.basecard.codes.xml.RefGroupResponseCodes;
import de.bos_bremen.basecard.codes.xml.RefMessage;
import de.bos_bremen.basecard.codes.xml.ResponseCode;
import de.bos_bremen.basecard.codes.xml.ResponseCodeCode;
import de.bos_bremen.basecard.codes.xml.ResponseCodeRaw;
import de.bos_bremen.basecard.codes.xml.ResponseCodes;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CommandResponseCodeManagerImpl
implements CommandResponseCodeManager {
    private static final Logger LOG = Logger.getLogger(CommandResponseCodeManagerImpl.class);
    private final String context;
    protected CommandResponseCodes commandResponseCodes = null;

    public CommandResponseCodeManagerImpl(URL commandResponseCodesURL) throws IllegalArgumentException, IOException {
        if (commandResponseCodesURL == null) {
            throw new IllegalArgumentException("URL not permitted as null");
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CommandResponseCodes.class});
            Unmarshaller u = jc.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(XSD_URL);
            u.setSchema(schema);
            InputSource xmlSource = new InputSource(commandResponseCodesURL.openStream());
            this.commandResponseCodes = (CommandResponseCodes)u.unmarshal(xmlSource);
            this.context = this.commandResponseCodes.getContext();
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public <T> Collection<T> findEntries(Class<T> searchResultClass, Searcher searcher) throws IllegalArgumentException {
        ArrayList result = new ArrayList();
        DiscreteSearcher ds = this.createDisreteSearcher(searcher);
        if (!SEARCH_RESULT_CLASS_LIST.contains(searchResultClass)) {
            throw new IllegalArgumentException("not supported result class");
        }
        if (ds.getContextSearcher() == null || ds.getContextSearcher().matches(this.context)) {
            if (ResponseCode.class.equals(searchResultClass)) {
                if (this.commandResponseCodes.getGroups() != null) {
                    this.findEntries(searchResultClass, result, ds, this.commandResponseCodes.getGroups().getGroupsResponseCodes());
                }
                if (this.commandResponseCodes.getElements() != null) {
                    this.findEntries(searchResultClass, result, ds, this.commandResponseCodes.getElements().getResponseCodes());
                }
            } else if (Command.class.equals(searchResultClass)) {
                if (this.commandResponseCodes.getGroups() != null) {
                    this.findEntries(searchResultClass, result, ds, this.commandResponseCodes.getGroups().getGroupsCommands());
                }
                if (this.commandResponseCodes.getElements() != null) {
                    this.findEntries(searchResultClass, result, ds, this.commandResponseCodes.getElements().getCommands());
                }
            }
        }
        return result;
    }

    @Override
    public ResponseCode getResponseCode(Searcher searcher) throws IllegalArgumentException, SAXException {
        ResponseCode r = null;
        Command c = null;
        DiscreteSearcher ds = this.createDisreteSearcher(searcher);
        Collection<ResponseCode> responseCodeCollection = this.findEntries(ResponseCode.class, searcher);
        if (responseCodeCollection != null && !responseCodeCollection.isEmpty() && responseCodeCollection.size() == 1) {
            r = responseCodeCollection.iterator().next();
            Collection<Command> commandCollection = this.findEntries(Command.class, searcher);
            if (commandCollection != null && !commandCollection.isEmpty() && commandCollection.size() == 1) {
                c = commandCollection.iterator().next();
            }
        }
        return this.makeCopy(r, c, ds);
    }

    private ResponseCode makeCopy(ResponseCode r, Command c, DiscreteSearcher ds) throws SAXException {
        ResponseCode result = null;
        if (r != null) {
            ObjectFactory of = new ObjectFactory();
            result = this.createBaseCopy(r, c, ds, of);
            this.copyMessages(r, c, result, of);
        }
        return result;
    }

    private String[] copyMessage1(ResponseCode r, Command c, ResponseCode result, ObjectFactory of) throws SAXException {
        List<ChangedResponseCodeMessage> lcrm;
        String[] messageMid = new String[]{null, null};
        if (r.getCommands() != null && r.getCommands().getChangedMessages() != null && r.getCommands().getChangedMessages().getChangedMessage() != null && !r.getCommands().getChangedMessages().getChangedMessage().isEmpty() && (lcrm = r.getCommands().getChangedMessages().getChangedMessage()) != null) {
            for (ChangedResponseCodeMessage crm : lcrm) {
                if (!this.check(c, crm)) continue;
                Message tmp = (Message)Message.class.cast(crm.getMessage().getRef().get(0));
                messageMid[0] = tmp.getValue();
                messageMid[1] = tmp.getId();
            }
        }
        return messageMid;
    }

    private String[] copyMessage2(ResponseCode r, Command c, ResponseCode result, ObjectFactory of) throws SAXException {
        List<ChangedCommandMessage> lccm;
        String[] messageMid = new String[]{null, null};
        if (c.getResponseCodes() != null && c.getResponseCodes().getChangedMessages() != null && c.getResponseCodes().getChangedMessages().getChangedMessage() != null && !c.getResponseCodes().getChangedMessages().getChangedMessage().isEmpty() && (lccm = c.getResponseCodes().getChangedMessages().getChangedMessage()) != null) {
            for (ChangedCommandMessage ccm : lccm) {
                if (!this.check(r, ccm)) continue;
                Message tmp = (Message)Message.class.cast(ccm.getMessage().getRef().get(0));
                messageMid[0] = tmp.getValue();
                messageMid[1] = tmp.getId();
            }
        }
        return messageMid;
    }

    private String[] checkGetMessage(String message1, String mid1, String message2, String mid2) throws SAXException {
        boolean m2NotNull;
        String[] messageMid = null;
        boolean m1Null = message1 == null && mid1 == null;
        boolean m2Null = message2 == null && mid2 == null;
        boolean m1NotNull = message1 != null && mid1 != null;
        boolean bl = m2NotNull = message2 != null && mid2 != null;
        if (m1NotNull && m2Null) {
            messageMid = new String[]{message1, mid1};
        } else if (m1Null && m2NotNull) {
            messageMid = new String[]{message2, mid2};
        } else if (m1Null && m2Null || message1 == null || mid1 == null) {
            LOG.debug((Object)"no more specific message found using global message");
            messageMid = new String[]{null, null};
        } else if (message1.equals(message2) && mid1.equals(mid2)) {
            messageMid = new String[]{message1, mid1};
        }
        this.checkMessagesValid(messageMid == null, message1, mid1, message2, mid2);
        return messageMid;
    }

    private void checkMessagesValid(boolean checkedRequired, String message1, String mid1, String message2, String mid2) throws SAXException {
        if (checkedRequired) {
            boolean mIDNotEquals;
            boolean messageNotEquals;
            boolean bl = messageNotEquals = !message1.equals(message2);
            if (messageNotEquals) {
                throw new SAXException("different specific changed messages for combination of command and response code found: '" + message1 + "' <> '" + message2);
            }
            boolean bl2 = mIDNotEquals = !mid1.equals(mid2);
            if (mIDNotEquals) {
                throw new SAXException("different specific changed message ids for combination of command and response code found: '" + mid1 + "' <> '" + mid2);
            }
        }
    }

    private void copyMessages(ResponseCode r, Command c, ResponseCode result, ObjectFactory of) throws SAXException {
        RefMessage rm = of.createRefMessage();
        Message m = this.createBaseMessageCopy(r, result, of, rm);
        if (c != null) {
            String[] messageMid1 = this.copyMessage1(r, c, result, of);
            String message1 = messageMid1[0];
            String mid1 = messageMid1[1];
            String[] messageMid2 = this.copyMessage2(r, c, result, of);
            String message2 = messageMid2[0];
            String mid2 = messageMid2[1];
            String[] messageMid = this.checkGetMessage(message1, mid1, message2, mid2);
            String message = messageMid[0];
            String mid = messageMid[1];
            if (message != null) {
                m.setValue(message);
            }
            if (mid != null) {
                m.setId(mid);
            }
        }
    }

    private Message createBaseMessageCopy(ResponseCode r, ResponseCode result, ObjectFactory of, RefMessage rm) {
        Message m = of.createMessage();
        result.setMessage(rm);
        rm.getRef().add(m);
        if (r.getMessage() != null && r.getMessage().getRef() != null && !r.getMessage().getRef().isEmpty() && r.getMessage().getRef().size() == 1 && Message.class.isInstance(r.getMessage().getRef().get(0))) {
            Message message = (Message)Message.class.cast(r.getMessage().getRef().get(0));
            m.setValue(message.getValue());
            m.setId(message.getId());
        }
        return m;
    }

    private ResponseCode createBaseCopy(ResponseCode r, Command c, DiscreteSearcher ds, ObjectFactory of) {
        ResponseCode result = of.createResponseCode();
        result.setName(r.getName());
        result.setDescription(r.getDescription());
        result.setId(r.getId());
        result.setQuality(r.getQuality());
        ResponseCodeCode rcc = of.createResponseCodeCode();
        ResponseCodeRaw rr = ds.getResponseCodeSearcher().getResponseCodeTypes().getType().get(0);
        rcc.setCode(rr.getCode().getCode());
        result.setCode(rcc);
        Command cmd = of.createCommand();
        if (c != null) {
            cmd.setId(c.getId());
        }
        this.copyHeader(cmd, ds, of);
        ChoiceCommands cc = of.createChoiceCommands();
        RefCommand cm = of.createRefCommand();
        cm.getRef().add(cmd);
        cc.setCommand(cm);
        result.setCommands(cc);
        return result;
    }

    private void copyHeader(Command cmd, DiscreteSearcher ds, ObjectFactory of) {
        CommandHeader h = of.createCommandHeader();
        if (ds.getCommandSearcher().getCommandTypes() == null) {
            h.setHeader(new byte[4]);
        } else {
            CommandRaw cr = ds.getCommandSearcher().getCommandTypes().getType().get(0);
            h.setHeader(cr.getHeader().getHeader());
        }
        cmd.setHeader(h);
    }

    private boolean check(ResponseCode r, ChangedCommandMessage ccm) {
        if (ccm.getResponseCode() == null || ccm.getResponseCode().getRef() == null || ccm.getResponseCode().getRef().isEmpty()) {
            return false;
        }
        if (ccm.getResponseCode().getRef().size() != 1 || ccm.getResponseCode().getRef().get(0) != r || ccm.getMessage() == null) {
            return false;
        }
        if (ccm.getMessage().getRef() == null || ccm.getMessage().getRef().isEmpty() || ccm.getMessage().getRef().size() != 1) {
            return false;
        }
        return Message.class.isInstance(ccm.getMessage().getRef().get(0));
    }

    private boolean check(Command c, ChangedResponseCodeMessage crm) {
        if (crm.getCommand() == null || crm.getCommand().getRef() == null || crm.getCommand().getRef().isEmpty()) {
            return false;
        }
        if (crm.getCommand().getRef().size() != 1 || crm.getCommand().getRef().get(0) != c || crm.getMessage() == null) {
            return false;
        }
        if (crm.getMessage().getRef() == null || crm.getMessage().getRef().isEmpty() || crm.getMessage().getRef().size() != 1) {
            return false;
        }
        return Message.class.isInstance(crm.getMessage().getRef().get(0));
    }

    @Override
    public final String getContext() {
        return this.context;
    }

    private DiscreteSearcher createDisreteSearcher(Searcher searcher) {
        DiscreteSearcher ds = null;
        if (DiscreteSearcher.class.isInstance(searcher)) {
            ds = (DiscreteSearcher)searcher;
        } else {
            ContextSearcher ctx = null;
            CommandSearcher c = null;
            ResponseCodeSearcher rc = null;
            ctx = ContextSearcher.class.isInstance(searcher) ? (ContextSearcher)searcher : new ContextSearcherImpl();
            if (CommandSearcher.class.isInstance(searcher)) {
                c = (CommandSearcher)searcher;
            }
            if (ResponseCodeSearcher.class.isInstance(searcher)) {
                rc = (ResponseCodeSearcher)searcher;
            }
            ds = new DiscreteSearcherImpl(ctx, c, rc);
        }
        return ds;
    }

    private <T> void findEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, ChoiceCommands cCommands) {
        if (cCommands != null) {
            this.findEntries(searchResultClass, resultList, ds, cCommands.getBase());
            if (cCommands.getCommand() == null) {
                if (this.findEntriesCommands1(searchResultClass, resultList, ds, cCommands)) {
                    return;
                }
                if (this.findEntriesCommands2(searchResultClass, resultList, ds, cCommands)) {
                    return;
                }
                this.findEntriesCommands3(searchResultClass, resultList, ds, cCommands);
            } else {
                Object obj = cCommands.getCommand().getRef().get(0);
                if (Command.class.isInstance(obj)) {
                    this.findEntries(searchResultClass, resultList, ds, (Command)obj);
                }
            }
        }
    }

    private <T> boolean findEntriesCommands3(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, ChoiceCommands cCommands) {
        boolean case3;
        boolean bl = case3 = cCommands.getRefs() != null && cCommands.getRefs().getRefs() != null && !cCommands.getRefs().getRefs().isEmpty();
        if (case3) {
            for (Object obj : cCommands.getRefs().getRefs()) {
                if (!Command.class.isInstance(obj)) continue;
                this.findEntries(searchResultClass, resultList, ds, (Command)obj);
            }
        }
        return case3;
    }

    private <T> boolean findEntriesCommands2(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, ChoiceCommands cCommands) {
        boolean case2;
        boolean bl = case2 = cCommands.getGroupRefs() != null && cCommands.getGroupRefs().getRefs() != null && !cCommands.getGroupRefs().getRefs().isEmpty();
        if (case2) {
            for (Object obj : cCommands.getGroupRefs().getRefs()) {
                if (!GroupCommands.class.isInstance(obj)) continue;
                this.findEntries(searchResultClass, resultList, ds, (GroupCommands)obj);
            }
        }
        return case2;
    }

    private <T> boolean findEntriesCommands1(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, ChoiceCommands cCommands) {
        Object obj;
        boolean case1;
        boolean bl = case1 = cCommands.getGroupRef() != null && cCommands.getGroupRef().getRef() != null && !cCommands.getGroupRef().getRef().isEmpty();
        if (case1 && GroupCommands.class.isInstance(obj = cCommands.getGroupRef().getRef().get(0))) {
            this.findEntries(searchResultClass, resultList, ds, (GroupCommands)obj);
        }
        return case1;
    }

    private <T> void findEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, ChoiceResponseCodes cResponseCodes) {
        if (cResponseCodes != null) {
            this.findEntries(searchResultClass, resultList, ds, cResponseCodes.getBase());
            if (cResponseCodes.getResponseCode() == null) {
                if (this.findEntriesResponses1(searchResultClass, resultList, ds, cResponseCodes)) {
                    return;
                }
                if (this.findEntriesResponses2(searchResultClass, resultList, ds, cResponseCodes)) {
                    return;
                }
                this.findEntriesResponses3(searchResultClass, resultList, ds, cResponseCodes);
            } else {
                Object obj = cResponseCodes.getResponseCode().getRef().get(0);
                if (ResponseCode.class.isInstance(obj)) {
                    this.findEntries(searchResultClass, resultList, ds, (ResponseCode)obj);
                }
            }
        }
    }

    protected <T> boolean findEntriesResponses3(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, ChoiceResponseCodes cResponseCodes) {
        boolean case3;
        boolean bl = case3 = cResponseCodes.getRefs() != null && cResponseCodes.getRefs().getRefs() != null && !cResponseCodes.getRefs().getRefs().isEmpty();
        if (case3) {
            for (Object obj : cResponseCodes.getRefs().getRefs()) {
                if (!ResponseCode.class.isInstance(obj)) continue;
                this.findEntries(searchResultClass, resultList, ds, (ResponseCode)obj);
            }
        }
        return case3;
    }

    private <T> boolean findEntriesResponses2(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, ChoiceResponseCodes cResponseCodes) {
        boolean case2;
        boolean bl = case2 = cResponseCodes.getGroupRefs() != null && cResponseCodes.getGroupRefs().getRefs() != null && !cResponseCodes.getGroupRefs().getRefs().isEmpty();
        if (case2) {
            for (Object obj : cResponseCodes.getGroupRefs().getRefs()) {
                if (!GroupResponseCodes.class.isInstance(obj)) continue;
                this.findEntries(searchResultClass, resultList, ds, (GroupResponseCodes)obj);
            }
        }
        return case2;
    }

    private <T> boolean findEntriesResponses1(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, ChoiceResponseCodes cResponseCodes) {
        Object obj;
        boolean case1;
        boolean bl = case1 = cResponseCodes.getGroupRef() != null && cResponseCodes.getGroupRef().getRef() != null && !cResponseCodes.getGroupRef().getRef().isEmpty();
        if (case1 && GroupResponseCodes.class.isInstance(obj = cResponseCodes.getGroupRef().getRef().get(0))) {
            this.findEntries(searchResultClass, resultList, ds, (GroupResponseCodes)obj);
        }
        return case1;
    }

    private <T> void findEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, Command command) {
        if (command != null) {
            CommandSearcher cs = ds.getCommandSearcher();
            if (!resultList.contains(command) && (cs == null || cs.matches(command))) {
                if (command.getResponseCodes() == null) {
                    resultList.add(searchResultClass.cast(command));
                } else {
                    ResponseCodeSearcher rcs = ds.getResponseCodeSearcher();
                    if (rcs == null || rcs.matches(command.getResponseCodes())) {
                        resultList.add(searchResultClass.cast(command));
                    }
                }
            }
        }
    }

    private <T> void findEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, Commands commands) {
        if (commands != null) {
            this.findCommandEntries(searchResultClass, resultList, ds, commands.getCommand());
        }
    }

    private <T> void findEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, GroupCommands groupCommands) {
        CommandSearcher cs;
        if (groupCommands != null && ((cs = ds.getCommandSearcher()) == null || cs.matches(groupCommands))) {
            this.findEntries(searchResultClass, resultList, ds, groupCommands.getCommands());
        }
    }

    private <T> void findEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, GroupResponseCodes groupResponseCodes) {
        ResponseCodeSearcher rcs;
        if (groupResponseCodes != null && ((rcs = ds.getResponseCodeSearcher()) == null || rcs.matches(groupResponseCodes))) {
            this.findEntries(searchResultClass, resultList, ds, groupResponseCodes.getResponseCodes());
        }
    }

    private <T> void findEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, GroupsCommands groupsCommands) {
        if (groupsCommands != null) {
            this.findGroupCommandsEntries(searchResultClass, resultList, ds, groupsCommands.getGroup());
        }
    }

    private <T> void findEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, GroupsResponseCodes groupsResponseCodes) {
        if (groupsResponseCodes != null) {
            this.findGroupResponseCodesEntries(searchResultClass, resultList, ds, groupsResponseCodes.getGroup());
        }
    }

    private <T> void findEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, RefGroupCommands refGroupCommands) {
        Object obj;
        if (refGroupCommands != null && refGroupCommands.getRef() != null && !refGroupCommands.getRef().isEmpty() && GroupCommands.class.isInstance(obj = refGroupCommands.getRef().get(0))) {
            this.findEntries(searchResultClass, resultList, ds, (GroupCommands)obj);
        }
    }

    private <T> void findEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, RefGroupResponseCodes refGroupResponseCodes) {
        Object obj;
        if (refGroupResponseCodes != null && refGroupResponseCodes.getRef() != null && !refGroupResponseCodes.getRef().isEmpty() && GroupResponseCodes.class.isInstance(obj = refGroupResponseCodes.getRef().get(0))) {
            this.findEntries(searchResultClass, resultList, ds, (GroupResponseCodes)obj);
        }
    }

    private <T> void findEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, ResponseCode responseCode) {
        if (responseCode != null) {
            ResponseCodeSearcher rcs = ds.getResponseCodeSearcher();
            if (!resultList.contains(responseCode) && (rcs == null || rcs.matches(responseCode))) {
                if (responseCode.getCommands() == null) {
                    resultList.add(searchResultClass.cast(responseCode));
                } else {
                    CommandSearcher cs = ds.getCommandSearcher();
                    if (cs == null || cs.matches(responseCode.getCommands())) {
                        resultList.add(searchResultClass.cast(responseCode));
                    }
                }
            }
        }
    }

    private <T> void findEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, ResponseCodes responseCodes) {
        if (responseCodes != null) {
            this.findResponseCodeEntries(searchResultClass, resultList, ds, responseCodes.getResponseCode());
        }
    }

    private <T> void findGroupCommandsEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, List<GroupCommands> groupCommandsList) {
        if (groupCommandsList != null && !groupCommandsList.isEmpty()) {
            for (GroupCommands groupCommands : groupCommandsList) {
                this.findEntries(searchResultClass, resultList, ds, groupCommands);
            }
        }
    }

    private <T> void findGroupResponseCodesEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, List<GroupResponseCodes> groupResponseCodesList) {
        if (groupResponseCodesList != null && !groupResponseCodesList.isEmpty()) {
            for (GroupResponseCodes groupResponseCodes : groupResponseCodesList) {
                this.findEntries(searchResultClass, resultList, ds, groupResponseCodes);
            }
        }
    }

    private <T> void findCommandEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, List<Command> commandList) {
        if (commandList != null && !commandList.isEmpty()) {
            for (Command command : commandList) {
                this.findEntries(searchResultClass, resultList, ds, command);
            }
        }
    }

    private <T> void findResponseCodeEntries(Class<T> searchResultClass, List<T> resultList, DiscreteSearcher ds, List<ResponseCode> responseCodeList) {
        if (responseCodeList != null && !responseCodeList.isEmpty()) {
            for (ResponseCode responseCode : responseCodeList) {
                this.findEntries(searchResultClass, resultList, ds, responseCode);
            }
        }
    }
}

