/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.asic;

import de.governikus.csl.uom.ReferenceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsicReferenceResolver
implements ReferenceResolver {
    private Map<String, File> files;
    private static final Logger LOGGER = LoggerFactory.getLogger(AsicReferenceResolver.class);

    public AsicReferenceResolver(Map<String, File> contentFiles) {
        this.files = contentFiles;
    }

    public InputStream getReference(String uri) {
        Iterator<Map.Entry<String, File>> iterator;
        if (uri == null && this.files != null && this.files.size() == 1 && (iterator = this.files.entrySet().iterator()).hasNext()) {
            Map.Entry<String, File> entry = iterator.next();
            File file = entry.getValue();
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Can't get reference.", (Throwable)e);
                return null;
            }
        }
        URI suri = null;
        try {
            suri = new URI(uri);
            if (suri.getScheme() != null && !"file".equals(suri.getScheme())) {
                return null;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Can't get reference.", (Throwable)ex);
            return null;
        }
        File file = null;
        if (this.files != null) {
            int startPos;
            String key = suri.getPath();
            while ((file = this.files.get(key)) == null && (startPos = key.indexOf("/")) >= 0 && (key = key.substring(startPos + 1)).length() >= 0) {
            }
        }
        try {
            return file != null ? new FileInputStream(file) : null;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Can't get reference.", (Throwable)e);
            return null;
        }
    }

    public boolean canResolve(String uri) {
        int startPos;
        if (uri == null) {
            return this.files != null && this.files.size() == 1;
        }
        URI suri = null;
        try {
            suri = new URI(uri);
            if (suri.getScheme() != null && !"file".equals(suri.getScheme())) {
                return false;
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Can`t process URI.", (Throwable)ex);
            return false;
        }
        File file = null;
        String key = suri.getPath();
        while ((file = this.files.get(key)) == null && (startPos = key.indexOf("/")) >= 0 && (key = key.substring(startPos + 1)).length() >= 0) {
        }
        return file != null;
    }

    public String reverseResolveURI(File file) {
        if (this.files != null && this.files.size() > 0) {
            for (Map.Entry<String, File> entry : this.files.entrySet()) {
                if (!entry.getValue().equals(file)) continue;
                return entry.getKey();
            }
        }
        return null;
    }
}

