/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.asic;

import de.governikus.csl.asic.AsicContainerType;
import de.governikus.csl.asic.AsicContainerValidator;
import de.governikus.csl.asic.AsicDataExtractor;
import de.governikus.csl.asic.AsicParser;
import de.governikus.csl.asic.AsicSignedDocument;
import de.governikus.csl.cades.CAdESDocument;
import de.governikus.csl.cades.CAdESPlugin;
import de.governikus.csl.core.impl.BaseObjectToValidate;
import de.governikus.csl.ers.ERSDocument;
import de.governikus.csl.ers.ERSPlugin;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.utils.MagicBytes;
import de.governikus.csl.validate.svp.AsicDocumentValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validation.AbstractContainerDocumentPlugin;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.PluginPriority;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.tsp.TSPPlugin;
import de.governikus.csl.xades.XAdESDocument;
import de.governikus.csl.xades.XAdESPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

@PluginType(id=Plugin.PluginID.VALIDATE_ASIC, type=ValidatePlugin.class)
@PluginPriority(priority=10000L)
public class AsicPlugin
extends AbstractContainerDocumentPlugin<AsicSignedDocument, Signature, AsicDocumentValidationResult, SignatureValidationResult, SignatureValidationContext> {
    private static final byte[] MIMETYPE_FILENAME_BYTES = "mimetype".getBytes();
    private static final byte[] MIMETYPE_FILE_COMPRESSION_BYTES = new byte[]{0, 0};
    private static final byte[] MIMETYPE_FILENAME_LENGHT_BYTES = new byte[]{8, 0};
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{"asics", "scs", "asice", "sce", ".zip"};
    private static final List<String> SUPPORTED_MIMETYPES_LIST = Arrays.asList("application/vnd.etsi.asic-e+zip", "application/vnd.etsi.asic-s+zip");
    private CAdESPlugin cadesPlugin;
    private XAdESPlugin xadesPlugin;
    private ERSPlugin ersPlugin;
    private TSPPlugin tspPlugin;
    private static DataExtractor<? super AsicSignedDocument, ? super AsicDocumentValidationResult> docDataExtractor;

    public AsicPlugin() {
        super(Signature.class, SignatureValidationContext.class);
    }

    public AsicPlugin(XAdESPlugin xadesPlugin, CAdESPlugin cadesPlugin, ERSPlugin ersPlugin, TSPPlugin tspPlugin) {
        super(Signature.class, SignatureValidationContext.class);
        this.xadesPlugin = xadesPlugin;
        this.cadesPlugin = cadesPlugin;
        this.ersPlugin = ersPlugin;
        this.tspPlugin = tspPlugin;
    }

    public ObjectValidator getObjectValidator(SignedData doc, TempDataManager tempDataManager, IncludedFileValidator requestProcessor) throws ValidatePluginException {
        AsicContainerType asicType = this.getAsicContainerTypeFromZipFile(doc.getSignature());
        if (asicType == null && doc.getSignature().getName() != null && doc.getSignature().getName().toLowerCase(Locale.ENGLISH).endsWith(".zip")) {
            return null;
        }
        try {
            AsicParser parser = new AsicParser(this.xadesPlugin, this.cadesPlugin, this.ersPlugin, this.tspPlugin, tempDataManager, this.configuration.getAlgorithmManager(), asicType);
            AsicSignedDocument asicContainer = parser.loadDocument(doc);
            return new AsicContainerValidator(this, asicContainer, this.configuration, requestProcessor);
        }
        catch (Exception e) {
            throw new ValidatePluginException((ValidatePlugin)this, "Can't parse document", (Throwable)e);
        }
    }

    public MagicBytes getMagicBytesOfDocumentFormat() {
        return MagicBytes.MAGIC_BYTES_ZIP;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private AsicContainerType getAsicContainerTypeFromZipFile(Document document) {
        block22: {
            if (document == null) {
                return null;
            }
            int bytesToRead = 69;
            try {
                Throwable throwable = null;
                try (InputStream is = document.getInputStream();){
                    byte[] data = new byte[bytesToRead];
                    if (IOUtils.read((InputStream)is, (byte[])data, (int)0, (int)bytesToRead) < bytesToRead || !Arrays.equals(MIMETYPE_FILE_COMPRESSION_BYTES, Arrays.copyOfRange(data, 8, 10)) || !Arrays.equals(MIMETYPE_FILENAME_LENGHT_BYTES, Arrays.copyOfRange(data, 26, 28)) || !Arrays.equals(MIMETYPE_FILENAME_BYTES, Arrays.copyOfRange(data, 30, 38))) break block22;
                    try {
                        AsicContainerType asicContainerType = AsicContainerType.fromMimetypeBytes((byte[])Arrays.copyOfRange(data, 38, 69));
                        return asicContainerType;
                    }
                    catch (IllegalArgumentException ia_ex) {
                        AsicContainerType asicContainerType;
                        block23: {
                            block24: {
                                asicContainerType = null;
                                if (is == null) break block23;
                                if (throwable == null) break block24;
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block23;
                            }
                            is.close();
                        }
                        return asicContainerType;
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public ObjectValidator getDocumentValidatorForContainedDocument(ObjectToValidate<?> content, IncludedFileValidator requestProcessor) {
        if (content instanceof XAdESDocument) {
            return this.xadesPlugin.getDocumentValidator((ObjectToValidate)((XAdESDocument)content), requestProcessor);
        }
        if (content instanceof CAdESDocument) {
            return this.cadesPlugin.getDocumentValidator((ObjectToValidate)((CAdESDocument)content), requestProcessor);
        }
        if (content instanceof ERSDocument) {
            return this.ersPlugin.getDocumentValidator((ObjectToValidate)((ERSDocument)content), requestProcessor);
        }
        return this.tspPlugin.getDocumentValidator((ObjectToValidate)((BaseObjectToValidate)content), requestProcessor);
    }

    public AsicSignedDocument parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        return null;
    }

    public synchronized DataExtractor<? super AsicSignedDocument, ? super AsicDocumentValidationResult> getDocumentDataExtractor() {
        if (docDataExtractor == null) {
            docDataExtractor = new AsicDataExtractor();
        }
        return docDataExtractor;
    }

    protected AsicDocumentValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        AsicDocumentValidationResult res = new AsicDocumentValidationResult();
        res.setObjectTypeID(Plugin.PluginID.VALIDATE_ASIC.getID());
        return res;
    }

    protected SignatureValidationResult createSignatureValidationResultStructure() {
        return null;
    }

    public SignatureValidationContext createContext(Signature signature, ValidationPolicyType policy) {
        return null;
    }

    public String[] getSupportedFileExtensions() {
        return SUPPORTED_FILE_EXTENSIONS;
    }

    public synchronized void initialize(InstanceProvider instanceProvider) throws Exception {
        super.initialize(instanceProvider);
        if (instanceProvider != null) {
            this.xadesPlugin = (XAdESPlugin)instanceProvider.getPlugin(Plugin.PluginID.VALIDATE_XADES, XAdESPlugin.class);
            this.cadesPlugin = (CAdESPlugin)instanceProvider.getPlugin(Plugin.PluginID.VALIDATE_CADES, CAdESPlugin.class);
            this.tspPlugin = (TSPPlugin)instanceProvider.getPlugin(Plugin.PluginID.VALIDATE_TSP, TSPPlugin.class);
        }
    }

    public boolean supportsMimeType(String mimetype) {
        if (mimetype != null) {
            return SUPPORTED_MIMETYPES_LIST.contains(mimetype);
        }
        return false;
    }
}

