/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.asic;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.asic.ASiCTypeConformityChecker;
import de.governikus.csl.asic.AsicContainerType;
import de.governikus.csl.asic.AsicReferenceResolver;
import de.governikus.csl.asic.AsicSignedDocument;
import de.governikus.csl.cades.CAdESDocument;
import de.governikus.csl.cades.CAdESPlugin;
import de.governikus.csl.core.impl.BaseObjectToValidate;
import de.governikus.csl.core.impl.BaseSignature;
import de.governikus.csl.core.impl.BaseSignedContentPart;
import de.governikus.csl.ers.ERSDocument;
import de.governikus.csl.ers.ERSPlugin;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.ReferenceResolver;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.core.impl.SimpleSignedData;
import de.governikus.csl.uom.impl.DocumentImpl;
import de.governikus.csl.uom.impl.FileDocumentAltNameImpl;
import de.governikus.csl.uom.impl.FileStreamProvider;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.SignedContentPart;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.utils.AbstractDocumentParser;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.er.ERS;
import de.governikus.csl.validation.tsp.TSPPlugin;
import de.governikus.csl.xades.XAdESDocument;
import de.governikus.csl.xades.XAdESPlugin;
import de.governikus.csl.xades.XAdESUtil;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import lombok.Generated;
import org.etsi.uri._02918.v1_3_1.ASiCManifestType;
import org.etsi.uri._02918.v1_3_1.DataObjectReferenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2000._09.xmldsig.DigestMethodType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AsicParser
extends AbstractDocumentParser<AsicSignedDocument> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsicParser.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AsicParser.class);
    private static final String MIMETYPE_NAME = "mimetype";
    private static JAXBContext jaxBContext;
    private static final String XPATH_FORMAT = "/ASiCManifest/DataObjectReference[@URI='%s']/DigestValue";
    private DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilderFactory dbFactoryUnaware;
    private org.w3c.dom.Document manifestDoc;
    private final Pattern xadesMatcher;
    private final Pattern cadesMatcher;
    private final Pattern ersMatcher;
    private final Pattern xmlErsMatcher;
    private final Pattern tstMatcher;
    private final Pattern manifestMatcher;
    private final Pattern archiveManifestMatcher;
    private final Pattern ersManifestMatcher;
    private XAdESPlugin xadesPlugin;
    private CAdESPlugin cadesPlugin;
    private ERSPlugin ersPlugin;
    private TSPPlugin tspPlugin;
    private TempDataManager tempDataManager;
    private AlgorithmManager algorithmManager;
    private AsicContainerType asicType;

    public AsicParser(XAdESPlugin xadesPlugin, CAdESPlugin cadesPlugin, ERSPlugin ersPlugin, TSPPlugin tspPlugin, TempDataManager tempDataManager, AlgorithmManager algorithmManager, AsicContainerType asicType) throws JAXBException {
        SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)this.dbFactory);
        this.dbFactory.setNamespaceAware(true);
        this.dbFactoryUnaware = DocumentBuilderFactory.newInstance();
        SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)this.dbFactoryUnaware);
        this.dbFactoryUnaware.setNamespaceAware(false);
        this.xadesMatcher = Pattern.compile("^(META-INF/).*(signatures).*(.xml)$");
        this.cadesMatcher = Pattern.compile("^(META-INF/).*(signature).*(.p7s)$");
        this.ersMatcher = Pattern.compile("^(META-INF/).*(evidencerecord).*(.ers)$");
        this.xmlErsMatcher = Pattern.compile("^(META-INF/).*(evidencerecord).*(.xml)$");
        this.tstMatcher = Pattern.compile("^(META-INF/).*(timestamp).*(.tst)$");
        this.manifestMatcher = Pattern.compile("^(META-INF/)(ASiCManifest).*(.xml)$");
        this.archiveManifestMatcher = Pattern.compile("^(META-INF/)(ASiCArchiveManifest).*(.xml)$");
        this.ersManifestMatcher = Pattern.compile("^(META-INF/)(ASiCEvidenceRecordManifest).*(.xml)$");
        this.tempDataManager = tempDataManager;
        this.xadesPlugin = xadesPlugin;
        this.cadesPlugin = cadesPlugin;
        this.ersPlugin = ersPlugin;
        this.tspPlugin = tspPlugin;
        this.algorithmManager = algorithmManager;
        this.asicType = asicType;
    }

    public AsicSignedDocument loadDocument(SignedData sda) throws Exception {
        HashMap<String, File> manifestFiles = new HashMap<String, File>();
        HashMap<String, File> archiveManifestFiles = new HashMap<String, File>();
        HashMap<String, File> ersManifestFiles = new HashMap<String, File>();
        HashMap<String, File> xadesSignatures = new HashMap<String, File>();
        HashMap<String, File> cadesSignatures = new HashMap<String, File>();
        HashMap<String, File> tspSignatures = new HashMap<String, File>();
        HashMap<String, File> ersSignatures = new HashMap<String, File>();
        HashMap<String, File> xmlErsSignatures = new HashMap<String, File>();
        HashMap<String, File> contentFiles = new HashMap<String, File>();
        HashMap<String, File> allFiles = new HashMap<String, File>();
        File tmpFile = null;
        Document d = sda.getSignature();
        AsicSignedDocument asicDocument = new AsicSignedDocument();
        asicDocument.setName(d.getName());
        boolean isZip = false;
        try (ZipInputStream zip = new ZipInputStream(d.getInputStream());){
            ZipEntry zipEntry = null;
            while ((zipEntry = zip.getNextEntry()) != null) {
                String name;
                isZip = true;
                if (zipEntry.isDirectory() || (name = zipEntry.getName()).equalsIgnoreCase(MIMETYPE_NAME)) continue;
                if (this.manifestMatcher.matcher(name).matches()) {
                    tmpFile = this.tempDataManager.createTempFile("manifest", ".xml");
                    manifestFiles.put(name, tmpFile);
                } else if (this.archiveManifestMatcher.matcher(name).matches()) {
                    tmpFile = this.tempDataManager.createTempFile("archiveManifest", ".xml");
                    archiveManifestFiles.put(name, tmpFile);
                } else if (this.ersManifestMatcher.matcher(name).matches()) {
                    tmpFile = this.tempDataManager.createTempFile("ersManifest", ".xml");
                    ersManifestFiles.put(name, tmpFile);
                } else if (this.xadesMatcher.matcher(name).matches()) {
                    tmpFile = this.tempDataManager.createTempFile("xades", ".xml");
                    xadesSignatures.put(name, tmpFile);
                } else if (this.cadesMatcher.matcher(name).matches()) {
                    tmpFile = this.tempDataManager.createTempFile("cades", ".cms");
                    cadesSignatures.put(name, tmpFile);
                } else if (this.tstMatcher.matcher(name).matches()) {
                    tmpFile = this.tempDataManager.createTempFile("timestamp", ".tsp");
                    tspSignatures.put(name, tmpFile);
                } else if (this.ersMatcher.matcher(name).matches()) {
                    tmpFile = this.tempDataManager.createTempFile("ers", ".ers");
                    ersSignatures.put(name, tmpFile);
                } else if (this.xmlErsMatcher.matcher(name).matches()) {
                    tmpFile = this.tempDataManager.createTempFile("xmlers", ".xml");
                    xmlErsSignatures.put(name, tmpFile);
                } else if (!name.toUpperCase(Locale.ENGLISH).startsWith("META-INF/")) {
                    tmpFile = this.tempDataManager.createTempFile("content", null);
                    contentFiles.put(name, tmpFile);
                }
                if (tmpFile == null) continue;
                Files.copy(zip, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                tmpFile = null;
            }
        }
        if (!isZip) {
            throw new CoreException("The data isn't a zip archive");
        }
        if (archiveManifestFiles.size() > 0) {
            asicDocument.addFormatCheckResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"asic_archive_manifest_files_not_supported"}));
        }
        allFiles.putAll(manifestFiles);
        allFiles.putAll(archiveManifestFiles);
        allFiles.putAll(ersManifestFiles);
        allFiles.putAll(xadesSignatures);
        allFiles.putAll(cadesSignatures);
        allFiles.putAll(tspSignatures);
        allFiles.putAll(ersSignatures);
        allFiles.putAll(xmlErsSignatures);
        allFiles.putAll(contentFiles);
        AsicReferenceResolver resolver = new AsicReferenceResolver(allFiles);
        manifestFiles.putAll(ersManifestFiles);
        List<ObjectToValidate<? extends Signature>> objectsToValidate = this.parseManifest(asicDocument, manifestFiles, cadesSignatures, ersSignatures, tspSignatures, contentFiles, resolver, this.asicType);
        int numManifests = objectsToValidate.size();
        List<XAdESDocument> xadesObjectsToValidate = this.parseXAdESSignatures(xadesSignatures, contentFiles, resolver);
        int numXMLSignatureFiles = xadesObjectsToValidate.size();
        for (XAdESDocument xs : xadesObjectsToValidate) {
            objectsToValidate.add((ObjectToValidate<? extends Signature>)xs);
        }
        List<CAdESDocument> cadesObjectsToValidate = this.parseCAdESSignatures(cadesSignatures, contentFiles, resolver);
        int numCAdESSignatureFiles = cadesObjectsToValidate.size();
        for (CAdESDocument xs : cadesObjectsToValidate) {
            objectsToValidate.add((ObjectToValidate<? extends Signature>)xs);
        }
        List<ERSDocument> ersObjectsToValidate = this.parseEvidenceRecords(ersSignatures, contentFiles, resolver, this.asicType);
        int numERSSignatureFiles = ersObjectsToValidate.size();
        for (ERSDocument ers : ersObjectsToValidate) {
            objectsToValidate.add((ObjectToValidate<? extends Signature>)ers);
        }
        List<BaseObjectToValidate<Timestamp>> timestamps = this.parseTimestamps(tspSignatures, contentFiles, resolver);
        int numTimestamps = timestamps.size();
        for (BaseObjectToValidate<Timestamp> xs : timestamps) {
            objectsToValidate.add((ObjectToValidate<? extends Signature>)xs);
        }
        if (objectsToValidate.isEmpty() && asicDocument.getFormatCheckResultList().isEmpty()) {
            throw new CoreException("The container does not contain any known files");
        }
        asicDocument.setAsicContainerType(this.asicType);
        asicDocument.setContainedObjectsToValidate(objectsToValidate);
        ASiCTypeConformityChecker conformityChecker = new ASiCTypeConformityChecker();
        asicDocument.addFormatCheckResult(conformityChecker.checkContainerTypeConformance(this.asicType, numManifests, numXMLSignatureFiles, numCAdESSignatureFiles, numERSSignatureFiles, numTimestamps, contentFiles.size()));
        return asicDocument;
    }

    private List<ObjectToValidate<? extends Signature>> parseManifest(AsicSignedDocument asicDocument, Map<String, File> manifestFiles, Map<String, File> cadesSignatures, Map<String, File> ersSignatures, Map<String, File> tspSignatures, Map<String, File> contentFiles, AsicReferenceResolver resolver, AsicContainerType asicType) throws JAXBException, IOException, XMLStreamException, ValidatePluginException, FactoryConfigurationError, SAXException, ParserConfigurationException, XPathExpressionException, XPathFactoryConfigurationException {
        ArrayList<ObjectToValidate<? extends Signature>> objectsToValidate = new ArrayList<ObjectToValidate<? extends Signature>>();
        for (Map.Entry<String, File> manifestEntry : manifestFiles.entrySet()) {
            ASiCManifestType manifest = this.getManifest(asicDocument, manifestEntry);
            if (manifest == null) continue;
            String uri = manifest.getSigReference().getURI();
            List parsedSignatures = null;
            File cadesSignature = cadesSignatures.get(uri);
            File ersFile = ersSignatures.get(uri);
            if (cadesSignature != null) {
                SignedData sfa = this.createSignedData(cadesSignature, Collections.singleton(manifestEntry.getValue()), resolver);
                CAdESDocument parsedDocument = this.cadesPlugin.parseDocument(sfa, this.tempDataManager);
                parsedSignatures = parsedDocument.getSignatures();
                objectsToValidate.add((ObjectToValidate<? extends Signature>)parsedDocument);
                parsedDocument.setName(uri);
                cadesSignatures.remove(uri);
            } else if (ersFile != null) {
                TreeMap<String, File> tmp = new TreeMap<String, File>();
                tmp.putAll(contentFiles);
                tmp.put(manifestEntry.getKey(), manifestEntry.getValue());
                List<ERSDocument> evidenceRecords = this.parseEvidenceRecords(ersSignatures, tmp, resolver, asicType);
                for (ERSDocument er : evidenceRecords) {
                    parsedSignatures = er.getSignatures();
                    objectsToValidate.add((ObjectToValidate<? extends Signature>)er);
                    er.setName(uri);
                    ersSignatures.remove(uri);
                }
            } else {
                File tspSignature = tspSignatures.get(uri);
                if (tspSignature != null) {
                    SignedData sfa = this.createSignedData(tspSignature, Collections.singleton(manifestEntry.getValue()), resolver);
                    BaseObjectToValidate parsedDocument = this.tspPlugin.parseDocument(sfa, this.tempDataManager);
                    objectsToValidate.add((ObjectToValidate<? extends Signature>)parsedDocument);
                    parsedSignatures = parsedDocument.getSignatures();
                    parsedDocument.setName(uri);
                    tspSignatures.remove(uri);
                } else {
                    LOGGER.warn("A signature in ASiC-manifest could not be found");
                    continue;
                }
            }
            if (ersFile != null) {
                for (Signature sig : parsedSignatures) {
                    if (!(sig instanceof ERS)) continue;
                    ERS ers = (ERS)sig;
                    for (DataObjectReferenceType reference : manifest.getDataObjectReference()) {
                        String contentName = reference.getURI();
                        String algoNameUrl = reference.getDigestMethod().getAlgorithm();
                        String algoName = this.algorithmManager.getDigestAlgorithmByURL(algoNameUrl).getJCAName();
                        String xPath = String.format(XPATH_FORMAT, contentName);
                        NodeList xPathResult = (NodeList)XPathFactory.newInstance().newXPath().compile(xPath).evaluate(this.manifestDoc, XPathConstants.NODESET);
                        String digestValueText = xPathResult.item(0).getTextContent();
                        ERS.DigestKey digestKey = ERS.DigestKey.builder().algoName(algoName).contentName(reference.getURI()).build();
                        ers.getManifestDigestsByAlgoJcaName().put(digestKey, digestValueText);
                    }
                }
            }
            List<SignedContentPart> contentParts = this.createSignedContentParts(parsedSignatures, contentFiles, manifest);
            this.addToSignature(parsedSignatures, contentParts);
        }
        return objectsToValidate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ASiCManifestType getManifest(AsicSignedDocument asicDocument, Map.Entry<String, File> manifestEntry) throws FactoryConfigurationError, JAXBException, IOException, SAXException, ParserConfigurationException {
        try (FileInputStream is2 = new FileInputStream(manifestEntry.getValue());){
            this.manifestDoc = this.dbFactoryUnaware.newDocumentBuilder().parse(is2);
        }
        UnmarshalException ue = null;
        try (FileInputStream is = new FileInputStream(manifestEntry.getValue());){
            org.w3c.dom.Document tmpDoc = this.dbFactory.newDocumentBuilder().parse(is);
            Unmarshaller unmarshaller = jaxBContext.createUnmarshaller();
            Object o = unmarshaller.unmarshal((Node)tmpDoc);
            ASiCManifestType aSiCManifestType = (ASiCManifestType)XAdESUtil.getInstanceOf((Object)o, ASiCManifestType.class, (String)"ASiCManifest");
            return aSiCManifestType;
        }
        catch (UnmarshalException um_ex) {
            ue = um_ex;
            this.addParseManifestFormatFailure(asicDocument, manifestEntry, ue);
            return null;
        }
    }

    private void addParseManifestFormatFailure(AsicSignedDocument asicDocument, Map.Entry<String, File> manifestEntry, UnmarshalException ue) {
        ValidationMessageCode vmCode = SVPFactory.createMessageCode((String)"asic_cannot_parse_asic_manifest", (Object[])new Object[]{manifestEntry.getKey()});
        asicDocument.addFormatCheckResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)vmCode));
        LOGGER.warn("The ASiCManifest '{}' couldn't be parsed successfully!", (Object)manifestEntry.getKey(), (Object)ue);
    }

    private List<SignedContentPart> createSignedContentParts(List<? extends Signature> parsedSignatures, Map<String, File> contentFiles, ASiCManifestType manifest) {
        Map manifestDigestsByAlgoJcaName = null;
        for (Signature signature : parsedSignatures) {
            if (!(signature instanceof ERS)) continue;
            ERS ers = (ERS)signature;
            manifestDigestsByAlgoJcaName = ers.getManifestDigestsByAlgoJcaName();
            break;
        }
        ArrayList<SignedContentPart> contentParts = new ArrayList<SignedContentPart>();
        for (DataObjectReferenceType reference : manifest.getDataObjectReference()) {
            String uri = reference.getURI();
            File referencedContent = contentFiles.get(uri);
            if (referencedContent == null) {
                LOGGER.warn("A referenced content file in ASiC-manifest could not be found");
                continue;
            }
            DigestMethodType digestMethod = reference.getDigestMethod();
            String algorithm = digestMethod.getAlgorithm();
            DigestAlgorithm digestAlgorithm = this.algorithmManager.getDigestAlgorithmByURL(algorithm);
            byte[] digestValue = reference.getDigestValue();
            digestValue = this.getManuallyReadDigestValue(manifestDigestsByAlgoJcaName, reference, uri, digestValue);
            BaseSignedContentPart cp = new BaseSignedContentPart((StreamProvider)new FileStreamProvider(referencedContent), digestValue, digestAlgorithm);
            cp.setContentName(uri);
            contentParts.add((SignedContentPart)cp);
        }
        return contentParts;
    }

    private byte[] getManuallyReadDigestValue(Map<ERS.DigestKey, String> manifestDigestsByAlgoJcaName, DataObjectReferenceType reference, String uri, byte[] digestValue) {
        if (manifestDigestsByAlgoJcaName != null && !Boolean.getBoolean("de.governikus.csl.asic.ers.manifest.guess_misformatted_hash")) {
            Optional<String> digestValue2 = manifestDigestsByAlgoJcaName.entrySet().stream().filter(e -> ((ERS.DigestKey)e.getKey()).getContentName().equals(reference.getURI())).map(Map.Entry::getValue).findFirst();
            if (digestValue2.isPresent()) {
                digestValue = this.getBytesForDigest(uri, digestValue2.get());
            } else {
                log.debug("Could not get digest value for {} from {}", (Object)uri, manifestDigestsByAlgoJcaName);
                return new byte[0];
            }
        }
        return digestValue;
    }

    private byte[] getBytesForDigest(String contentName, String input) {
        try {
            return Base64.getDecoder().decode(input);
        }
        catch (Exception e) {
            log.error("Could not get hash bytes from hash string in manifest for {}, math check for manifest hashes will fail.", (Object)contentName, (Object)e);
            return new byte[0];
        }
    }

    private void addToSignature(List<? extends Signature> parsedSignatures, List<SignedContentPart> contentParts) {
        for (Signature signature : parsedSignatures) {
            BaseSignature sig = (BaseSignature)signature;
            List signedContentParts = signature.getSignedContentParts();
            if (signedContentParts != null) {
                contentParts.addAll(signedContentParts);
            }
            sig.setSignedContentParts(contentParts);
        }
    }

    private List<BaseObjectToValidate<Timestamp>> parseTimestamps(Map<String, File> timestamps, Map<String, File> contentFiles, AsicReferenceResolver resolver) {
        ArrayList<BaseObjectToValidate<Timestamp>> result = new ArrayList<BaseObjectToValidate<Timestamp>>();
        for (Map.Entry<String, File> entry : timestamps.entrySet()) {
            SignedData sfa = this.createSignedData(entry.getValue(), contentFiles.values(), resolver);
            try {
                BaseObjectToValidate parsedDocument = this.tspPlugin.parseDocument(sfa, this.tempDataManager);
                parsedDocument.setName(entry.getKey());
                result.add((BaseObjectToValidate<Timestamp>)parsedDocument);
            }
            catch (ValidatePluginException e) {
                LOGGER.error("Can't parse timestamp.", (Throwable)e);
            }
        }
        return result;
    }

    private List<CAdESDocument> parseCAdESSignatures(Map<String, File> cadesSignatures, Map<String, File> contentFiles, AsicReferenceResolver resolver) throws ValidatePluginException {
        ArrayList<CAdESDocument> result = new ArrayList<CAdESDocument>();
        for (Map.Entry<String, File> entry : cadesSignatures.entrySet()) {
            SignedData sfa = this.createSignedData(entry.getValue(), contentFiles.values(), resolver);
            CAdESDocument parsedDocument = this.cadesPlugin.parseDocument(sfa, this.tempDataManager);
            parsedDocument.setName(entry.getKey());
            result.add(parsedDocument);
        }
        return result;
    }

    private List<XAdESDocument> parseXAdESSignatures(Map<String, File> xadesSignatures, Map<String, File> contentFiles, AsicReferenceResolver resolver) {
        ArrayList<XAdESDocument> result = new ArrayList<XAdESDocument>();
        for (Map.Entry<String, File> entry : xadesSignatures.entrySet()) {
            SignedData sfa = this.createSignedData(entry.getValue(), contentFiles.values(), resolver);
            try {
                XAdESDocument parsedDocument = this.xadesPlugin.parseDocument(sfa, this.tempDataManager);
                parsedDocument.setName(entry.getKey());
                result.add(parsedDocument);
            }
            catch (ValidatePluginException e) {
                LOGGER.error("Can not parse XAdES signature");
            }
        }
        return result;
    }

    private List<ERSDocument> parseEvidenceRecords(Map<String, File> evidenceRecords, Map<String, File> contentFiles, AsicReferenceResolver resolver, AsicContainerType asicType) {
        ArrayList<ERSDocument> result = new ArrayList<ERSDocument>();
        for (Map.Entry<String, File> entry : evidenceRecords.entrySet()) {
            SignedData sfa = this.createSignedData(entry.getValue(), contentFiles.values(), resolver);
            try {
                ERSDocument parsedDocument = this.ersPlugin.parseDocument(sfa, this.tempDataManager);
                parsedDocument.setName(entry.getKey());
                if (AsicContainerType.ASIC_E.equals((Object)asicType)) {
                    parsedDocument.getSignatures().stream().map(ERS.class::cast).forEach(e -> e.setContainedInAsicE(true));
                }
                result.add(parsedDocument);
            }
            catch (ValidatePluginException e2) {
                LOGGER.error("Can not parse evidence record");
            }
        }
        return result;
    }

    private SignedData createSignedData(File f, Collection<File> contentFiles, AsicReferenceResolver resolver) {
        DataHandler dh = new DataHandler((DataSource)new FileDataSource(f));
        DocumentImpl result = new DocumentImpl("1", f.getName(), dh, "text/xml", (ReferenceResolver)resolver);
        ArrayList<FileDocumentAltNameImpl> contentDocuments = new ArrayList<FileDocumentAltNameImpl>();
        for (File content : contentFiles) {
            FileDocumentAltNameImpl contentDocument = new FileDocumentAltNameImpl(content, "content", resolver.reverseResolveURI(content));
            contentDocuments.add(contentDocument);
        }
        return new SimpleSignedData(contentDocuments, (Document)result);
    }

    static {
        try {
            jaxBContext = JAXBContext.newInstance((Class[])new Class[]{ASiCManifestType.class});
        }
        catch (JAXBException e) {
            log.error("Can't get JAXBContext. ASiC-Containers won't be validated", (Throwable)e);
        }
    }
}

