/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.asic;

import de.governikus.csl.asic.AsicPlugin;
import de.governikus.csl.asic.AsicSignedDocument;
import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.AsicDocumentValidationResult;
import de.governikus.csl.validate.svp.ContainerObjectValidationResult;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.MultipleSignedObjectValidator;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.TypedValidatePlugin;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.policy.EvaluatingPolicyReferenceManager;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import java.util.List;

public class AsicContainerValidator
extends MultipleSignedObjectValidator<AsicSignedDocument, Signature, AsicDocumentValidationResult, SignatureValidationResult, SignatureValidationContext> {
    private final PolicyProviderManager policyProviderManager;
    private final Configuration config;
    private AsicPlugin documentPlugin;

    public AsicContainerValidator(AsicPlugin documentPlugin, AsicSignedDocument parsedDocument, Configuration config, IncludedFileValidator requestProcessor) {
        super((TypedValidatePlugin)documentPlugin, (ObjectToValidate)parsedDocument, config, requestProcessor);
        this.documentPlugin = documentPlugin;
        this.policyProviderManager = config.getPolicyProviderManager();
        this.config = config;
    }

    public ContainerObjectValidationResult validate(DocumentValidationContext context) {
        List policyEntries;
        int maxIncludedFileRecursions;
        int currentIncludedFilesRecursionLevel;
        EvaluatingPolicyReferenceManager policyManager = context.getPolicyManager();
        boolean addResult = false;
        if (policyManager == null) {
            policyManager = new EvaluatingPolicyReferenceManager(this.policyProviderManager);
            context.setPolicyManager(policyManager);
            addResult = true;
        }
        AsicDocumentValidationResult result = (AsicDocumentValidationResult)super.validate(this.doc, context);
        ValidationOptions options = context.getOptions();
        List containedObjectsToValidate = ((AsicSignedDocument)this.doc).getContainedObjectsToValidate();
        if (containedObjectsToValidate != null && (currentIncludedFilesRecursionLevel = context.getIncludedFileRecursionLevel()) < (maxIncludedFileRecursions = Integer.min(this.config.getMaxIncludedFileRecursions(), options.getMaxRecursiveValidationStepsForIncludedFiles()))) {
            List childResults = result.getResultsForContainedObjects();
            for (ObjectToValidate otv : containedObjectsToValidate) {
                DocumentValidationContext contextNew = new DocumentValidationContext();
                contextNew.setOptions(options);
                contextNew.setPolicyManager(policyManager);
                contextNew.setIncludedFileRecursionLevel(currentIncludedFilesRecursionLevel + 1);
                ObjectValidator childObjectValidator = this.documentPlugin.getDocumentValidatorForContainedDocument(otv, this.requestProcessor);
                ObjectValidationResult childResult = childObjectValidator.validate(contextNew);
                childResults.add(childResult);
            }
        }
        if (addResult && (policyEntries = policyManager.getPolicyEntries()) != null) {
            result.getPolicyEntries().addAll(policyEntries);
        }
        return result;
    }
}

