/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.asic;

import de.governikus.csl.asic.AsicContainerType;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.ValidationResult;

public class ASiCTypeConformityChecker {
    public ValidationResult checkContainerTypeConformance(AsicContainerType supposedType, int numManifests, int numXMLSignatureFiles, int numCAdESSignatureFiles, int numERSSignatureFiles, int numTimestamps, int numContentFiles) {
        if (supposedType != null) {
            return this.checkContainerTypeConformanceByMimetype(supposedType, numManifests, numXMLSignatureFiles, numCAdESSignatureFiles, numERSSignatureFiles, numTimestamps, numContentFiles);
        }
        return this.checkContainerTypeConformanceWithoutMimetype(numManifests, numXMLSignatureFiles, numCAdESSignatureFiles, numERSSignatureFiles, numTimestamps, numContentFiles);
    }

    private ValidationResult checkContainerTypeConformanceWithoutMimetype(int numManifests, int numXMLSignatureFiles, int numCAdESSignatureFiles, int numERSSignatureFiles, int numTimestamps, int numContentFiles) {
        if (numManifests > 0) {
            if (numXMLSignatureFiles + numCAdESSignatureFiles + numERSSignatureFiles + numTimestamps > 0) {
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"asic_invalid_type_e"});
            }
        } else if (numXMLSignatureFiles > 0) {
            if (numManifests + numCAdESSignatureFiles + numERSSignatureFiles + numTimestamps > 0) {
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"asic_invalid_type_e"});
            }
        } else if (numCAdESSignatureFiles > 0 ? numContentFiles > 1 || numCAdESSignatureFiles > 1 || numTimestamps > 0 : (numERSSignatureFiles > 0 ? numContentFiles > 1 || numERSSignatureFiles > 1 || numTimestamps > 0 : numTimestamps > 0 && (numTimestamps > 1 || numContentFiles > 1))) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"asic_invalid_type_s"});
        }
        return SVPFactory.createResultOk();
    }

    private ValidationResult checkContainerTypeConformanceByMimetype(AsicContainerType supposedType, int numManifests, int numXMLSignatureFiles, int numCAdESSignatureFiles, int numERSSignatureFiles, int numTimestamps, int numContentFiles) {
        if (supposedType == AsicContainerType.ASIC_E) {
            if (numTimestamps > 0 || numCAdESSignatureFiles > 0 || numManifests + numXMLSignatureFiles <= 0 || numManifests > 0 && numXMLSignatureFiles > 0 || numManifests == 0 && numERSSignatureFiles == 0 && numContentFiles < 1) {
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"asic_invalid_type_e"});
            }
            return SVPFactory.createResultOk();
        }
        if (supposedType == AsicContainerType.ASIC_S) {
            if (numManifests > 0 || numXMLSignatureFiles + numCAdESSignatureFiles + numERSSignatureFiles + numTimestamps > 1 || numContentFiles > 1) {
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"asic_type_detected_as_e_but_has_s_mimetype"});
            }
            return SVPFactory.createResultOk();
        }
        throw new IllegalArgumentException("Unsupported asic-type:" + supposedType);
    }
}

