/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.Objects;

public class CertificateValidity
implements Serializable {
    private static final long serialVersionUID = -8840096915238342503L;
    private PublicKey publicKey;
    private CertificateToken certificateToken;
    private SignerIdentifier signerIdentifier;
    private boolean signerIdMatch;
    private boolean digestPresent;
    private boolean digestEqual;
    private boolean issuerSerialPresent;
    private boolean serialNumberEqual;
    private boolean distinguishedNameEqual;
    private boolean responderIdPresent;
    private boolean responderIdMatch;

    public CertificateValidity(CertificateToken certificateToken) {
        Objects.requireNonNull(certificateToken, "CertificateToken cannot be null!");
        this.certificateToken = certificateToken;
    }

    public CertificateValidity(PublicKey publicKey) {
        Objects.requireNonNull(publicKey, "PublicKey cannot be null!");
        this.publicKey = publicKey;
    }

    public CertificateValidity(SignerIdentifier signerIdentifier) {
        Objects.requireNonNull(signerIdentifier, "CertificateIdentifier cannot be null!");
        this.signerIdentifier = signerIdentifier;
    }

    public PublicKey getPublicKey() {
        return this.certificateToken == null ? this.publicKey : this.certificateToken.getPublicKey();
    }

    public SignerIdentifier getSignerInfo() {
        if (this.certificateToken == null) {
            return this.signerIdentifier;
        }
        SignerIdentifier signerIdentifierFromCert = new SignerIdentifier();
        signerIdentifierFromCert.setIssuerName(this.certificateToken.getIssuerX500Principal());
        signerIdentifierFromCert.setSerialNumber(this.certificateToken.getSerialNumber());
        return signerIdentifierFromCert;
    }

    public CertificateToken getCertificateToken() {
        return this.certificateToken;
    }

    public boolean isSignerIdMatch() {
        return this.signerIdMatch;
    }

    public void setSignerIdMatch(boolean signerIdMatch) {
        this.signerIdMatch = signerIdMatch;
    }

    public boolean isDigestPresent() {
        return this.digestPresent;
    }

    public void setDigestPresent(boolean digestPresent) {
        this.digestPresent = digestPresent;
    }

    public boolean isDigestEqual() {
        return this.digestEqual;
    }

    public void setDigestEqual(boolean digestEqual) {
        this.digestEqual = digestEqual;
    }

    public boolean isIssuerSerialPresent() {
        return this.issuerSerialPresent;
    }

    public void setIssuerSerialPresent(boolean issuerSerialPresent) {
        this.issuerSerialPresent = issuerSerialPresent;
    }

    public boolean isSerialNumberEqual() {
        return this.serialNumberEqual;
    }

    public void setSerialNumberEqual(boolean serialNumberEqual) {
        this.serialNumberEqual = serialNumberEqual;
    }

    public boolean isDistinguishedNameEqual() {
        return this.distinguishedNameEqual;
    }

    public void setDistinguishedNameEqual(boolean distinguishedNameEqual) {
        this.distinguishedNameEqual = distinguishedNameEqual;
    }

    public boolean isResponderIdPresent() {
        return this.responderIdPresent;
    }

    public void setResponderIdPresent(boolean responderIdPresent) {
        this.responderIdPresent = responderIdPresent;
    }

    public boolean isResponderIdMatch() {
        return this.responderIdMatch;
    }

    public void setResponderIdMatch(boolean responderIdMatch) {
        this.responderIdMatch = responderIdMatch;
    }

    public boolean isValid() {
        return this.isDigestEqual() || this.isDistinguishedNameEqual() && this.isSerialNumberEqual() || this.isResponderIdMatch();
    }
}

