/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.tsl;

import eu.europa.esig.dss.spi.tsl.LOTLInfo;
import eu.europa.esig.dss.spi.tsl.TLInfo;
import eu.europa.esig.dss.spi.tsl.TrustServiceProvider;
import eu.europa.esig.dss.spi.tsl.TrustServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.spi.util.TimeDependentValues;
import java.io.Serializable;
import java.util.Objects;

public class TrustProperties
implements Serializable {
    private static final long serialVersionUID = -7460897343036542905L;
    private final LOTLInfo lotlInfo;
    private final TLInfo tlInfo;
    private final TrustServiceProvider trustServiceProvider;
    private final TimeDependentValues<TrustServiceStatusAndInformationExtensions> trustService;

    public TrustProperties(TLInfo tlInfo, TrustServiceProvider trustServiceProvider, TimeDependentValues<TrustServiceStatusAndInformationExtensions> trustService) {
        this(null, tlInfo, trustServiceProvider, trustService);
    }

    public TrustProperties(LOTLInfo lotlInfo, TLInfo tlInfo, TrustServiceProvider trustServiceProvider, TimeDependentValues<TrustServiceStatusAndInformationExtensions> trustService) {
        Objects.requireNonNull(tlInfo, "tlInfo cannot be null!");
        Objects.requireNonNull(trustServiceProvider, "trustServiceProvider cannot be null!");
        Objects.requireNonNull(trustService, "trustService cannot be null!");
        this.lotlInfo = lotlInfo;
        this.tlInfo = tlInfo;
        this.trustServiceProvider = trustServiceProvider;
        this.trustService = trustService;
    }

    public LOTLInfo getLOTLInfo() {
        return this.lotlInfo;
    }

    public TLInfo getTLInfo() {
        return this.tlInfo;
    }

    public TrustServiceProvider getTrustServiceProvider() {
        return this.trustServiceProvider;
    }

    public TimeDependentValues<TrustServiceStatusAndInformationExtensions> getTrustService() {
        return this.trustService;
    }
}

